/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertyXRef;

public class CreateChild
extends CreateRelationship {
    private Entity parentOrFamily;
    private boolean male;

    public CreateChild(Fam fam, boolean bl) {
        super(CreateChild.calcText(bl), fam.getGedcom(), "INDI");
        this.male = bl;
        this.setImage(bl ? PropertyChild.IMG_MALE : PropertyChild.IMG_FEMALE);
        this.parentOrFamily = fam;
    }

    public CreateChild(Indi indi, boolean bl) {
        super(CreateChild.calcText(bl), indi.getGedcom(), "INDI");
        this.male = bl;
        this.setImage(bl ? PropertyChild.IMG_MALE : PropertyChild.IMG_FEMALE);
        this.parentOrFamily = indi;
    }

    private static String calcText(boolean bl) {
        String string = resources.getString("create.child", false);
        if (string != null) {
            return string + " (" + (bl ? PropertySex.TXT_MALE : PropertySex.TXT_FEMALE) + ")";
        }
        return resources.getString("create." + (bl ? "son" : "daughter"));
    }

    public String getDescription() {
        if (this.parentOrFamily instanceof Indi) {
            return resources.getString("create.child.of", this.parentOrFamily);
        }
        return resources.getString("create.child.in", this.parentOrFamily);
    }

    public String getWarning(Entity entity) {
        Fam fam;
        if (entity != null && (fam = ((Indi)entity).getFamilyWhereBiologicalChild()) != null) {
            return PropertyChild.getLabelChildAlreadyinFamily((Indi)entity, fam);
        }
        return null;
    }

    protected Property change(Entity entity, boolean bl) throws GedcomException {
        PropertyXRef propertyXRef;
        Fam fam;
        Indi indi;
        Indi indi2 = (Indi)entity;
        Gedcom gedcom = indi2.getGedcom();
        if (this.parentOrFamily instanceof Indi) {
            indi = (Indi)this.parentOrFamily;
            Fam[] famArray = indi.getFamiliesWhereSpouse();
            if (famArray.length > 0) {
                fam = famArray[0];
                propertyXRef = fam.addChild(indi2);
            } else {
                fam = (Fam)gedcom.createEntity("FAM");
                try {
                    propertyXRef = fam.addChild(indi2);
                }
                catch (GedcomException gedcomException) {
                    gedcom.deleteEntity(fam);
                    throw gedcomException;
                }
                fam.setSpouse(indi);
                fam.setSpouse((Indi)gedcom.createEntity("INDI").addDefaultProperties());
            }
        } else {
            fam = (Fam)this.parentOrFamily;
            propertyXRef = fam.addChild(indi2);
        }
        if (bl) {
            indi = fam.getHusband();
            if (indi == null) {
                indi = fam.getWife();
            }
            if (indi != null) {
                indi2.setName("", indi.getLastName());
            }
            indi2.setSex(this.male ? 1 : 2);
        }
        return propertyXRef.getTarget();
    }
}

