/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.PropertyBean;
import genj.gedcom.Property;
import genj.gedcom.PropertyChoiceValue;
import genj.util.GridBagHelper;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.DialogHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceBean
extends PropertyBean {
    private ChoiceWidget choices;
    private JCheckBox global;
    private Property[] sameChoices = new Property[0];

    private String getGlobalReplaceMsg() {
        if (this.sameChoices.length < 2) {
            return null;
        }
        return RESOURCES.getString("choice.global.confirm", "" + this.sameChoices.length, this.sameChoices[0].getDisplayValue(), this.choices.getText());
    }

    public ChoiceBean() {
        this.choices = new ChoiceWidget();
        this.choices.addChangeListener(this.changeSupport);
        this.choices.setIgnoreCase(true);
        this.global = new JCheckBox();
        this.global.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.global.setVisible(false);
        this.global.setRequestFocusEnabled(false);
        this.choices.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                String string = ChoiceBean.this.getGlobalReplaceMsg();
                if (string != null) {
                    ChoiceBean.this.global.setVisible(true);
                    ChoiceBean.this.global.setToolTipText(string);
                }
            }
        });
        this.global.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ChoiceBean.this.getGlobalReplaceMsg();
                if (string != null && ChoiceBean.this.global.isSelected()) {
                    int n = DialogHelper.openDialog(PropertyBean.RESOURCES.getString("choice.global.enable"), 3, string, (Action[])Action2.yesNo(), (Object)ChoiceBean.this);
                    ChoiceBean.this.global.setSelected(n == 0);
                }
            }
        });
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        gridBagHelper.add(this.choices, 0, 0, 1, 1, 17);
        gridBagHelper.add(this.global, 1, 0);
        gridBagHelper.addFiller(0, 1);
        this.defaultFocus = this.choices;
    }

    @Override
    protected void commitImpl(Property property) {
        PropertyChoiceValue propertyChoiceValue = (PropertyChoiceValue)property;
        String string = this.choices.getText();
        propertyChoiceValue.setValue(string, this.global.isSelected());
        this.choices.setValues(this.getChoicesToShow((PropertyChoiceValue)property));
        this.choices.setText(string);
        this.global.setSelected(false);
        this.global.setVisible(false);
    }

    private List<String> getChoicesToShow(PropertyChoiceValue propertyChoiceValue) {
        List<String> list = propertyChoiceValue.getChoices(true);
        List<String> list2 = propertyChoiceValue.getDefaults();
        if (!list2.isEmpty()) {
            block0: for (String string : list2) {
                for (String string2 : list) {
                    if (string2.indexOf(string) < 0) continue;
                    continue block0;
                }
                list.add(string);
            }
        }
        Collections.sort(list, propertyChoiceValue.getGedcom().getCollator());
        return list;
    }

    @Override
    public void setPropertyImpl(Property property) {
        PropertyChoiceValue propertyChoiceValue = (PropertyChoiceValue)property;
        if (propertyChoiceValue != null) {
            this.choices.setValues(this.getChoicesToShow((PropertyChoiceValue)this.property));
            this.choices.setText(propertyChoiceValue.getDisplayValue());
            this.sameChoices = propertyChoiceValue.getSameChoices();
        } else {
            this.choices.setValues(PropertyChoiceValue.getSameChoices(this.getRoot().getGedcom(), this.getPath().getLast(), true));
            this.choices.setText("");
            this.sameChoices = new Property[0];
        }
        this.global.setSelected(false);
        this.global.setVisible(false);
    }
}

