/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.option.CustomOption;
import genj.option.Option;
import genj.option.OptionProvider;
import genj.option.PropertyOption;
import genj.renderer.DPI;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.ScreenResolutionScale;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options
extends OptionProvider {
    private static final Resources RESOURCES = Resources.get(Options.class);
    private static final Options instance = new Options();
    private Font defaultFont = new Font("SansSerif", 0, 11);
    private DPI dpi = new DPI(Toolkit.getDefaultToolkit().getScreenResolution(), Toolkit.getDefaultToolkit().getScreenResolution());

    public static Options getInstance() {
        return instance;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font font) {
        this.defaultFont = font;
    }

    @Override
    public List<? extends Option> getOptions() {
        ArrayList<PropertyOption> arrayList = new ArrayList<PropertyOption>(PropertyOption.introspect(Options.getInstance()));
        arrayList.add((PropertyOption)((Object)new ScreenResolutionOption()));
        return arrayList;
    }

    public DPI getDPI() {
        return this.dpi;
    }

    private class ScreenResolutionOption
    extends CustomOption {
        private ScreenResolutionOption() {
        }

        public String getName() {
            return RESOURCES.getString("option.screenresolution");
        }

        public String getToolTip() {
            return RESOURCES.getString("option.screenresolution.tip", false);
        }

        public void persist() {
            Registry.get(this).put("dpi.h", Options.this.dpi.horizontal());
            Registry.get(this).put("dpi.v", Options.this.dpi.vertical());
        }

        public void restore() {
            int n = Registry.get(this).get("dpi.h", 0);
            int n2 = Registry.get(this).get("dpi.v", 0);
            if (n > 0 && n2 > 0) {
                Options.this.dpi = new DPI(n, n2);
            }
        }

        protected JComponent getEditor() {
            return new ScreenResolutionScale(Options.this.dpi);
        }

        protected void commit(JComponent jComponent) {
            Options.this.dpi = ((ScreenResolutionScale)jComponent).getDPI();
        }
    }
}

