/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.search.Hit;
import genj.search.Matcher;
import genj.search.RegExMatcher;
import genj.search.SimpleMatcher;
import genj.search.WorkerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Worker {
    private static final int MAX_HITS = 255;
    private WorkerListener listener;
    private Gedcom gedcom;
    private List<String> tags;
    private Matcher matcher;
    private Set<Entity> entities = new HashSet<Entity>();
    private List<Hit> hits = new ArrayList<Hit>(255);
    private int hitCount = 0;
    private Thread thread;
    private AtomicBoolean lock = new AtomicBoolean(false);
    private long lastFlush;

    Worker(WorkerListener workerListener) {
        this.listener = workerListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        AtomicBoolean atomicBoolean = this.lock;
        synchronized (atomicBoolean) {
            try {
                this.lock.set(false);
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(Gedcom gedcom, String string, String string2, boolean bl) {
        AtomicBoolean atomicBoolean = this.lock;
        synchronized (atomicBoolean) {
            if (this.thread != null) {
                throw new IllegalStateException("can't start while running");
            }
            this.gedcom = gedcom;
            this.matcher = this.getMatcher(string2, bl);
            this.tags = this.split(string);
            this.hits.clear();
            this.entities.clear();
            this.hitCount = 0;
            this.lock.set(true);
            this.thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Worker.this.listener.started();
                        Worker.this.search(Worker.this.gedcom);
                        Worker.this.flush();
                    }
                    catch (Throwable throwable) {
                        Logger.getLogger("genj.search").log(Level.FINE, "worker bailed", throwable);
                    }
                    finally {
                        AtomicBoolean atomicBoolean = Worker.this.lock;
                        synchronized (atomicBoolean) {
                            Worker.this.thread = null;
                            Worker.this.lock.set(false);
                            Worker.this.lock.notifyAll();
                        }
                        try {
                            Worker.this.listener.stopped();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            });
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    private List<String> split(String string) {
        String[] stringArray = string.split(",|\\s");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            if ((string2 = string2.trim()).length() <= 0 || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private void search(Gedcom gedcom) {
        for (int i = 0; i < Gedcom.ENTITIES.length && this.hitCount < 255; ++i) {
            for (Entity entity : gedcom.getEntities(Gedcom.ENTITIES[i])) {
                this.search(entity, entity);
                if (this.lock.get()) continue;
                return;
            }
        }
    }

    private void flush() {
        if (!this.hits.isEmpty()) {
            this.listener.more(Collections.unmodifiableList(this.hits));
            this.hits.clear();
        }
    }

    private boolean checkPath(Entity entity, Property property) {
        if (entity == property || this.tags.isEmpty()) {
            return true;
        }
        TagPath tagPath = property.getPath();
        for (String string : this.tags) {
            if (tagPath.contains(string)) continue;
            return false;
        }
        return true;
    }

    private void search(Entity entity, Property property) {
        if (this.checkPath(entity, property) && !property.isTransient()) {
            if (entity == property) {
                this.search(entity, entity, entity.getId(), true);
            }
            this.search(entity, property, property.getDisplayValue(), false);
        }
        int n = property.getNoOfProperties();
        for (int i = 0; i < n; ++i) {
            this.search(entity, property.getProperty(i));
        }
    }

    private void search(Entity entity, Property property, String string, boolean bl) {
        Matcher.Match[] matchArray = this.matcher.match(string);
        if (matchArray.length == 0) {
            return;
        }
        if (this.hitCount >= 255) {
            return;
        }
        this.entities.add(entity);
        Hit hit = new Hit(property, string, matchArray, this.entities.size(), bl);
        this.hits.add(hit);
        ++this.hitCount;
        long l = System.currentTimeMillis();
        if (l - this.lastFlush > 500L) {
            this.flush();
        }
        this.lastFlush = l;
    }

    private Matcher getMatcher(String string, boolean bl) {
        Matcher matcher = bl ? new RegExMatcher() : new SimpleMatcher();
        matcher.init(string);
        return matcher;
    }
}

