/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.PropertyEvent;
import genj.gedcom.TagPath;
import genj.timeline.TimelineView;
import genj.util.Resources;
import genj.util.swing.ColorsWidget;
import genj.util.swing.ImageIcon;
import genj.util.swing.ListSelectionWidget;
import genj.util.swing.NestedBlockLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimelineViewSettings
extends JTabbedPane {
    private Resources resources = Resources.get(this);
    private ListSelectionWidget<TagPath> pathsList;
    private JCheckBox checkTags;
    private JCheckBox checkDates;
    private JCheckBox checkGrid;
    private JSpinner spinCmBefEvent;
    private JSpinner spinCmAftEvent;
    private ColorsWidget colorWidget;
    private Commit commit;

    TimelineViewSettings(TimelineView timelineView) {
        final Gedcom gedcom = timelineView.getModel().getGedcom();
        this.commit = new Commit(timelineView);
        this.pathsList = new ListSelectionWidget<TagPath>(){

            @Override
            protected ImageIcon getIcon(TagPath tagPath) {
                Grammar grammar = Grammar.V55;
                if (gedcom != null) {
                    grammar = gedcom.getGrammar();
                }
                return grammar.getMeta(tagPath).getImage();
            }
        };
        if (gedcom != null) {
            this.pathsList.setChoices((TagPath[])PropertyEvent.getTagPaths(gedcom));
        }
        this.pathsList.setCheckedChoices(timelineView.getModel().getPaths());
        this.pathsList.addChangeListener(this.commit);
        JPanel jPanel = new JPanel(new NestedBlockLayout("<col><check gx=\"1\"/><check gx=\"1\"/><check gx=\"1\"/><row><label/><spin/></row><row><label/><spin/></row></col>"));
        jPanel.setOpaque(false);
        this.checkTags = this.createCheck("info.show.tags", timelineView.isPaintTags());
        this.checkDates = this.createCheck("info.show.dates", timelineView.isPaintDates());
        this.checkGrid = this.createCheck("info.show.grid", timelineView.isPaintGrid());
        jPanel.add(this.checkTags);
        jPanel.add(this.checkDates);
        jPanel.add(this.checkGrid);
        this.spinCmBefEvent = this.createSpinner(0.1, timelineView.getCmBeforeEvents(), 2.0, "info.befevent.tip");
        jPanel.add(new JLabel(this.resources.getString("info.befevent")));
        jPanel.add(this.spinCmBefEvent);
        this.spinCmAftEvent = this.createSpinner(2.0, timelineView.getCmAfterEvents(), 9.0, "info.aftevent.tip");
        jPanel.add(new JLabel(this.resources.getString("info.aftevent")));
        jPanel.add(this.spinCmAftEvent);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel(this.resources.getString("info.events")), "North");
        jPanel2.add(this.pathsList, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.colorWidget = new ColorsWidget();
        for (String string : timelineView.colors.keySet()) {
            this.colorWidget.addColor(string, this.resources.getString("color." + string), timelineView.colors.get(string));
        }
        this.colorWidget.addChangeListener(this.commit);
        this.add(this.resources.getString("page.main"), jPanel2);
        this.add(this.resources.getString("page.colors"), this.colorWidget);
    }

    private JCheckBox createCheck(String string, boolean bl) {
        JCheckBox jCheckBox = new JCheckBox(this.resources.getString(string), bl);
        jCheckBox.addActionListener(this.commit);
        jCheckBox.setOpaque(false);
        return jCheckBox;
    }

    private JSpinner createSpinner(double d, double d2, double d3, String string) {
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(d2, d, d3, 0.1));
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(jSpinner, "##0.0");
        jSpinner.setEditor(numberEditor);
        jSpinner.addChangeListener(numberEditor);
        jSpinner.addChangeListener(this.commit);
        jSpinner.setToolTipText(this.resources.getString(string));
        return jSpinner;
    }

    private class Commit
    implements ChangeListener,
    ActionListener {
        private TimelineView view;

        private Commit(TimelineView timelineView) {
            this.view = timelineView;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.actionPerformed(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.view.getModel().setPaths(TimelineViewSettings.this.pathsList.getCheckedChoices());
            this.view.setPaintTags(TimelineViewSettings.this.checkTags.isSelected());
            this.view.setPaintDates(TimelineViewSettings.this.checkDates.isSelected());
            this.view.setPaintGrid(TimelineViewSettings.this.checkGrid.isSelected());
            this.view.setCMPerEvents((Double)TimelineViewSettings.this.spinCmBefEvent.getModel().getValue(), (Double)TimelineViewSettings.this.spinCmAftEvent.getModel().getValue());
            for (String string : this.view.colors.keySet()) {
                this.view.colors.put(string, TimelineViewSettings.this.colorWidget.getColor(string));
            }
        }
    }
}

