/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registry
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger("genj.util");
    private String prefix;
    private Properties properties;
    private static Map<String, Registry> prefix2registry = new HashMap<String, Registry>();
    private static Map<File, Registry> file2registry = new HashMap<File, Registry>();

    public Registry(Registry registry, String string) {
        if (registry.prefix.length() > 0) {
            string = registry.prefix + "." + string;
        }
        this.prefix = string;
        this.properties = registry.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Registry(String string) {
        this.prefix = string;
        this.properties = new SortingProperties();
        Class<Registry> clazz = Registry.class;
        synchronized (Registry.class) {
            prefix2registry.put(this.prefix, this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Registry(InputStream inputStream) {
        this.prefix = "";
        this.properties = new SortingProperties();
        try {
            this.properties.load(inputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Registry(File file) {
        this.prefix = "";
        this.properties = new SortingProperties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.properties.load(fileInputStream);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry get(File file) {
        Class<Registry> clazz = Registry.class;
        synchronized (Registry.class) {
            Registry registry = file2registry.get(file);
            if (registry == null) {
                registry = new Registry(file);
                file2registry.put(file, registry);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return registry;
        }
    }

    public static Registry get(Object object) {
        return Registry.get(object.getClass());
    }

    public static Registry get(Class<?> clazz) {
        return Registry.get(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry get(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            throw new IllegalArgumentException("default package not allowed");
        }
        String string2 = stringArray[0];
        Class<Registry> clazz = Registry.class;
        synchronized (Registry.class) {
            Registry registry = prefix2registry.get(string2);
            if (registry == null) {
                registry = new Registry(stringArray[0]);
                prefix2registry.put(string2, registry);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return stringArray.length == 1 ? registry : new Registry(registry, string.substring(string2.length() + 1));
        }
    }

    public void remove(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.properties.keySet());
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)arrayList.get(i);
            if (!string2.startsWith(string)) continue;
            this.properties.remove(string2);
        }
    }

    public <K, V> Map<K, V> get(String string, Map<K, V> map) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        for (K k : map.keySet()) {
            Object object = map.get(k);
            try {
                object = this.getClass().getMethod("get", String.class, object.getClass()).invoke((Object)this, string + "." + k, object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            hashMap.put(k, object);
        }
        return hashMap;
    }

    public int[] get(String string, int[] nArray) {
        int n = this.get(string, -1);
        if (n < 0) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = this.get(string + "." + (i + 1), -1);
        }
        return nArray2;
    }

    public Rectangle[] get(String string, Rectangle[] rectangleArray) {
        int n = this.get(string, -1);
        if (n == -1) {
            return rectangleArray;
        }
        Rectangle[] rectangleArray2 = new Rectangle[n];
        Rectangle rectangle = new Rectangle(-1, -1, -1, -1);
        for (int i = 0; i < n; ++i) {
            rectangleArray2[i] = this.get(string + "." + (i + 1), rectangle);
        }
        return rectangleArray2;
    }

    public String[] get(String string, String[] stringArray) {
        int n = this.get(string, -1);
        if (n == -1) {
            return stringArray;
        }
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = this.get(string + "." + (i + 1), "");
        }
        return stringArray2;
    }

    public float get(String string, float f) {
        String string2 = this.get(string, (String)null);
        if (string2 == null) {
            return f;
        }
        try {
            return Float.valueOf(string2.trim()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public int get(String string, int n) {
        String string2 = this.get(string, (String)null);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public Dimension get(String string, Dimension dimension) {
        int n = this.get(string + ".w", -1);
        int n2 = this.get(string + ".h", -1);
        if (n == -1 || n2 == -1) {
            return dimension;
        }
        return new Dimension(n, n2);
    }

    public Font get(String string, Font font) {
        String string2 = this.get(string + ".name", (String)null);
        int n = this.get(string + ".style", -1);
        int n2 = this.get(string + ".size", -1);
        if (string2 == null || n == -1 || n2 == -1) {
            return font;
        }
        return new Font(string2, n, n2);
    }

    public Point get(String string, Point point) {
        int n = this.get(string + ".x", Integer.MAX_VALUE);
        int n2 = this.get(string + ".y", Integer.MAX_VALUE);
        if (n == Integer.MAX_VALUE || n2 == Integer.MAX_VALUE) {
            return point;
        }
        return new Point(n, n2);
    }

    public Point2D get(String string, Point2D point2D) {
        float f = this.get(string + ".x", Float.NaN);
        float f2 = this.get(string + ".y", Float.NaN);
        if (Float.isNaN(f) || Float.isNaN(f2)) {
            return point2D;
        }
        return new Point2D.Double(f, f2);
    }

    public Rectangle get(String string, Rectangle rectangle) {
        int n = this.get(string + ".x", Integer.MAX_VALUE);
        int n2 = this.get(string + ".y", Integer.MAX_VALUE);
        int n3 = this.get(string + ".w", Integer.MAX_VALUE);
        int n4 = this.get(string + ".h", Integer.MAX_VALUE);
        if (n == Integer.MAX_VALUE || n2 == Integer.MAX_VALUE || n3 == Integer.MAX_VALUE || n4 == Integer.MAX_VALUE) {
            return rectangle;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public List<String> get(String string, List<String> list) {
        int n = this.get(string, -1);
        if (n == -1) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.get(string + "." + (i + 1), ""));
        }
        return arrayList;
    }

    public boolean get(String string, boolean bl) {
        String string2 = this.get(string, (String)null);
        if (string2 == null) {
            return bl;
        }
        if (string2.equals("1") || string2.equals("true")) {
            return true;
        }
        if (string2.equals("0") || string2.equals("false")) {
            return false;
        }
        return bl;
    }

    public Color get(String string, Color color) {
        int n = this.get(string, Integer.MAX_VALUE);
        if (n == Integer.MAX_VALUE) {
            return color;
        }
        return new Color(n);
    }

    public String get(String string, String string2) {
        String string3;
        if (this.prefix.length() > 0) {
            string = this.prefix + "." + string;
        }
        if ((string3 = (String)this.properties.get(string)) == null) {
            return string2;
        }
        return string3;
    }

    public void put(String string, String string2) {
        if (this.prefix.length() > 0) {
            string = this.prefix + "." + string;
        }
        if (string2 == null) {
            this.properties.remove(string);
        } else {
            this.properties.put(string, string2);
        }
    }

    public void put(String string, Map<String, ?> map) {
        for (String string2 : map.keySet()) {
            Object object = map.get(string2);
            try {
                object = this.getClass().getMethod("put", String.class, object.getClass()).invoke((Object)this, string + "." + string2, object);
            }
            catch (Throwable throwable) {}
        }
    }

    public void put(String string, int[] nArray) {
        int n = nArray.length;
        this.put(string, n);
        for (int i = 0; i < n; ++i) {
            this.put(string + "." + (i + 1), "" + nArray[i]);
        }
    }

    public void put(String string, Rectangle[] rectangleArray) {
        int n = rectangleArray.length;
        this.put(string, "" + n);
        for (int i = 0; i < n; ++i) {
            this.put(string + "." + (i + 1), rectangleArray[i]);
        }
    }

    public void put(String string, Object[] objectArray) {
        this.put(string, objectArray, objectArray.length);
    }

    public void put(String string, Object[] objectArray, int n) {
        int n2 = Math.min(objectArray.length, n);
        this.put(string, "" + n2);
        for (int i = 0; i < n2; ++i) {
            this.put(string + "." + (i + 1), objectArray[i].toString());
        }
    }

    public void put(String string, float f) {
        this.put(string, "" + f);
    }

    public void put(String string, int n) {
        this.put(string, "" + n);
    }

    public void put(String string, Dimension dimension) {
        this.put(string + ".w", dimension.width);
        this.put(string + ".h", dimension.height);
    }

    public void put(String string, Font font) {
        this.put(string + ".name", font.getName());
        this.put(string + ".style", font.getStyle());
        this.put(string + ".size", font.getSize());
    }

    public void put(String string, Point point) {
        this.put(string + ".x", point.x);
        this.put(string + ".y", point.y);
    }

    public void put(String string, Point2D point2D) {
        this.put(string + ".x", (float)point2D.getX());
        this.put(string + ".y", (float)point2D.getY());
    }

    public void put(String string, Rectangle rectangle) {
        this.put(string + ".x", rectangle.x);
        this.put(string + ".y", rectangle.y);
        this.put(string + ".w", rectangle.width);
        this.put(string + ".h", rectangle.height);
    }

    public void put(String string, Collection<?> collection) {
        int n = collection.size();
        this.put(string, n);
        Iterator<?> iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            this.put(string + "." + (n2 + 1), iterator.next().toString());
            ++n2;
        }
    }

    public void put(String string, Boolean bl) {
        this.put(string, bl != false ? "1" : "0");
    }

    public void put(String string, Color color) {
        this.put(string, color.getRGB());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(File file) {
        Class<Registry> clazz = Registry.class;
        synchronized (Registry.class) {
            try {
                this.properties.clear();
                LOG.fine("Loading registry " + this.prefix + " from file " + file.getAbsolutePath());
                FileInputStream fileInputStream = new FileInputStream(file);
                this.properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Throwable throwable) {
                LOG.log(Level.FINE, "Failed to read registry from " + file + " (" + throwable.getMessage() + ")");
            }
            file2registry.put(file, this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void persist() {
        for (File file : file2registry.keySet()) {
            Registry registry = file2registry.get(file);
            try {
                LOG.fine("Storing registry in file " + file.getAbsolutePath());
                File file2 = file.getParentFile();
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new IOException("dir is bad " + file2);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                registry.properties.store(fileOutputStream, registry.prefix);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Can't store registry in file " + file.getAbsolutePath(), iOException);
            }
        }
    }

    public void put(String string, JFrame jFrame) {
        boolean bl;
        Rectangle rectangle = jFrame.getBounds();
        boolean bl2 = bl = jFrame.getExtendedState() == 6;
        if (rectangle != null && !bl) {
            this.put(string, rectangle);
        }
        this.put(string + ".maximized", bl);
    }

    public JFrame get(String string, JFrame jFrame) {
        jFrame.setBounds(this.get(string, new Rectangle(0, 0, 640, 480)));
        if (this.get(string + ".maximized", true)) {
            jFrame.setExtendedState(6);
        }
        return jFrame;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if (object == null) {
            this.remove(string);
            return;
        }
        try {
            this.getClass().getMethod("put", String.class, object.getClass()).invoke((Object)this, string, object);
        }
        catch (Throwable throwable) {
            this.put(string, object.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortingProperties
    extends Properties {
        private SortingProperties() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            Vector<Object> vector = new Vector<Object>(super.keySet());
            Collections.sort(vector);
            return vector.elements();
        }
    }
}

