/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.MnemonicAndText;
import genj.util.Resources;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class Action2
extends AbstractAction {
    static final String KEY_TEXT = "Name";
    static final String KEY_OLDTEXT = "Name.old";
    static final String KEY_SHORT_TEXT = "shortname";
    static final String KEY_TIP = "ShortDescription";
    static final String KEY_ENABLED = "enabled";
    static final String KEY_MNEMONIC = "MnemonicKey";
    static final String KEY_ICON = "SmallIcon";
    static final String KEY_SELECTED = "SwingSelectedKey";
    private static final Logger LOG = Logger.getLogger("genj.actions");
    public static final String TXT_YES = UIManager.getString("OptionPane.yesButtonText");
    public static final String TXT_NO = UIManager.getString("OptionPane.noButtonText");
    public static final String TXT_OK = UIManager.getString("OptionPane.okButtonText");
    public static final String TXT_CANCEL = UIManager.getString("OptionPane.cancelButtonText");

    public Action2() {
    }

    public Action2(Resources resources, String string) {
        this(resources.getString(string));
    }

    public Action2(String string) {
        this.setText(string);
    }

    public Action2(String string, boolean bl) {
        this(string);
        this.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public Object getValue(String string) {
        if (KEY_TEXT.equals(string)) {
            return this.getText();
        }
        if (KEY_ICON.equals(string)) {
            return this.getImage();
        }
        if (KEY_TIP.equals(string)) {
            return this.getTip();
        }
        return super.getValue(string);
    }

    public Action2 setImage(Icon icon) {
        super.putValue(KEY_ICON, icon);
        return this;
    }

    public Action2 restoreText() {
        this.setText((String)super.getValue(KEY_OLDTEXT));
        return this;
    }

    public Action2 setText(String string) {
        return this.setText(null, string);
    }

    public Action2 setText(Resources resources, String string) {
        if (resources != null) {
            string = resources.getString(string);
        }
        super.putValue(KEY_OLDTEXT, this.getText());
        if (string != null && string.length() > 0) {
            MnemonicAndText mnemonicAndText = new MnemonicAndText(string);
            string = mnemonicAndText.getText();
            this.setMnemonic(mnemonicAndText.getMnemonic());
        }
        super.putValue(KEY_TEXT, string);
        return this;
    }

    public Action2 setMnemonic(char c) {
        super.putValue(KEY_MNEMONIC, c == '\u0000' ? null : new Integer(c));
        return this;
    }

    public char getMnemonic() {
        Integer n = (Integer)super.getValue(KEY_MNEMONIC);
        return n != null ? (char)n.intValue() : (char)'\u0000';
    }

    public String getText() {
        return (String)super.getValue(KEY_TEXT);
    }

    public Action2 setTip(String string) {
        return this.setTip(null, string);
    }

    public Action2 setTip(Resources resources, String string) {
        if (resources != null) {
            string = resources.getString(string);
        }
        super.putValue(KEY_TIP, string);
        return this;
    }

    public String getTip() {
        return (String)super.getValue(KEY_TIP);
    }

    public Icon getImage() {
        return (Icon)super.getValue(KEY_ICON);
    }

    public static Action2 yes() {
        return new Constant(TXT_YES);
    }

    public static Action2 no() {
        return new Constant(TXT_NO);
    }

    public static Action2 ok() {
        return new Constant(TXT_OK);
    }

    public static Action2 cancel() {
        return new Constant(TXT_CANCEL);
    }

    public static Action2[] yesNo() {
        return new Action2[]{Action2.yes(), Action2.no()};
    }

    public static Action2[] yesNoCancel() {
        return new Action2[]{Action2.yes(), Action2.no(), Action2.cancel()};
    }

    public static Action2[] okCancel() {
        return new Action2[]{Action2.ok(), Action2.cancel()};
    }

    public static Action2[] andCancel(Action2 action2) {
        return new Action2[]{action2, Action2.cancel()};
    }

    public static Action2[] okAnd(Action2 action2) {
        return new Action2[]{Action2.ok(), action2};
    }

    public static Action2[] okOnly() {
        return new Action2[]{Action2.ok()};
    }

    public static Action2[] cancelOnly() {
        return new Action2[]{Action2.cancel()};
    }

    public Action2 install(JComponent jComponent, String string) {
        return this.install(jComponent, string, 2);
    }

    public Action2 install(JComponent jComponent, String string, int n) {
        InputMap inputMap = jComponent.getInputMap(n);
        inputMap.put(KeyStroke.getKeyStroke(string), this);
        jComponent.getActionMap().put(this, this);
        return this;
    }

    public static void uninstall(JComponent jComponent, String string) {
        Action2.uninstall(jComponent, jComponent.getInputMap(2), string);
        Action2.uninstall(jComponent, jComponent.getInputMap(0), string);
        Action2.uninstall(jComponent, jComponent.getInputMap(1), string);
    }

    private static void uninstall(JComponent jComponent, InputMap inputMap, String string) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string);
        Object object = inputMap.get(keyStroke);
        if (object instanceof Action2) {
            inputMap.put(keyStroke, null);
            jComponent.getActionMap().remove(object);
        }
    }

    public boolean isSelected() {
        return Boolean.TRUE.equals((Boolean)this.getValue(KEY_SELECTED));
    }

    public boolean setSelected(boolean bl) {
        boolean bl2 = this.isSelected();
        this.putValue(KEY_SELECTED, bl ? Boolean.TRUE : Boolean.FALSE);
        return bl2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Group
    extends Action2
    implements Iterable<Action2> {
        private ArrayList<Action2> actions = new ArrayList(4);
        private boolean sort;

        public Group(String string, Icon icon, boolean bl) {
            super(string);
            this.setImage(icon);
            this.sort = bl;
        }

        public Group(String string, Icon icon) {
            super(string);
            this.setImage(icon);
        }

        public Group(String string, ImageIcon imageIcon, List<Action2> list) {
            super(string);
            this.setImage(imageIcon);
            this.actions.addAll(list);
        }

        public Group(String string) {
            this(string, null);
        }

        public Group add(Action2 action2) {
            for (Action action : this) {
                if (!action.equals(action2)) continue;
                if (action instanceof Group) {
                    for (Action2 action22 : (Group)action2) {
                        ((Group)action).add(action22);
                    }
                }
                return this;
            }
            if (this.sort) {
                if (action2.getText() == null) {
                    this.sort = false;
                } else {
                    for (int i = 0; i < this.actions.size(); ++i) {
                        if (this.actions.get(i).getText().compareToIgnoreCase(action2.getText()) <= 0) continue;
                        this.actions.add(i, action2);
                        return this;
                    }
                }
            }
            this.actions.add(action2);
            return this;
        }

        public Group addAll(Group group) {
            for (Action2 action2 : group) {
                this.add(action2);
            }
            return this;
        }

        public Group addAll(List<Action2> list) {
            for (Action2 action2 : list) {
                this.add(action2);
            }
            return this;
        }

        public Group clear() {
            this.actions.clear();
            return this;
        }

        public int size() {
            return this.actions.size();
        }

        @Override
        public Iterator<Action2> iterator() {
            return this.actions.iterator();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            throw new IllegalArgumentException("group doesn't support actionPerformed()");
        }

        @Override
        public void setEnabled(boolean bl) {
            for (Action action : this.actions) {
                action.setEnabled(bl);
            }
        }
    }

    private static class Constant
    extends Action2 {
        private Constant(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

