/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class HeapStatusWidget
extends JProgressBar {
    private static final NumberFormat FORMAT = new DecimalFormat("0.0");
    private MessageFormat tooltip = new MessageFormat("Heap: {0}MB used {1}MB free {2}MB max");

    public HeapStatusWidget() {
        super(0, 100);
        this.setValue(0);
        this.setBorderPainted(false);
        this.setStringPainted(true);
        new Timer(3000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeapStatusWidget.this.update();
            }
        }).start();
    }

    private void update() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        long l2 = runtime.freeMemory();
        long l3 = runtime.totalMemory();
        long l4 = l3 - l2;
        int n = (int)Math.round((double)l4 * 100.0 / (double)l);
        this.setValue(n);
        this.setString(this.format(l4, true) + "MB (" + n + "%)");
        super.setToolTipText(null);
        super.setToolTipText(this.tooltip.format(new String[]{this.format(l4, false), this.format(l2, false), this.format(l, false)}));
    }

    private String format(long l, boolean bl) {
        double d = (double)l / 1000000.0;
        return bl ? FORMAT.format((double)l / 1000000.0) : Integer.toString((int)Math.round(d));
    }

    public void setToolTipText(String string) {
        this.tooltip = new MessageFormat(string);
        super.setToolTipText("");
    }
}

