/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.GraphicsHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedBlockLayout
implements LayoutManager2,
Cloneable {
    private static final SAXException DONE = new SAXException("");
    private static final SAXParser PARSER = NestedBlockLayout.getSaxParser();
    private static final Logger LOG = Logger.getLogger("genj.util");
    private boolean invalidated = true;
    private Block root;
    private Set<Component> components = new HashSet<Component>();

    private static final SAXParser getSaxParser() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Throwable throwable) {
            Logger.getLogger("genj.util.swing").log(Level.SEVERE, "Can't initialize SAX parser", throwable);
            throw new Error("Can't initialize SAX parser", throwable);
        }
    }

    private NestedBlockLayout(Block block) {
        this.root = block;
    }

    public NestedBlockLayout(String string) {
        try {
            this.init(new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public NestedBlockLayout(Reader reader) throws IOException {
        this.init(reader);
    }

    public NestedBlockLayout(InputStream inputStream) throws IOException {
        this.init(new InputStreamReader(inputStream));
    }

    public Collection<Cell> getCells() {
        return this.root.getCells(new ArrayList<Cell>(10));
    }

    private void init(Reader reader) throws IOException {
        try {
            PARSER.parse(new InputSource(reader), (DefaultHandler)new DescriptorHandler());
        }
        catch (SAXException sAXException) {
            if (DONE == sAXException) {
                return;
            }
            throw new RuntimeException(sAXException);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (this.components.contains(component)) {
            throw new IllegalArgumentException("already added");
        }
        List<Block> list = this.root.setContent(object, component, new ArrayList<Block>());
        if (!list.isEmpty()) {
            this.components.add(component);
            return;
        }
        if (object == null) {
            throw new IllegalArgumentException("no available descriptor element - element qualifier required");
        }
        throw new IllegalArgumentException("element qualifier doesn't match any descriptor element");
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.root.removeContent(component);
        this.components.remove(component);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
        if (!this.invalidated) {
            this.root.invalidate(true);
            this.invalidated = true;
            for (Component component : container.getComponents()) {
                if (this.components.contains(component)) continue;
                this.addLayoutComponent(component, null);
            }
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this.root.preferred();
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, container.getWidth() - insets.left - insets.right, container.getHeight() - insets.top - insets.bottom);
        this.root.layout(rectangle);
        this.invalidated = false;
    }

    public NestedBlockLayout copy() {
        try {
            NestedBlockLayout nestedBlockLayout = (NestedBlockLayout)super.clone();
            nestedBlockLayout.root = nestedBlockLayout.root.clone();
            nestedBlockLayout.components = new HashSet<Component>();
            nestedBlockLayout.invalidated = false;
            return nestedBlockLayout;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException);
        }
    }

    public static class Expander
    extends JLabel {
        private String expandedLabel;
        private String collapsedLabel;
        private static final Icon FOLDED = GraphicsHelper.getIcon(8, Expander.collapsed(8));
        private static final Icon UNFOLDED = GraphicsHelper.getIcon(8, Expander.open(8));
        private boolean isCollapsed = false;
        private int indent = 1;

        private static Shape collapsed(int n) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(n / 4, 0.0f);
            generalPath.lineTo(n / 4, n + 1);
            generalPath.lineTo(n * 3 / 4, n / 2);
            generalPath.closePath();
            return generalPath;
        }

        private static Shape open(int n) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, n / 4);
            generalPath.lineTo(n, n / 4);
            generalPath.lineTo(n / 2, n * 3 / 4);
            generalPath.closePath();
            return generalPath;
        }

        public Expander(String string, String string2) {
            this(string, string2, 1);
        }

        public Expander(String string) {
            this(string, 1);
        }

        public Expander(String string, int n) {
            this(string, string, n);
        }

        public Expander(String string, String string2, int n) {
            super(string);
            this.collapsedLabel = string2;
            this.expandedLabel = string;
            this.indent = Math.max(1, n);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new Mouser());
        }

        public int getIndent() {
            return this.indent;
        }

        public void setCollapsed(boolean bl) {
            this.isCollapsed = bl;
            this.setText(this.isCollapsed ? this.collapsedLabel : this.expandedLabel);
        }

        public boolean isCollapsed() {
            return this.isCollapsed;
        }

        public Icon getIcon() {
            return this.isCollapsed ? FOLDED : UNFOLDED;
        }

        private class Mouser
        extends MouseAdapter {
            private Mouser() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Expander.this.setCollapsed(!Expander.this.isCollapsed);
                Expander.this.firePropertyChange("folded", !Expander.this.isCollapsed, Expander.this.isCollapsed);
                Container container = Expander.this.getParent();
                if (container instanceof JComponent) {
                    ((JComponent)container).revalidate();
                } else {
                    ((Component)container).invalidate();
                    ((Component)container).validate();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Table
    extends Folder {
        private ArrayList<Integer> rowHeights;
        private ArrayList<Integer> colWidths;
        private ArrayList<Integer> rowWeights;
        private ArrayList<Integer> colWeights;

        Table(Attributes attributes) {
            super(attributes);
        }

        private void calcGrid() {
            Dimension dimension;
            int n;
            Block block;
            List<Object> list;
            Block block2;
            int n2;
            if (this.rowHeights != null) {
                return;
            }
            this.rowHeights = new ArrayList();
            this.colWidths = new ArrayList();
            this.rowWeights = new ArrayList();
            this.colWeights = new ArrayList();
            for (n2 = 0; n2 < this.subs.size(); ++n2) {
                block2 = (Block)this.subs.get(n2);
                list = block2 instanceof Row ? ((Row)block2).subs : Collections.singletonList(block2);
                for (n = 0; n < list.size(); n += block.cols) {
                    block = (Block)list.get(n);
                    dimension = block.preferred();
                    if (block.cols == 1) {
                        this.grow(this.colWidths, n, dimension.width);
                    }
                    this.grow(this.rowHeights, n2, dimension.height);
                    Point point = block.weight();
                    if (block.cols == 1) {
                        this.grow(this.colWeights, n, point.x);
                    }
                    this.grow(this.rowWeights, n2, point.y);
                }
            }
            for (n2 = 0; n2 < this.subs.size(); ++n2) {
                block2 = (Block)this.subs.get(n2);
                list = block2 instanceof Row ? ((Row)block2).subs : Collections.singletonList(block2);
                for (n = 0; n < list.size(); n += block.cols) {
                    int n3;
                    block = (Block)list.get(n);
                    dimension = block.preferred();
                    if (block.cols == 1) continue;
                    int n4 = 0;
                    int n5 = 0;
                    if (n + block.cols > this.colWidths.size()) {
                        throw new IllegalArgumentException("cols out of bounds for " + block);
                    }
                    for (n3 = 0; n3 < block.cols; ++n3) {
                        n5 += this.colWidths.get(n + n3).intValue();
                        n4 += this.colWeights.get(n + n3).intValue();
                    }
                    if (n5 >= dimension.width) continue;
                    n3 = dimension.width - n5;
                    for (int i = 0; i < block.cols; ++i) {
                        int n6 = n4 > 0 ? n3 * this.colWeights.get(n + i) / n4 : n3 / block.cols;
                        this.grow(this.colWidths, n + i, this.colWidths.get(n + i) + n6);
                    }
                }
            }
        }

        @Override
        void layoutFolder(Rectangle rectangle) {
            int n;
            int n2;
            Dimension dimension = this.preferred();
            this.calcGrid();
            float f = 0.0f;
            if (rectangle.width > dimension.width) {
                int n3 = 0;
                for (n2 = 0; n2 < this.colWeights.size(); ++n2) {
                    n3 += this.colWeights.get(n2).intValue();
                }
                f = (float)(rectangle.width - dimension.width) / (float)n3;
            }
            float f2 = 0.0f;
            if (rectangle.height > dimension.height) {
                n2 = 0;
                for (n = 0; n < this.rowWeights.size(); ++n) {
                    n2 += this.rowWeights.get(n).intValue();
                }
                f2 = (float)(rectangle.height - dimension.height) / (float)n2;
            }
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            for (n = 0; n < this.subs.size(); ++n) {
                Block block = (Block)this.subs.get(n);
                ArrayList arrayList = block instanceof Row ? ((Row)block).subs : Collections.singletonList(block);
                int n4 = rectangle2.x;
                int n5 = this.rowHeights.get(n) + (int)((float)this.rowWeights.get(n).intValue() * f2);
                int n6 = 0;
                while (n6 < arrayList.size()) {
                    Block block2 = (Block)arrayList.get(n6);
                    int n7 = 0;
                    int n8 = 0;
                    while (n8 < block2.cols) {
                        n7 += this.colWidths.get(n6) + (int)((float)this.colWeights.get(n6).intValue() * f);
                        ++n8;
                        ++n6;
                    }
                    n7 = Math.min(rectangle2.x + rectangle2.width - n4, n7);
                    block2.layout(new Rectangle(n4, rectangle2.y, n7, n5));
                    n4 += n7;
                }
                rectangle2.y += n5;
            }
        }

        private void grow(ArrayList<Integer> arrayList, int n, Integer n2) {
            while (arrayList.size() < n + 1) {
                arrayList.add(0);
            }
            arrayList.set(n, Math.max(arrayList.get(n), n2));
        }

        @Override
        Dimension preferredFolder() {
            int n;
            this.calcGrid();
            Dimension dimension = new Dimension(0, 0);
            for (n = 0; n < this.colWidths.size(); ++n) {
                dimension.width += this.colWidths.get(n).intValue();
            }
            for (n = 0; n < this.rowHeights.size(); ++n) {
                dimension.height += this.rowHeights.get(n).intValue();
            }
            return dimension;
        }

        @Override
        Point weightFolder() {
            int n;
            this.calcGrid();
            Point point = new Point(0, 0);
            for (n = 0; n < this.colWeights.size(); ++n) {
                point.x += this.colWeights.get(n).intValue();
            }
            for (n = 0; n < this.rowWeights.size(); ++n) {
                point.y += this.rowWeights.get(n).intValue();
            }
            return point;
        }

        @Override
        void invalidate(boolean bl) {
            super.invalidate(bl);
            this.rowHeights = null;
            this.colWidths = null;
            this.rowWeights = null;
            this.colWeights = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Cell
    extends Block {
        private String element;
        private Map<String, String> attrs = new HashMap<String, String>();
        private Component component;
        private Point cellWeight = new Point();
        private Point2D.Double cellAlign = new Point2D.Double(0.0, 0.5);

        private Cell(String string) {
            super(null);
            this.element = "text";
            this.attrs.put("value", string);
        }

        private Cell(String string, Attributes attributes) {
            super(attributes);
            String string2;
            String string3;
            String string4;
            this.element = string;
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                this.attrs.put(attributes.getQName(i), attributes.getValue(i));
            }
            String string5 = this.getAttribute("wx");
            if (string5 != null) {
                this.cellWeight.x = Integer.parseInt(string5);
                if (attributes.getValue("gx") == null) {
                    this.grow.x = 1;
                }
            }
            if ((string4 = this.getAttribute("wy")) != null) {
                this.cellWeight.y = Integer.parseInt(string4);
                if (attributes.getValue("gy") == null) {
                    this.grow.y = 1;
                }
            }
            if ((string3 = this.getAttribute("ax")) != null) {
                this.cellAlign.x = Float.parseFloat(string3);
            }
            if ((string2 = this.getAttribute("ay")) != null) {
                this.cellAlign.y = Float.parseFloat(string2);
            }
        }

        @Override
        protected Block clone() {
            Cell cell = (Cell)super.clone();
            cell.component = null;
            return cell;
        }

        public String getElement() {
            return this.element;
        }

        public boolean isAttribute(String string) {
            return this.attrs.containsKey(string);
        }

        public String getAttribute(String string) {
            return this.attrs.get(string);
        }

        @Override
        boolean removeContent(Component component) {
            if (this.component == component) {
                this.component = null;
                this.invalidate(false);
                return true;
            }
            return false;
        }

        @Override
        Dimension preferredImpl() {
            if (this.component == null || !this.component.isVisible()) {
                return new Dimension();
            }
            Dimension dimension = new Dimension(this.component.getPreferredSize());
            Dimension dimension2 = this.component.getMaximumSize();
            dimension.width = Math.min(dimension2.width, dimension.width);
            dimension.height = Math.min(dimension2.height, dimension.height);
            return dimension;
        }

        @Override
        protected void toString(StringBuffer stringBuffer) {
            stringBuffer.append("<cell ");
            stringBuffer.append(this.attrs);
            stringBuffer.append("/>");
        }

        @Override
        Point weight() {
            return this.component == null ? new Point() : this.cellWeight;
        }

        @Override
        void layoutImpl(Rectangle rectangle) {
            int n;
            if (this.component == null) {
                return;
            }
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Dimension dimension = this.component.getMaximumSize();
            if (rectangle2.width > dimension.width) {
                n = rectangle2.width - dimension.width;
                rectangle2.x = (int)((double)rectangle2.x + (double)n * this.cellAlign.x);
                rectangle2.width = dimension.width;
            }
            if (rectangle2.height > dimension.height) {
                n = rectangle2.height - dimension.height;
                rectangle2.y = (int)((double)rectangle2.y + (double)n * this.cellAlign.y);
                rectangle2.height = dimension.height;
            }
            this.component.setBounds(rectangle2);
        }

        @Override
        List<Block> setContent(Object object, Component component, List<Block> list) {
            if (object instanceof Cell && object != this || object instanceof String && (!this.element.equals(object) || this.component != null) || object == null && this.component != null) {
                return list;
            }
            if (this.component != null) {
                throw new IllegalArgumentException("can't set component twice");
            }
            this.component = component;
            list.add(this);
            return list;
        }

        @Override
        Collection<Cell> getCells(Collection<Cell> collection) {
            collection.add(this);
            return collection;
        }

        @Override
        Block add(Block block) {
            throw new IllegalArgumentException("cell.add() not supported");
        }
    }

    private static class Column
    extends Folder {
        Column(Attributes attributes) {
            super(attributes);
        }

        Dimension preferredFolder() {
            Dimension dimension = new Dimension();
            for (int i = 0; i < this.subs.size(); ++i) {
                Dimension dimension2 = ((Block)this.subs.get(i)).preferred();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height += dimension2.height;
            }
            return dimension;
        }

        Point weightFolder() {
            Point point = new Point();
            for (int i = 0; i < this.subs.size(); ++i) {
                Point point2 = ((Block)this.subs.get(i)).weight();
                point.x = Math.max(point.x, point2.x);
                point.y += point2.y;
            }
            return point;
        }

        void layoutFolder(Rectangle rectangle) {
            double d = 0.0;
            int n = rectangle.height;
            int n2 = 0;
            for (Block block : this.subs) {
                n -= block.preferred().height;
                d += block.weight().getY();
                n2 += block.grow().y;
            }
            double d2 = d > 0.0 ? (double)n / d : 0.0;
            int n3 = d2 == 0.0 && n2 > 0 ? n / n2 : 0;
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 0, 0);
            for (int i = 0; i < this.subs.size(); ++i) {
                Block block = (Block)this.subs.get(i);
                rectangle2.x = rectangle.x;
                rectangle2.width = rectangle.width;
                rectangle2.height = block.preferred().height + (int)(block.weight().getY() * d2) + block.grow().y * n3;
                block.layout(rectangle2);
                rectangle2.y += rectangle2.height;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Folder
    extends Block {
        protected transient Expander expander = null;
        ArrayList<Block> subs = new ArrayList(16);

        protected Folder(Attributes attributes) {
            super(attributes);
        }

        @Override
        Block add(Block block) {
            this.subs.add(block);
            this.invalidate(false);
            return block;
        }

        @Override
        protected void toString(StringBuffer stringBuffer) {
            stringBuffer.append("<" + this.getClass().getSimpleName() + ">");
            for (int i = 0; i < this.subs.size(); ++i) {
                this.subs.get(i).toString(stringBuffer);
            }
            stringBuffer.append("</" + this.getClass().getSimpleName() + ">");
        }

        @Override
        protected Folder clone() {
            Folder folder = (Folder)super.clone();
            folder.subs = new ArrayList(this.subs.size());
            for (int i = 0; i < this.subs.size(); ++i) {
                folder.subs.add(this.subs.get(i).clone());
            }
            return folder;
        }

        @Override
        boolean removeContent(Component component) {
            if (this.expander == component) {
                this.expander = null;
            }
            for (int i = 0; i < this.subs.size(); ++i) {
                Block block = this.subs.get(i);
                if (!block.removeContent(component)) continue;
                this.invalidate(false);
                return true;
            }
            return false;
        }

        @Override
        void invalidate(boolean bl) {
            super.invalidate(bl);
            if (bl) {
                for (int i = 0; i < this.subs.size(); ++i) {
                    this.subs.get(i).invalidate(true);
                }
            }
        }

        @Override
        Collection<Cell> getCells(Collection<Cell> collection) {
            for (int i = 0; i < this.subs.size(); ++i) {
                this.subs.get(i).getCells(collection);
            }
            return collection;
        }

        @Override
        List<Block> setContent(Object object, Component component, List<Block> list) {
            int n = -1;
            for (int i = 0; i < this.subs.size(); ++i) {
                int n2;
                Block block = this.subs.get(i);
                if (block instanceof Cell && object instanceof String && object.equals(((Cell)block).element)) {
                    n = i;
                }
                if (block.setContent(object, component, list).isEmpty()) continue;
                list.add(this);
                if (component instanceof Expander && (n2 = ((Expander)component).getIndent()) < list.size() && list.get(n2) == this) {
                    this.expander = (Expander)component;
                }
                return list;
            }
            if (n >= 0) {
                Block block = this.subs.get(n).clone();
                this.subs.add(n + 1, block);
                block.setContent(object, component, list);
                list.add(this);
                return list;
            }
            return list;
        }

        @Override
        final Dimension preferredImpl() {
            if (this.expander != null && this.expander.isCollapsed) {
                return this.expander.getPreferredSize();
            }
            return this.preferredFolder();
        }

        abstract Dimension preferredFolder();

        @Override
        final Point grow() {
            return this.expander != null && this.expander.isCollapsed ? new Point() : this.grow;
        }

        @Override
        final Point weight() {
            if (this.expander != null && this.expander.isCollapsed) {
                return new Point();
            }
            if (this.weight != null) {
                return this.weight;
            }
            this.weight = this.weightFolder();
            return this.weight;
        }

        abstract Point weightFolder();

        @Override
        final void layoutImpl(Rectangle rectangle) {
            if (this.expander != null && this.expander.isCollapsed) {
                for (Block block : this.subs) {
                    block.layout(new Rectangle(0, 0));
                }
                Dimension dimension = this.expander.getPreferredSize();
                this.expander.setBounds(rectangle.x, rectangle.y, dimension.width, dimension.height);
                return;
            }
            this.layoutFolder(rectangle);
        }

        abstract void layoutFolder(Rectangle var1);
    }

    private static class Row
    extends Folder {
        Row(Attributes attributes) {
            super(attributes);
        }

        Dimension preferredFolder() {
            Dimension dimension = new Dimension();
            for (int i = 0; i < this.subs.size(); ++i) {
                Dimension dimension2 = ((Block)this.subs.get(i)).preferred();
                dimension.width += dimension2.width;
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension;
        }

        Point weightFolder() {
            Point point = new Point();
            for (int i = 0; i < this.subs.size(); ++i) {
                Block block = (Block)this.subs.get(i);
                point.x += block.weight().x;
                point.y = Math.max(point.y, block.weight().y);
            }
            return point;
        }

        void layoutFolder(Rectangle rectangle) {
            double d = 0.0;
            int n = 0;
            int n2 = rectangle.width;
            for (int i = 0; i < this.subs.size(); ++i) {
                Block block = (Block)this.subs.get(i);
                n2 -= block.preferred().width;
                d += block.weight().getX();
                n += block.grow().x;
            }
            double d2 = d > 0.0 ? (double)n2 / d : 0.0;
            int n3 = d2 == 0.0 && n > 0 ? n2 / n : 0;
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 0, 0);
            for (int i = 0; i < this.subs.size(); ++i) {
                Block block = (Block)this.subs.get(i);
                rectangle2.width = block.preferred().width + (int)(block.weight().getX() * d2) + block.grow().x * n3;
                rectangle2.height = rectangle.height;
                block.layout(rectangle2);
                rectangle2.x += rectangle2.width;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Block
    implements Cloneable {
        Insets padding = this instanceof Cell ? new Insets(1, 1, 1, 1) : new Insets(0, 0, 0, 0);
        private Dimension preferred;
        Point weight;
        Point grow = new Point();
        int cols = 1;

        Block(Attributes attributes) {
            String string;
            String string2;
            String string3;
            if (attributes == null) {
                return;
            }
            String string4 = attributes.getValue("cols");
            if (string4 != null) {
                this.cols = Integer.parseInt(string4);
                if (this.cols <= 0) {
                    throw new IllegalArgumentException("cols<=0");
                }
            }
            if ((string3 = attributes.getValue("gx")) != null) {
                int n = this.grow.x = Integer.parseInt(string3) > 0 ? 1 : 0;
            }
            if ((string2 = attributes.getValue("gy")) != null) {
                int n = this.grow.y = Integer.parseInt(string2) > 0 ? 1 : 0;
            }
            if ((string = attributes.getValue("pad")) != null) {
                String[] stringArray = string.split(",");
                switch (stringArray.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.padding.set(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[0]));
                        break;
                    }
                    case 2: {
                        this.padding.set(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
                        break;
                    }
                    case 3: {
                        this.padding.set(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[1]));
                        break;
                    }
                    case 4: {
                        this.padding.set(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid padding " + string + " given (" + attributes + ")");
                    }
                }
            }
        }

        protected Block clone() {
            try {
                return (Block)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error();
            }
        }

        abstract boolean removeContent(Component var1);

        abstract Block add(Block var1);

        void invalidate(boolean bl) {
            this.preferred = null;
            this.weight = null;
        }

        abstract Point weight();

        Point grow() {
            return this.grow;
        }

        final Dimension preferred() {
            if (this.preferred == null) {
                this.preferred = this.preferredImpl();
                if (this.preferred.width > 0 && this.preferred.height > 0) {
                    this.preferred.width += this.padding.left + this.padding.right;
                    this.preferred.height += this.padding.top + this.padding.bottom;
                }
            }
            return this.preferred;
        }

        abstract Dimension preferredImpl();

        final void layout(Rectangle rectangle) {
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.x += this.padding.left;
            rectangle2.width -= this.padding.left + this.padding.right;
            rectangle2.y += this.padding.top;
            rectangle2.height -= this.padding.top + this.padding.bottom;
            this.layoutImpl(rectangle2);
        }

        abstract void layoutImpl(Rectangle var1);

        abstract Collection<Cell> getCells(Collection<Cell> var1);

        abstract List<Block> setContent(Object var1, Component var2, List<Block> var3);

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            this.toString(stringBuffer);
            return stringBuffer.toString();
        }

        protected abstract void toString(StringBuffer var1);
    }

    private class DescriptorHandler
    extends DefaultHandler {
        private Stack<Block> stack = new Stack();

        private DescriptorHandler() {
        }

        public InputSource resolveEntity(String string, String string2) {
            throw new IllegalArgumentException("Request for resolveEntity " + string + "/" + string2 + " not allowed in layout descriptor");
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            boolean bl = Character.isWhitespace(cArray[n]);
            boolean bl2 = Character.isWhitespace(cArray[n + n2 - 1]);
            while (n2 > 0 && Character.isWhitespace(cArray[n])) {
                ++n;
                --n2;
            }
            while (n2 > 0 && Character.isWhitespace(cArray[n + n2 - 1])) {
                --n2;
            }
            if (n2 == 0) {
                return;
            }
            if (bl) {
                --n;
                ++n2;
            }
            if (bl2) {
                ++n2;
            }
            String string = new String(cArray, n, n2);
            Block block = this.stack.peek();
            block.add(new Cell(string));
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Block block = this.getBlock(string3, attributes);
            if (this.stack.isEmpty()) {
                NestedBlockLayout.this.root = block;
            } else {
                Block block2 = this.stack.peek();
                block2.add(block);
            }
            this.stack.add(block);
        }

        private Block getBlock(String string, Attributes attributes) {
            if ("row".equals(string)) {
                return new Row(attributes);
            }
            if ("col".equals(string)) {
                return new Column(attributes);
            }
            if ("table".equals(string)) {
                return new Table(attributes);
            }
            return new Cell(string, attributes);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.stack == null || this.stack.size() == 0) {
                throw new SAXException("unexpected /element");
            }
            this.stack.pop();
            if (this.stack.isEmpty()) {
                throw DONE;
            }
        }
    }
}

