/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopupWidget
extends JButton {
    private List<JComponent> items = new ArrayList<JComponent>();
    private long fireOnClickWithin = 0L;
    private JPopupMenu popup;

    public PopupWidget() {
        this((Icon)null);
    }

    public PopupWidget(Icon icon) {
        this(null, icon);
    }

    public PopupWidget(String string) {
        this(string, null);
    }

    public PopupWidget(String string, Icon icon) {
        super(string, icon);
        this.setModel(new Model());
        this.setFocusable(false);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.popup = new JPopupMenu();
    }

    public void cancelPopup() {
        this.popup.setVisible(false);
    }

    protected void setPopupSize(Dimension dimension) {
        Container container;
        Dimension dimension2 = ((Component)container).getMinimumSize();
        dimension.width = Math.max(dimension2.width, dimension.width);
        dimension.height = Math.max(dimension2.height, dimension.height);
        Dimension dimension3 = container.getSize();
        for (container = this.getPopup(); container != null && container.getSize().equals(dimension3); container = container.getParent()) {
            container.setSize(dimension);
        }
        this.getPopup().revalidate();
    }

    public void showPopup() {
        this.cancelPopup();
        this.popup = this.getPopup();
        if (this.popup == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        if (!JToolBar.class.isAssignableFrom(this.getParent().getClass())) {
            n += this.getWidth();
        } else {
            JToolBar jToolBar = (JToolBar)this.getParent();
            if (1 == jToolBar.getOrientation()) {
                n += jToolBar.getLocation().x == 0 ? this.getWidth() : -this.popup.getPreferredSize().width;
            } else {
                n2 += jToolBar.getLocation().y < this.getHeight() ? this.getHeight() : -this.popup.getPreferredSize().height;
            }
        }
        this.popup.show(this, n, n2);
    }

    protected JPopupMenu getPopup() {
        return this.popup;
    }

    public void addItem(Component component) {
        this.popup.add(component);
    }

    public void addItems(List<? extends Action> list) {
        for (Action action : list) {
            this.addItem(action);
        }
    }

    public void addItem(Action action) {
        this.popup.add(new JMenuItem(action));
    }

    public void removeItems() {
        this.popup.removeAll();
    }

    public void setFireOnClickWithin(long l) {
        this.fireOnClickWithin = l;
    }

    private class Model
    extends DefaultButtonModel
    implements Runnable {
        private long triggerTime = 0L;

        private Model() {
        }

        public void setPressed(boolean bl) {
            super.setPressed(bl);
            if (bl) {
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            PopupWidget.this.showPopup();
            this.triggerTime = System.currentTimeMillis();
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            if (PopupWidget.this.fireOnClickWithin > 0L && System.currentTimeMillis() - this.triggerTime < PopupWidget.this.fireOnClickWithin) {
                for (int i = 0; i < PopupWidget.this.popup.getComponentCount(); ++i) {
                    Component component = PopupWidget.this.popup.getComponent(i);
                    if (!(component instanceof AbstractButton)) continue;
                    PopupWidget.this.cancelPopup();
                    ((AbstractButton)component).doClick();
                    break;
                }
            }
        }
    }
}

