/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.data;

import jgpstrackedit.data.util.Geometry;
import jgpstrackedit.util.Parser;

public class Point {
    private double longitude;
    private double latitude;
    private double elevation;
    private String time;
    private String information = null;
    private transient double length;

    public Point() {
    }

    public Point(String longitude, String latitude, String elevation, String time, String information) {
        this.setLongitude(longitude);
        this.setLatitude(latitude);
        this.setElevation(elevation);
        this.setTime(time);
        this.setInformation(information);
    }

    public Point(String longitude, String latitude, String elevation, String time) {
        this.setLongitude(longitude);
        this.setLatitude(latitude);
        this.setElevation(elevation);
        this.setTime(time);
    }

    public Point(String longitude, String latitude, String elevation) {
        this.setLongitude(longitude);
        this.setLatitude(latitude);
        this.setElevation(elevation);
    }

    public Point(String longitude, String latitude) {
        this.setLongitude(longitude);
        this.setLatitude(latitude);
    }

    public Point(double longitude, double latitude) {
        this.setLongitude(longitude);
        this.setLatitude(latitude);
    }

    public Point(double longitude, double latitude, double elevation) {
        this.setLongitude(longitude);
        this.setLatitude(latitude);
        this.setElevation(elevation);
    }

    public double getElevation() {
        return this.elevation;
    }

    public String getElevationAsString() {
        return Parser.formatElevation(this.elevation);
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public void setElevation(String elevation) {
        this.elevation = Double.parseDouble(elevation);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public String getLatitudeAsString() {
        return Parser.formatLatitude(this.latitude);
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = Double.parseDouble(latitude);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getLongitudeAsString() {
        return Parser.formatLongitude(this.longitude);
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = Double.parseDouble(longitude);
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public String getInformation() {
        return this.information;
    }

    public void setInformation(String information) {
        this.information = information;
    }

    public Point clone() {
        return new Point(this.getLongitudeAsString(), this.getLatitudeAsString(), this.getElevationAsString(), this.getTime(), this.getInformation());
    }

    public boolean equals(Object obj) {
        Point p1 = this;
        Point p2 = (Point)obj;
        return p1.getLongitude() == p2.getLongitude() && p1.getLatitude() == p2.getLatitude();
    }

    public boolean isWithin(Point leftUpperBoundary, Point rightLowerBoundary) {
        return leftUpperBoundary.getLongitude() <= this.longitude && rightLowerBoundary.getLongitude() >= this.longitude && leftUpperBoundary.getLatitude() >= this.latitude && rightLowerBoundary.getLatitude() <= this.latitude;
    }

    public double distance(Point point) {
        return Geometry.distance(this, point);
    }

    public double altitudeDifference(Point point) {
        return point.getElevation() - this.getElevation();
    }

    public String toString() {
        return "[" + this.getLongitudeAsString() + ";" + this.getLatitudeAsString() + "]";
    }

    public boolean isZero() {
        return Parser.equals0(this.longitude) && Parser.equals0(this.latitude);
    }
}

