/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.data.util;

import java.util.ArrayList;
import java.util.List;
import jgpstrackedit.config.Configuration;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;

public class TourPlaner {
    private static double averageSpeed = 20.0;
    private static double inclineTime100Meters = 10.0;
    private static double breakRatio = 0.5;
    private static double maxTourTime = 8.0;
    private double length;
    private double altitudeDifference;
    private Track track;

    public static void initConfig() {
        TourPlaner.setAverageSpeed(Configuration.getDoubleProperty("AVERAGESPEED"));
        TourPlaner.setInclineTime100Meters(Configuration.getDoubleProperty("INCLINETIME100METERS"));
        TourPlaner.setBreakRatio(Configuration.getDoubleProperty("BREAKRATIO"));
        TourPlaner.setMaxTourTime(Configuration.getHourProperty("MAXTOURTIME"));
    }

    public TourPlaner(Track track) {
        this.setTrack(track);
    }

    public Track getTrack() {
        return this.track;
    }

    public void setTrack(Track track) {
        this.track = track;
        this.length = track.getLength();
        this.altitudeDifference = track.getUpAltitudeDifference();
    }

    public static double getAverageSpeed() {
        return averageSpeed;
    }

    public static void setAverageSpeed(double averageSpeedP) {
        averageSpeed = averageSpeedP;
    }

    public static double getInclineTime100Meters() {
        return inclineTime100Meters;
    }

    public static void setInclineTime100Meters(double inclineTime100MetersP) {
        inclineTime100Meters = inclineTime100MetersP;
    }

    public static double getBreakRatio() {
        return breakRatio;
    }

    public static void setBreakRatio(double breakRatioP) {
        breakRatio = breakRatioP;
    }

    public static double getMaxTourTime() {
        return maxTourTime;
    }

    public static void setMaxTourTime(double maxTourTime) {
        TourPlaner.maxTourTime = maxTourTime;
    }

    public double drivingTime() {
        return this.length / averageSpeed + this.altitudeDifference / 100.0 * inclineTime100Meters / 60.0;
    }

    public double drivingTime(double tourLength, double altDiff) {
        return tourLength / averageSpeed + altDiff / 100.0 * inclineTime100Meters / 60.0;
    }

    public double tourTime() {
        return this.drivingTime() * (1.0 + breakRatio);
    }

    public double tourTime(double tourLength, double altDiff) {
        return this.drivingTime(tourLength, altDiff) * (1.0 + breakRatio);
    }

    public List<Point> dayTourMarkers() {
        ArrayList<Point> markers = new ArrayList<Point>();
        double tourLength = 0.0;
        double tourIncline = 0.0;
        Point firstPoint = this.getTrack().getFirstPoint();
        int i = 1;
        while (i < this.getTrack().getNumberPoints()) {
            Point secondPoint = this.getTrack().getPoint(i);
            tourLength += firstPoint.distance(secondPoint);
            double altDiff = firstPoint.altitudeDifference(secondPoint);
            if (altDiff > 0.0) {
                tourIncline += altDiff;
            }
            if (this.tourTime(tourLength, tourIncline) > TourPlaner.getMaxTourTime()) {
                markers.add(firstPoint.clone());
                tourLength = 0.0;
                tourIncline = 0.0;
            }
            firstPoint = secondPoint;
            ++i;
        }
        return markers;
    }
}

