/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.data.util;

import java.util.ArrayList;
import java.util.Stack;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;
import jgpstrackedit.data.util.UnDoLevel;

public class UnDoManager {
    private Stack<UnDoLevel> undoStack = new Stack();
    private Track track;

    public UnDoManager(Track track) {
        this.track = track;
    }

    public void add(Point point) {
        UnDoLevel udl = new UnDoLevel();
        udl.add(point);
        this.undoStack.push(udl);
    }

    public void add(ArrayList<Point> points) {
        UnDoLevel udl = new UnDoLevel();
        udl.add(points);
        this.undoStack.push(udl);
    }

    public void add(UnDoLevel undoLevel) {
        this.undoStack.push(undoLevel);
    }

    public void unDo() {
        if (!this.undoStack.empty()) {
            ArrayList<Point> points = this.undoStack.pop().getPoints();
            int i = points.size() - 1;
            while (i >= 0) {
                this.track.remove(points.get(i));
                --i;
            }
        }
    }

    public void commit() {
        this.undoStack.clear();
    }
}

