/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.tiledownload;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import jgpstrackedit.map.TileManager;
import jgpstrackedit.map.util.TileNumber;
import jgpstrackedit.util.ProgressHandler;

public class DlgProcessingTileDownload
extends JDialog
implements ProgressHandler {
    private final JPanel contentPanel = new JPanel();
    private JLabel lblDownloadStateLog;
    private JScrollPane scrollPane;
    private JTextArea textArea;
    private JProgressBar progressBar;
    private boolean progress = true;

    public DlgProcessingTileDownload() {
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("Tile Download");
        this.setBounds(100, 100, 457, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        this.lblDownloadStateLog = new JLabel("Download state log:");
        this.lblDownloadStateLog.setBounds(10, 11, 401, 14);
        this.contentPanel.add(this.lblDownloadStateLog);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBounds(10, 31, 431, 163);
        this.contentPanel.add(this.scrollPane);
        this.textArea = new JTextArea();
        this.scrollPane.setViewportView(this.textArea);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(10, 205, 431, 19);
        this.contentPanel.add(this.progressBar);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DlgProcessingTileDownload.this.okButtonActionPerformed(arg0);
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgProcessingTileDownload.this.cancelButtonActionPerformed(e);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
    }

    protected void okButtonActionPerformed(ActionEvent arg0) {
        this.setVisible(false);
    }

    protected void cancelButtonActionPerformed(ActionEvent e) {
        this.textArea.setText("Download cancelled.\n");
        this.setVisible(false);
        this.progress = false;
    }

    public void startDownload(TreeSet<TileNumber> downloadTiles, String targetDir, String extension) {
        this.textArea.setText("Start Download...\n");
        ArrayList<TileNumber> errorTiles = TileManager.getCurrentTileManager().downloadTiles(downloadTiles, targetDir, extension, this);
        if (errorTiles.size() > 0) {
            this.textArea.append("Error during tile download\n");
            this.textArea.append("Following tiles had not been downloaded:\n");
            for (TileNumber tile : errorTiles) {
                this.textArea.append(String.valueOf(tile.toString()) + "\n");
            }
        } else {
            this.textArea.append("Tile images downloaded sucessfully!");
            this.setVisible(false);
        }
    }

    @Override
    public boolean stepDone(int percentage) {
        this.progressBar.setValue(percentage);
        return this.progress;
    }
}

