/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.trackfile;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.ParserConfigurationException;
import jgpstrackedit.data.Track;
import jgpstrackedit.trackfile.TrackFile;
import jgpstrackedit.trackfile.TrackFileException;
import org.xml.sax.SAXException;

public class TrackFileManager {
    private static String lastMessage;
    private static LinkedList<TrackFile> trackFiles;

    static {
        trackFiles = new LinkedList();
    }

    public static Track openTrack(File file) throws TrackFileException {
        Track track = null;
        TrackFileManager.setLastMessage("");
        for (TrackFile trackFile : trackFiles) {
            try {
                System.out.println("\nTrackFileManager: trying to import " + trackFile.getTypeDescription());
                track = trackFile.openTrack(file);
                if (track != null && track.isValid()) break;
                TrackFileManager.setLastMessage(trackFile.getOpenReadyMessage());
            }
            catch (FileNotFoundException e) {
                throw new TrackFileException("Trackfile " + file.getAbsolutePath() + " not found!", e);
            }
            catch (SAXException ex) {
                ex.printStackTrace();
            }
            catch (ParserConfigurationException ex) {
                ex.printStackTrace();
            }
            catch (IOException e) {
                throw new TrackFileException("General file error", e);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        if (track == null) {
            throw new TrackFileException("Unknown trackfile type");
        }
        System.out.println("TrackFileManager: " + track.getTrackFileType() + " imported.");
        return track;
    }

    public static void saveTrack(Track track, File file, String trackFileType) throws TrackFileException {
        for (TrackFile trackFile : trackFiles) {
            if (!trackFile.getTypeDescription().equals(trackFileType)) continue;
            try {
                String fileName = file.getAbsolutePath();
                System.out.println("TrackFileManager.saveTrack: " + file.getAbsolutePath());
                if (!fileName.endsWith(trackFile.getTrackFileExtension())) {
                    fileName = String.valueOf(fileName) + "." + trackFile.getTrackFileExtension();
                    file = new File(fileName);
                }
                System.out.println("                            " + file.getAbsolutePath());
                trackFile.saveTrack(track, file);
            }
            catch (FileNotFoundException e) {
                throw new TrackFileException("Trackfile " + file.getAbsolutePath() + " could not be created", e);
            }
            catch (IOException e) {
                throw new TrackFileException("Error writing to trackfile " + file.getAbsolutePath(), e);
            }
        }
    }

    public static void addTrackFile(TrackFile trackFile) {
        trackFiles.add(trackFile);
    }

    public static String getLastMessage() {
        return lastMessage;
    }

    public static void setLastMessage(String lastMessage) {
        TrackFileManager.lastMessage = lastMessage;
    }

    public static List<FileNameExtensionFilter> getFileNameExtensionFilters() {
        LinkedList<FileNameExtensionFilter> filters = new LinkedList<FileNameExtensionFilter>();
        for (TrackFile trackFile : trackFiles) {
            filters.add(new FileNameExtensionFilter(trackFile.getTypeDescription(), trackFile.getTrackFileExtension()));
        }
        return filters;
    }
}

