/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.trackfile.gpxroute;

import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jgpstrackedit.trackfile.gpxroute.GPXRoute_Handler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class GPXRoute_Parser
implements ContentHandler {
    private GPXRoute_Handler handler;
    private Stack context;
    private StringBuffer buffer;
    private EntityResolver resolver;

    public GPXRoute_Parser(GPXRoute_Handler handler, EntityResolver resolver) {
        this.handler = handler;
        this.resolver = resolver;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
    }

    @Override
    public final void startDocument() throws SAXException {
    }

    @Override
    public final void endDocument() throws SAXException {
    }

    @Override
    public final void startElement(String ns, String name, String qname, Attributes attrs) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{qname, new AttributesImpl(attrs)});
        if ("rtept".equals(qname)) {
            this.handler.start_rtept(attrs);
        } else if ("link".equals(qname)) {
            this.handler.start_link(attrs);
        } else if ("rte".equals(qname)) {
            this.handler.start_rte(attrs);
        } else if ("copyright".equals(qname)) {
            this.handler.handle_copyright(attrs);
        } else if ("gpx".equals(qname)) {
            this.handler.start_gpx(attrs);
        } else if ("metadata".equals(qname)) {
            this.handler.start_metadata(attrs);
        } else if (!("time".equals(qname) || "text".equals(qname) || "name".equals(qname) || "ele".equals(qname))) {
            throw new SAXException("Illegal tag: " + qname);
        }
    }

    @Override
    public final void endElement(String ns, String name, String qname) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if ("rtept".equals(qname)) {
            this.handler.end_rtept();
        } else if ("link".equals(qname)) {
            this.handler.end_link();
        } else if ("rte".equals(qname)) {
            this.handler.end_rte();
        } else if ("gpx".equals(qname)) {
            this.handler.end_gpx();
        } else if ("metadata".equals(qname)) {
            this.handler.end_metadata();
        }
    }

    @Override
    public final void characters(char[] chars, int start, int len) throws SAXException {
        this.buffer.append(chars, start, len);
    }

    @Override
    public final void ignorableWhitespace(char[] chars, int start, int len) throws SAXException {
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = (Object[])this.context.peek();
        String here = (String)ctx[0];
        Attributes attrs = (Attributes)ctx[1];
        if ("time".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_time(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("text".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_text(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("name".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_name(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("ele".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_ele(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if (!("rtept".equals(here) || "link".equals(here) || "rte".equals(here) || "copyright".equals(here) || "gpx".equals(here) || "metadata".equals(here))) {
            throw new SAXException("Illegal tag: " + here);
        }
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputSource input) throws SAXException, ParserConfigurationException, IOException {
        GPXRoute_Parser.parse(input, this);
    }

    public void parse(URL url) throws SAXException, ParserConfigurationException, IOException {
        GPXRoute_Parser.parse(new InputSource(url.toExternalForm()), this);
    }

    public static void parse(InputSource input, GPXRoute_Handler handler) throws SAXException, ParserConfigurationException, IOException {
        GPXRoute_Parser.parse(input, new GPXRoute_Parser(handler, null));
    }

    public static void parse(URL url, GPXRoute_Handler handler) throws SAXException, ParserConfigurationException, IOException {
        GPXRoute_Parser.parse(new InputSource(url.toExternalForm()), handler);
    }

    private static void parse(InputSource input, GPXRoute_Parser recognizer) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        parser.setContentHandler(recognizer);
        parser.setErrorHandler(recognizer.getDefaultErrorHandler());
        if (recognizer.resolver != null) {
            parser.setEntityResolver(recognizer.resolver);
        }
        parser.parse(input);
    }

    protected ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException ex) throws SAXException {
                if (GPXRoute_Parser.this.context.isEmpty()) {
                    System.err.println("Missing DOCTYPE.");
                }
                throw ex;
            }

            @Override
            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            @Override
            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }
}

