/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.trackfile.tcx;

import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jgpstrackedit.trackfile.tcx.TcxHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class TcxParser
implements ContentHandler {
    private TcxHandler handler;
    private Stack context;
    private StringBuffer buffer;
    private EntityResolver resolver;

    public TcxParser(TcxHandler handler, EntityResolver resolver) {
        this.handler = handler;
        this.resolver = resolver;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
    }

    @Override
    public final void startDocument() throws SAXException {
    }

    @Override
    public final void endDocument() throws SAXException {
    }

    @Override
    public final void startElement(String ns, String name, String qname, Attributes attrs) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{qname, new AttributesImpl(attrs)});
        if ("Author".equals(qname)) {
            this.handler.start_Author(attrs);
        } else if ("HeartRateBpm".equals(qname)) {
            this.handler.start_HeartRateBpm(attrs);
        } else if ("Build".equals(qname)) {
            this.handler.start_Build(attrs);
        } else if ("Version".equals(qname)) {
            this.handler.start_Version(attrs);
        } else if ("Trackpoint".equals(qname)) {
            this.handler.start_Trackpoint(attrs);
        } else if ("Creator".equals(qname)) {
            this.handler.start_Creator(attrs);
        } else if ("Lap".equals(qname)) {
            this.handler.start_Lap(attrs);
        } else if ("Track".equals(qname)) {
            this.handler.start_Track(attrs);
        } else if ("TrainingCenterDatabase".equals(qname)) {
            this.handler.start_TrainingCenterDatabase(attrs);
        } else if ("Activity".equals(qname)) {
            this.handler.start_Activity(attrs);
        } else if ("AverageHeartRateBpm".equals(qname)) {
            this.handler.start_AverageHeartRateBpm(attrs);
        } else if ("Position".equals(qname)) {
            this.handler.start_Position(attrs);
        } else if ("MaximumHeartRateBpm".equals(qname)) {
            this.handler.start_MaximumHeartRateBpm(attrs);
        } else if ("Activities".equals(qname)) {
            this.handler.start_Activities(attrs);
        }
    }

    @Override
    public final void endElement(String ns, String name, String qname) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if ("Author".equals(qname)) {
            this.handler.end_Author();
        } else if ("HeartRateBpm".equals(qname)) {
            this.handler.end_HeartRateBpm();
        } else if ("Build".equals(qname)) {
            this.handler.end_Build();
        } else if ("Version".equals(qname)) {
            this.handler.end_Version();
        } else if ("Trackpoint".equals(qname)) {
            this.handler.end_Trackpoint();
        } else if ("Creator".equals(qname)) {
            this.handler.end_Creator();
        } else if ("Lap".equals(qname)) {
            this.handler.end_Lap();
        } else if ("Track".equals(qname)) {
            this.handler.end_Track();
        } else if ("TrainingCenterDatabase".equals(qname)) {
            this.handler.end_TrainingCenterDatabase();
        } else if ("Activity".equals(qname)) {
            this.handler.end_Activity();
        } else if ("AverageHeartRateBpm".equals(qname)) {
            this.handler.end_AverageHeartRateBpm();
        } else if ("Position".equals(qname)) {
            this.handler.end_Position();
        } else if ("MaximumHeartRateBpm".equals(qname)) {
            this.handler.end_MaximumHeartRateBpm();
        } else if ("Activities".equals(qname)) {
            this.handler.end_Activities();
        }
    }

    @Override
    public final void characters(char[] chars, int start, int len) throws SAXException {
        this.buffer.append(chars, start, len);
    }

    @Override
    public final void ignorableWhitespace(char[] chars, int start, int len) throws SAXException {
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = (Object[])this.context.peek();
        String here = (String)ctx[0];
        Attributes attrs = (Attributes)ctx[1];
        if ("LangID".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_LangID(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("TriggerMethod".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_TriggerMethod(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Calories".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_Calories(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Type".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_Type(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("BuildMinor".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_BuildMinor(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("MaximumSpeed".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_MaximumSpeed(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("BuildMajor".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_BuildMajor(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Author".equals(here)) {
            this.handler.handle_Author(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("ProductID".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_ProductID(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("PartNumber".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_PartNumber(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("TotalTimeSeconds".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_TotalTimeSeconds(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Time".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_Time(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Build".equals(here)) {
            this.handler.handle_Build(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("DistanceMeters".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_DistanceMeters(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("VersionMajor".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_VersionMajor(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("UnitId".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_UnitId(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Cadence".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_Cadence(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Trackpoint".equals(here)) {
            this.handler.handle_Trackpoint(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("LongitudeDegrees".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_LongitudeDegrees(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Value".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_Value(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Creator".equals(here)) {
            this.handler.handle_Creator(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Lap".equals(here)) {
            this.handler.handle_Lap(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Track".equals(here)) {
            this.handler.handle_Track(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("AltitudeMeters".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_AltitudeMeters(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Name".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_Name(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("TrainingCenterDatabase".equals(here)) {
            this.handler.handle_TrainingCenterDatabase(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Activity".equals(here)) {
            this.handler.handle_Activity(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("VersionMinor".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_VersionMinor(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("LatitudeDegrees".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_LatitudeDegrees(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Intensity".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_Intensity(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Id".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_Id(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("SensorState".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_SensorState(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("Activities".equals(here)) {
            this.handler.handle_Activities(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        }
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputSource input) throws SAXException, ParserConfigurationException, IOException {
        TcxParser.parse(input, this);
    }

    public void parse(URL url) throws SAXException, ParserConfigurationException, IOException {
        TcxParser.parse(new InputSource(url.toExternalForm()), this);
    }

    public static void parse(InputSource input, TcxHandler handler) throws SAXException, ParserConfigurationException, IOException {
        TcxParser.parse(input, new TcxParser(handler, null));
    }

    public static void parse(URL url, TcxHandler handler) throws SAXException, ParserConfigurationException, IOException {
        TcxParser.parse(new InputSource(url.toExternalForm()), handler);
    }

    private static void parse(InputSource input, TcxParser recognizer) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        parser.setContentHandler(recognizer);
        parser.setErrorHandler(recognizer.getDefaultErrorHandler());
        if (recognizer.resolver != null) {
            parser.setEntityResolver(recognizer.resolver);
        }
        parser.parse(input);
    }

    protected ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException ex) throws SAXException {
                if (TcxParser.this.context.isEmpty()) {
                    System.err.println("Missing DOCTYPE.");
                }
                throw ex;
            }

            @Override
            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            @Override
            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }
}

