/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.view;

import java.awt.Graphics2D;
import jgpstrackedit.config.Configuration;
import jgpstrackedit.config.view.ViewingConfiguration;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;
import jgpstrackedit.util.Parser;
import jgpstrackedit.view.Transform;

public class PointView {
    private boolean outView = false;
    private Point point;
    private Track track;

    public boolean isOutView() {
        return this.outView;
    }

    public void setOutView(boolean outView) {
        this.outView = outView;
    }

    public Point getPoint() {
        return this.point;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public PointView(Point point, Track track) {
        this.point = point;
        this.track = track;
    }

    public void paint(Graphics2D g2D, boolean isSelected) {
        int POINTSIZE = Configuration.getIntProperty("POINT_DIAMETER");
        int pointX = Transform.screenX(this.point.getLongitude());
        int pointY = Transform.screenY(this.point.getLatitude());
        g2D.fillOval(pointX - POINTSIZE / 2, pointY - POINTSIZE / 2, POINTSIZE, POINTSIZE);
        if (isSelected) {
            g2D.drawOval(pointX - POINTSIZE / 2 - 2, pointY - POINTSIZE / 2 - 2, POINTSIZE + 4, POINTSIZE + 4);
        }
        if (ViewingConfiguration.isShowLength()) {
            g2D.drawString(Parser.formatLength(this.point.getLength()), pointX + 5, pointY - 5);
        }
        if (ViewingConfiguration.isShowInformation() && this.point.getInformation() != null) {
            g2D.drawString(this.point.getInformation(), pointX + 5, pointY + 5);
        }
    }

    public void paintStartMarker(Graphics2D g2D) {
        int pointX = Transform.screenX(this.point.getLongitude());
        int pointY = Transform.screenY(this.point.getLatitude());
        g2D.drawLine(pointX, pointY, pointX, pointY - 10);
        g2D.drawLine(pointX, pointY - 10, pointX + 10, pointY - 10);
        g2D.drawLine(pointX + 6, pointY - 14, pointX + 10, pointY - 10);
        g2D.drawLine(pointX + 6, pointY - 6, pointX + 10, pointY - 10);
    }

    public void paintEndMarker(Graphics2D g2D) {
        int pointX = Transform.screenX(this.point.getLongitude());
        int pointY = Transform.screenY(this.point.getLatitude());
        g2D.drawLine(pointX, pointY, pointX, pointY - 8);
        g2D.drawRect(pointX, pointY - 14, 10, 8);
        g2D.fillRect(pointX, pointY - 14, 5, 4);
        g2D.fillRect(pointX + 5, pointY - 10, 5, 4);
    }

    public boolean contains(int x, int y) {
        int pointX = Transform.screenX(this.point.getLongitude());
        int pointY = Transform.screenY(this.point.getLatitude());
        int POINTSIZE = Configuration.getIntProperty("POINT_DIAMETER");
        return Math.abs(pointX - x) < POINTSIZE && Math.abs(pointY - y) < POINTSIZE;
    }

    public int getX() {
        return Transform.screenX(this.point.getLongitude());
    }

    public int getY() {
        return Transform.screenY(this.point.getLatitude());
    }
}

