/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.view;

import jgpstrackedit.data.Point;
import jgpstrackedit.map.TileManager;
import jgpstrackedit.map.util.TileBoundary;

public class Transform {
    private static double upperLeftX;
    private static double upperLeftY;
    private static double mapWidth;
    private static double mapHeight;
    private static int screenWidth;
    private static int screenHeight;
    private static double scaleX;
    private static double scaleY;
    private static int zoomLevel;

    static {
        zoomLevel = 0;
    }

    public static void setTransform(Point upperLeftBoundary, Point lowerRightBoundary, int width, int height, boolean recalculateZoomLevel) {
        screenWidth = width;
        screenHeight = height;
        upperLeftX = upperLeftBoundary.getLongitude();
        upperLeftY = upperLeftBoundary.getLatitude();
        double lowerRightX = lowerRightBoundary.getLongitude();
        double lowerRightY = lowerRightBoundary.getLatitude();
        if (TileManager.getCurrentTileManager() != null) {
            if (recalculateZoomLevel) {
                zoomLevel = TileManager.calculateZoomLevel(upperLeftX, upperLeftY, lowerRightX, lowerRightY);
            }
            scaleX = TileBoundary.scaleX(zoomLevel);
            scaleY = TileBoundary.scaleY(zoomLevel, upperLeftX, upperLeftY);
            mapWidth = scaleX * (double)width;
            mapHeight = scaleY * (double)height;
        } else {
            mapWidth = lowerRightX - upperLeftX;
            double resolutionX = mapWidth / (double)screenWidth;
            mapHeight = upperLeftY - lowerRightY;
            double resolutionY = mapHeight / (double)screenHeight;
            if (resolutionX > resolutionY) {
                mapHeight = resolutionX * (double)screenHeight;
            } else {
                mapWidth = resolutionY * (double)screenWidth;
            }
            scaleX = mapWidth / (double)screenWidth;
            scaleY = mapHeight / (double)screenHeight;
        }
    }

    public static void zoomCenter(Point centerPoint) {
        upperLeftX = centerPoint.getLongitude() - mapWidth / 2.0;
        upperLeftY = centerPoint.getLatitude() + mapHeight / 2.0;
    }

    public static void zoomOut() {
        if (TileManager.getCurrentTileManager() != null) {
            zoomLevel = TileManager.decZoomLevel(zoomLevel);
            scaleX = TileBoundary.scaleX(zoomLevel);
            scaleY = TileBoundary.scaleY(zoomLevel, upperLeftX, upperLeftY);
            mapWidth = scaleX * (double)screenWidth;
            mapHeight = scaleY * (double)screenHeight;
        }
    }

    public static void zoomIn() {
        if (TileManager.getCurrentTileManager() != null) {
            zoomLevel = TileManager.incZoomLevel(zoomLevel);
            scaleX = TileBoundary.scaleX(zoomLevel);
            scaleY = TileBoundary.scaleY(zoomLevel, upperLeftX, upperLeftY);
            mapWidth = scaleX * (double)screenWidth;
            mapHeight = scaleY * (double)screenHeight;
        }
    }

    public static int screenX(double longitude) {
        return (int)((longitude - upperLeftX) / scaleX);
    }

    public static int screenY(double lattitude) {
        return (int)((upperLeftY - lattitude) / scaleY);
    }

    public static double mapLongitude(int screenX) {
        return (double)screenX * mapWidth / (double)screenWidth + upperLeftX;
    }

    public static double mapLatitude(int screenY) {
        return upperLeftY - (double)screenY * mapHeight / (double)screenHeight;
    }

    public static Point mapPoint(int screenX, int screenY) {
        return new Point(Transform.mapLongitude(screenX), Transform.mapLatitude(screenY));
    }

    public static void setNewScreenDimension(int width, int height) {
        double resolutionX = (mapWidth = mapWidth * (double)width / (double)screenWidth) / (double)(screenWidth = width);
        double resolutionY = (mapHeight = mapHeight * (double)height / (double)screenHeight) / (double)(screenHeight = height);
        if (resolutionX > resolutionY) {
            mapHeight = resolutionX * (double)screenHeight;
        } else {
            mapWidth = resolutionY * (double)screenWidth;
        }
    }

    public static void setScreenDimension(int width, int height) {
        screenWidth = width;
        screenHeight = height;
    }

    public static Point getUpperLeftBoundary() {
        return new Point(upperLeftX, upperLeftY);
    }

    public static Point getLowerRightBoundary() {
        return new Point(upperLeftX + mapWidth, upperLeftY - mapHeight);
    }

    public static int getScreenWidth() {
        return screenWidth;
    }

    public static int getScreenHeight() {
        return screenHeight;
    }

    public static int getZoomLevel() {
        return zoomLevel;
    }

    public static void zoom(int newZoomLevel, Point upperLeftBoundary) {
        upperLeftX = upperLeftBoundary.getLongitude();
        upperLeftY = upperLeftBoundary.getLatitude();
        zoomLevel = newZoomLevel;
        scaleX = TileBoundary.scaleX(zoomLevel);
        scaleY = TileBoundary.scaleY(zoomLevel, upperLeftX, upperLeftY);
        mapWidth = scaleX * (double)screenWidth;
        mapHeight = scaleY * (double)screenHeight;
    }
}

