/*
 * Decompiled with CFR 0.152.
 */
package shared.dataformathelper;

public class JDataFormatHelper {
    public static int byteToInt(byte b) {
        return (b & 0x7F) + (b & 0x80);
    }

    public static long byteToLong(byte b) {
        return (long)(b & 0x7F) + (long)(b & 0x80);
    }

    public static int buf4ToInt(byte[] buf, int offset, boolean bIntel) {
        assert (buf.length >= offset + 4);
        return bIntel ? JDataFormatHelper.byteToInt(buf[offset]) + (JDataFormatHelper.byteToInt(buf[offset + 1]) << 8) + (JDataFormatHelper.byteToInt(buf[offset + 2]) << 16) + (JDataFormatHelper.byteToInt(buf[offset + 3]) << 24) : JDataFormatHelper.byteToInt(buf[offset + 3]) + (JDataFormatHelper.byteToInt(buf[offset + 2]) << 8) + (JDataFormatHelper.byteToInt(buf[offset + 1]) << 16) + (JDataFormatHelper.byteToInt(buf[offset]) << 24);
    }

    public static int buf4ToIntSigned(byte[] buf, int offset, boolean bIntel) {
        assert (buf.length >= offset + 4);
        long i = bIntel ? (long)(JDataFormatHelper.byteToInt(buf[offset]) + (JDataFormatHelper.byteToInt(buf[offset + 1]) << 8) + (JDataFormatHelper.byteToInt(buf[offset + 2]) << 16) + (JDataFormatHelper.byteToInt((byte)(0x7F & buf[offset + 3])) << 24)) : (long)(JDataFormatHelper.byteToInt(buf[offset + 3]) + (JDataFormatHelper.byteToInt(buf[offset + 2]) << 8) + (JDataFormatHelper.byteToInt(buf[offset + 1]) << 16) + (JDataFormatHelper.byteToInt((byte)(0x7F & buf[offset])) << 24));
        if (((bIntel ? buf[offset + 3] : buf[offset]) & 0x80) != 0) {
            i -= 0x80000000L;
        }
        return (int)i;
    }

    public static int buf2ToInt(byte[] buf, int offset, boolean bIntel) {
        assert (buf.length >= offset + 2);
        return bIntel ? JDataFormatHelper.byteToInt(buf[offset]) + (JDataFormatHelper.byteToInt(buf[offset + 1]) << 8) : JDataFormatHelper.byteToInt(buf[offset + 1]) + (JDataFormatHelper.byteToInt(buf[offset]) << 8);
    }

    public static int buf2ToIntBE(byte[] buf, int offset) {
        assert (buf.length >= offset + 2);
        return (JDataFormatHelper.byteToInt(buf[offset]) << 8) + JDataFormatHelper.byteToInt(buf[offset + 1]);
    }

    public static short buf2ToShortBE(byte[] buf, int offset) {
        assert (buf.length >= offset + 2);
        return (short)((JDataFormatHelper.byteToInt(buf[offset]) << 8) + JDataFormatHelper.byteToInt(buf[offset + 1]));
    }

    public static int buf4ToIntBE(byte[] buf, int offset) {
        assert (buf.length >= offset + 4);
        return (JDataFormatHelper.byteToInt(buf[offset]) << 24) + (JDataFormatHelper.byteToInt(buf[offset + 1]) << 16) + (JDataFormatHelper.byteToInt(buf[offset + 1]) << 16) + (JDataFormatHelper.byteToInt(buf[offset + 2]) << 8) + JDataFormatHelper.byteToInt(buf[offset + 3]);
    }

    public static long buf4ToLong(byte[] buf, int offset, boolean bIntel) {
        assert (buf.length >= offset + 4);
        return bIntel ? JDataFormatHelper.byteToLong(buf[offset]) + (JDataFormatHelper.byteToLong(buf[offset + 1]) << 8) + (JDataFormatHelper.byteToLong(buf[offset + 2]) << 16) + (JDataFormatHelper.byteToLong(buf[offset + 3]) << 24) : JDataFormatHelper.byteToLong(buf[offset + 3]) + (JDataFormatHelper.byteToLong(buf[offset + 2]) << 8) + (JDataFormatHelper.byteToLong(buf[offset + 1]) << 16) + (JDataFormatHelper.byteToLong(buf[offset]) << 24);
    }

    public static long buf4ToLongSigned(byte[] buf, int offset) {
        assert (buf.length >= offset + 4);
        long l = JDataFormatHelper.byteToLong(buf[offset]) + (JDataFormatHelper.byteToLong(buf[offset + 1]) << 8) + (JDataFormatHelper.byteToLong(buf[offset + 2]) << 16) + (JDataFormatHelper.byteToLong((byte)(0x7F & buf[offset + 3])) << 24);
        if ((buf[offset + 3] & 0x80) != 0) {
            l -= 0x100000000L;
        }
        return l;
    }

    public static short buf1ToShort(byte[] buf, int offset) {
        assert (buf.length >= offset + 1);
        return (short)JDataFormatHelper.byteToInt(buf[offset]);
    }

    public static void IntToBuf2(int val, byte[] buf, int offset, boolean bIntel) {
        assert (buf.length >= offset + 2);
        buf[offset + (bIntel ? 0 : 1)] = (byte)(val & 0xFF);
        buf[offset + (bIntel ? 1 : 0)] = (byte)(val >> 8 & 0xFF);
    }

    public static void IntToBuf2BE(int val, byte[] buf, int offset) {
        assert (buf.length >= offset + 2);
        buf[offset] = (byte)(val >> 8 & 0xFF);
        buf[offset + 1] = (byte)(val & 0xFF);
    }

    public static void IntToBuf4(int val, byte[] buf, int offset, boolean bIntel) {
        assert (buf.length >= offset + 4);
        buf[offset + (bIntel ? 0 : 3)] = (byte)(val & 0xFF);
        buf[offset + (bIntel ? 1 : 2)] = (byte)(val >> 8 & 0xFF);
        buf[offset + (bIntel ? 2 : 1)] = (byte)(val >> 16 & 0xFF);
        buf[offset + (bIntel ? 3 : 0)] = (byte)(val >> 24 & 0xFF);
    }

    public static void LongToBuf4(long val, byte[] buf, int offset) {
        assert (buf.length >= offset + 4);
        buf[offset] = (byte)(val & 0xFFL);
        buf[offset + 1] = (byte)(val >> 8 & 0xFFL);
        buf[offset + 2] = (byte)(val >> 16 & 0xFFL);
        buf[offset + 3] = (byte)(val >> 24 & 0xFFL);
    }

    public static void ShortToBuf1(short val, byte[] buf, int offset) {
        assert (buf.length >= offset + 1);
        buf[offset] = (byte)(val & 0xFF);
    }

    public static void IntSignedToBuf4(int val, byte[] buf, int offset) {
        assert (buf.length >= offset + 4);
        buf[offset] = (byte)(val & 0xFF);
        buf[offset + 1] = (byte)(val >> 8 & 0xFF);
        buf[offset + 2] = (byte)(val >> 16 & 0xFF);
        buf[offset + 3] = (byte)(val >> 24 & 0xFF);
    }
}

