/*
 * Decompiled with CFR 0.152.
 */
package shared.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SpringLayout;
import shared.aa.JAALabel;
import shared.progbar.JProgBar;
import shared.proglistener.ProgListener;
import shared.proglistener.ProgNotify;

public class JWaitDialog
extends JDialog
implements ProgListener {
    private JAALabel m_label;
    private JProgBar m_bar;
    private JFrame m_frame;
    private String m_cancelStr;
    private boolean m_bCancel = false;
    private int m_width = 450;
    private String m_labelText;
    private int m_min = 0;
    private int m_max = 1000;
    private boolean m_bIndeterminate;
    private Color m_textColor = null;
    private Color m_barColor = null;

    public JWaitDialog(JFrame frame, String captionStr, String cancelStr) {
        super(frame, captionStr, true);
        this.m_frame = frame;
        this.m_cancelStr = cancelStr;
    }

    public JWaitDialog(JFrame frame, String captionStr) {
        super(frame, captionStr, false);
        this.m_frame = frame;
        this.m_cancelStr = null;
    }

    public JWaitDialog(JFrame frame, String captionStr, int width) {
        super(frame, captionStr, false);
        this.m_frame = frame;
        this.m_cancelStr = null;
        this.m_width = width;
    }

    public JWaitDialog(JFrame frame, String captionStr, String cancelStr, int width) {
        super(frame, captionStr, false);
        this.m_frame = frame;
        this.m_cancelStr = null;
        this.m_width = width;
    }

    public void setIndeterminate(boolean bIndeterminate) {
        this.m_bIndeterminate = bIndeterminate;
    }

    public boolean wasCancelled() {
        return this.m_bCancel;
    }

    protected void doInit() {
        this.setDefaultCloseOperation(0);
        Container contentPane = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        contentPane.setLayout(layout);
        this.m_label = new JAALabel(this.m_labelText);
        contentPane.add(this.m_label);
        layout.putConstraint("West", (Component)this.m_label, 10, "West", (Component)contentPane);
        layout.putConstraint("North", (Component)this.m_label, 10, "North", (Component)contentPane);
        this.m_bar = new JProgBar(this.m_min, this.m_max);
        if (this.m_textColor != null) {
            this.m_bar.setForeground(this.m_textColor);
        }
        if (this.m_barColor != null) {
            this.m_bar.setBackground(this.m_barColor);
        }
        this.m_bar.setIndeterminate(this.m_bIndeterminate);
        contentPane.add(this.m_bar);
        layout.putConstraint("West", (Component)this.m_bar, 0, "West", (Component)this.m_label);
        layout.putConstraint("South", (Component)this.m_bar, 30, "North", (Component)this.m_bar);
        layout.putConstraint("East", (Component)this.m_bar, -10, "East", (Component)contentPane);
        layout.putConstraint("North", (Component)this.m_bar, 5, "South", (Component)this.m_label);
        if (this.m_cancelStr != null) {
            JButton cancel = new JButton(this.m_cancelStr);
            contentPane.add(cancel);
            layout.putConstraint("HorizontalCenter", (Component)cancel, 0, "HorizontalCenter", (Component)contentPane);
            layout.putConstraint("South", (Component)cancel, -10, "South", (Component)contentPane);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    JWaitDialog.this.m_bCancel = true;
                    JWaitDialog.this.stop();
                }
            });
        }
        this.pack();
        this.setSize(this.m_width, this.m_cancelStr != null ? 130 : 100);
        this.setResizable(false);
        this.setLocationRelativeTo(this.m_frame);
    }

    public void setRange(int min, int max) {
        this.m_min = min;
        this.m_max = max;
    }

    public void getRangeMin() {
    }

    public int getRangeMax() {
        return this.m_max;
    }

    public void setTextColor(Color color) {
        if (this.m_bar != null) {
            this.m_bar.setForeground(color);
        }
        this.m_textColor = color;
    }

    public void setBarColor(Color color) {
        if (this.m_bar != null) {
            this.m_bar.setBackground(color);
        }
        this.m_barColor = color;
    }

    public boolean start() {
        this.doInit();
        this.setVisible(true);
        return !this.m_bCancel;
    }

    public boolean stop() {
        this.setVisible(false);
        this.dispose();
        return !this.m_bCancel;
    }

    public void setLabel(String label) {
        this.m_labelText = label;
        if (this.m_label != null) {
            this.m_label.setText(label);
        }
    }

    public boolean notify(ProgNotify progNotify) {
        this.m_bar.setValue(progNotify.getProgress());
        this.m_bar.setString(progNotify.getMessage());
        return this.m_bCancel;
    }
}

