/*
 * Decompiled with CFR 0.152.
 */
package shared.number;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public final class JDoubleHelper {
    private JDoubleHelper() {
    }

    public static double parseDouble(String str, Locale locale) throws NumberFormatException {
        double val;
        try {
            val = Double.parseDouble(str);
        }
        catch (NumberFormatException ex) {
            try {
                NumberFormat numberFormat = NumberFormat.getInstance(locale);
                val = numberFormat.parse(str).doubleValue();
            }
            catch (ParseException e) {
                throw new NumberFormatException(e.getMessage());
            }
        }
        return val;
    }

    public static double parseDouble(String str) throws NumberFormatException {
        return JDoubleHelper.parseDouble(str, Locale.getDefault());
    }
}

