/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.entity;

import com.ehsunbehravesh.mypasswords.Domain;
import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.entity.PasswordEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class PasswordTag {
    private int id;
    private String title;

    public PasswordTag(String title) {
        this.title = title.toLowerCase();
    }

    public PasswordTag(int id, String title) {
        this.id = id;
        this.title = title.toLowerCase();
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordEntry[] readEntries() {
        ArrayList<PasswordEntry> passwords = new ArrayList<PasswordEntry>();
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        ResultSet rs = null;
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = String.format("SELECT * FROM PASSWORD_ENTRY pe INNER JOIN PASSWORD_ENTRY_PASSWORD_TAG pept ON (pe.ID = pept.PASSWORD_ENTRY_ID) WHERE pept.PASSWORD_TAG_ID = %d ORDER BY pe.title", this.id);
                rs = st.executeQuery(sql);
                while (rs.next()) {
                    PasswordEntry password = new PasswordEntry(rs.getInt("id"), rs.getString("title"), rs.getString("url"), rs.getString("description"), rs.getString("username"), rs.getString("password"));
                    passwords.add(password);
                }
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                }
            }
        }
        PasswordEntry[] arrPasswords = new PasswordEntry[passwords.size()];
        arrPasswords = passwords.toArray(arrPasswords);
        return arrPasswords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                ResultSet rs;
                PreparedStatement st = null;
                String sql = "";
                sql = this.id <= 0 ? String.format("INSERT INTO PASSWORD_TAG (TITLE) VALUES ('%s')", this.title) : String.format("UPDATE PASSWORD_TAG SET TITLE = '%s' WHERE ID = %d", this.title, this.id);
                st = con.prepareStatement(sql, 1);
                int result = st.executeUpdate();
                if (this.id <= 0 && (rs = st.getGeneratedKeys()).next()) {
                    this.id = rs.getInt(1);
                }
                boolean bl = result == 1;
                return bl;
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.title + " (" + this.readEntries().length + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = String.format("SELECT * FROM PASSWORD_TAG WHERE ID = %d", this.id);
                ResultSet rs = st.executeQuery(sql);
                if (rs.next()) {
                    this.id = rs.getInt("ID");
                    this.title = rs.getString("TITLE");
                }
                boolean bl = true;
                return bl;
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadByTitle() {
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = String.format("SELECT * FROM PASSWORD_TAG WHERE TITLE = '%s'", this.title);
                ResultSet rs = st.executeQuery(sql);
                if (rs.next()) {
                    this.id = rs.getInt("ID");
                    this.title = rs.getString("TITLE");
                }
                boolean bl = true;
                return bl;
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = String.format("DELETE FROM PASSWORD_TAG WHERE ID = %d", this.id);
                st.executeUpdate(sql);
                boolean bl = true;
                return bl;
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordTag[] getAllTags() {
        ArrayList<PasswordTag> tags = new ArrayList<PasswordTag>();
        Domain domain = Domain.getInstance();
        Connection con = domain.getDBConnection();
        if (con != null) {
            try {
                Statement st = con.createStatement();
                String sql = "SELECT * FROM PASSWORD_TAG ORDER BY title";
                ResultSet rs = st.executeQuery(sql);
                while (rs.next()) {
                    PasswordTag tag = new PasswordTag(rs.getInt("id"), rs.getString("title"));
                    tags.add(tag);
                }
            }
            catch (SQLException ex) {
                Logger.log(ex.getMessage());
            }
            finally {
                try {
                    con.close();
                }
                catch (SQLException ex) {
                    Logger.log(ex.getMessage());
                }
            }
        }
        PasswordTag[] arrTags = new PasswordTag[tags.size()];
        arrTags = tags.toArray(arrTags);
        return arrTags;
    }

    public static void cleanTags() {
        PasswordTag[] allTags = PasswordTag.getAllTags();
        for (int i = 0; i < allTags.length; ++i) {
            PasswordTag passwordTag = allTags[i];
            PasswordEntry[] passwords = passwordTag.readEntries();
            if (passwords.length > 0) continue;
            passwordTag.delete();
        }
    }
}

