/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.gui;

import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.entity.PasswordEntry;
import com.ehsunbehravesh.mypasswords.entity.PasswordTag;
import com.ehsunbehravesh.mypasswords.gui.MainFrame;
import com.ehsunbehravesh.mypasswords.gui.PasswordTreeCellRenderer;
import com.ehsunbehravesh.mypasswords.gui.PasswordTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class BrowseDialog2
extends JDialog {
    private JFrame parent;
    private PasswordTag[] tags;
    private String tagsCaption = "Tags";
    private JTree treTags;
    private JPanel pnlMain;
    private JScrollPane scpMain;

    public BrowseDialog2(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.myInitComponents();
    }

    private void myInitComponents() {
        this.setSize(300, 400);
        Utils.setCenterOfParent(this.parent, (JDialog)this);
        this.setFont(this.parent.getFont());
        this.setComponentOrientation(this.parent.getComponentOrientation());
        MainFrame mainFrame = (MainFrame)this.getParent();
        if (mainFrame.getCurrentLanguage() != null) {
            // empty if block
        }
        this.pnlMain = new JPanel(new BorderLayout());
        this.setContentPane(this.pnlMain);
        this.loadTags();
        this.displayTags();
    }

    private void loadTags() {
        this.tags = PasswordTag.getAllTags();
    }

    private void displayTags() {
        PasswordTreeNode root = new PasswordTreeNode(String.format(this.tagsCaption + " (%d)", this.tags.length), true);
        int i = 0;
        for (i = 0; i < this.tags.length; ++i) {
            PasswordTag passwordTag = this.tags[i];
            PasswordEntry[] passwordEntries = passwordTag.readEntries();
            PasswordTreeNode tagNode = new PasswordTreeNode(passwordTag, true);
            root.insert(tagNode, i);
            for (int j = 0; j < passwordEntries.length; ++j) {
                PasswordEntry passwordEntry = passwordEntries[j];
                PasswordTreeNode passwordNode = new PasswordTreeNode(passwordEntry, false);
                tagNode.insert(passwordNode, j);
            }
        }
        PasswordEntry[] passwordsWithoutTag = PasswordEntry.getPasswordEntriesWithoutTag();
        if (passwordsWithoutTag.length > 0) {
            PasswordTreeNode tagNode = new PasswordTreeNode(String.format("[no tag] (%d)", passwordsWithoutTag.length), true);
            for (int k = 0; k < passwordsWithoutTag.length; ++k) {
                PasswordEntry passwordEntry = passwordsWithoutTag[k];
                PasswordTreeNode passwordNode = new PasswordTreeNode(passwordEntry, false);
                tagNode.insert(passwordNode, k);
            }
            root.insert(tagNode, i);
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.treTags = new JTree(model);
        this.treTags.setCellRenderer(new PasswordTreeCellRenderer());
        this.scpMain = new JScrollPane(this.treTags);
        this.pnlMain.add((Component)this.scpMain, "Center");
        this.refresh();
        this.treTags.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                BrowseDialog2.this.doMouseClicked(me);
            }
        });
    }

    private void doMouseClicked(MouseEvent me) {
        PasswordEntry passwordEntry;
        PasswordEntry decryptedPasswordEntry;
        PasswordTreeNode lastNode;
        TreePath tp = this.treTags.getPathForLocation(me.getX(), me.getY());
        if (tp != null && (lastNode = (PasswordTreeNode)tp.getLastPathComponent()).isLeaf() && !lastNode.getAllowsChildren() && (decryptedPasswordEntry = new PasswordEntry((passwordEntry = (PasswordEntry)lastNode.getUserObject()).getId())).load() && me.getClickCount() == 2) {
            MainFrame owner = (MainFrame)this.getOwner();
            owner.setPasswordEntry(decryptedPasswordEntry);
            owner.displayPasswordEntry();
            this.setVisible(false);
        }
    }

    private void refresh() {
        this.scpMain.setVisible(false);
        this.scpMain.setVisible(true);
    }
}

