/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.io;

import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.io.FileSaverMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Observable;

public class FileSaver
extends Observable
implements Runnable {
    private File file;
    private byte[] contentOfFile;
    private int bufferSize;
    private FileOutputStream fileOutputStream;

    public FileSaver(File file, byte[] contentOfFile, int bufferSize) {
        this.file = file;
        this.contentOfFile = contentOfFile;
        this.bufferSize = bufferSize;
        if (bufferSize > contentOfFile.length) {
            bufferSize = contentOfFile.length;
        }
    }

    protected void finalize() throws Throwable {
        if (this.fileOutputStream != null) {
            this.fileOutputStream.close();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int startIndex = 0;
        int endIndex = this.bufferSize - 1;
        try {
            this.fileOutputStream = new FileOutputStream(this.file);
            boolean endOfContent = false;
            while (!endOfContent) {
                endOfContent = endIndex == this.contentOfFile.length - 1;
                byte[] buffer = new byte[endIndex - startIndex + 1];
                System.arraycopy(this.contentOfFile, startIndex, buffer, 0, buffer.length);
                this.fileOutputStream.write(buffer);
                startIndex = endIndex + 1;
                endIndex = endIndex + this.bufferSize - 1;
                if (endIndex > this.contentOfFile.length - 1) {
                    endIndex = this.contentOfFile.length - 1;
                }
                this.setChanged();
                this.notifyObservers(new FileSaverMessage(1));
                Thread.sleep(1L);
            }
            this.setChanged();
            this.notifyObservers(new FileSaverMessage(2, ""));
        }
        catch (Exception ex) {
            this.setChanged();
            this.notifyObservers(new FileSaverMessage(3, ex.getMessage()));
            Logger.log(ex.getMessage());
        }
        finally {
            if (this.fileOutputStream != null) {
                try {
                    this.fileOutputStream.close();
                }
                catch (IOException ex) {
                    Logger.log(ex.getMessage());
                }
            }
        }
    }
}

