/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.positioners.BasicBalloonTipPositioner;
import net.java.balloontip.positioners.Left_Above_Positioner;
import net.java.balloontip.positioners.Left_Below_Positioner;
import net.java.balloontip.positioners.Right_Above_Positioner;
import net.java.balloontip.positioners.Right_Below_Positioner;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.RoundedBalloonStyle;

public class BalloonTip
extends JPanel {
    private static Icon defaultIcon = new ImageIcon(BalloonTip.class.getResource("/net/java/balloontip/images/close_default.png"));
    private static Icon rolloverIcon = new ImageIcon(BalloonTip.class.getResource("/net/java/balloontip/images/close_rollover.png"));
    private static Icon pressedIcon = new ImageIcon(BalloonTip.class.getResource("/net/java/balloontip/images/close_pressed.png"));
    private JLabel label = new JLabel();
    private JButton closeButton = null;
    private boolean isVisible = true;
    private boolean clickToClose = false;
    private boolean clickToHide = false;
    private ComponentAdapter attachedComponentListener = new ComponentAdapter(){

        public void componentMoved(ComponentEvent e) {
            BalloonTip.this.refreshLocation();
        }

        public void componentResized(ComponentEvent e) {
            BalloonTip.this.refreshLocation();
        }

        public void componentShown(ComponentEvent e) {
            BalloonTip.this.checkVisibility();
        }

        public void componentHidden(ComponentEvent e) {
            BalloonTip.this.checkVisibility();
        }
    };
    private ComponentAdapter topLevelContainerListener = new ComponentAdapter(){

        public void componentResized(ComponentEvent e) {
            if (BalloonTip.this.attachedComponent.isShowing()) {
                BalloonTip.this.refreshLocation();
            }
        }
    };
    private MouseAdapter clickListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            e.consume();
        }

        public void mouseReleased(MouseEvent e) {
            if (BalloonTip.this.clickToHide) {
                BalloonTip.this.setVisible(false);
            } else if (BalloonTip.this.clickToClose) {
                BalloonTip.this.closeBalloon();
            }
        }
    };
    private AncestorListener attachedComponentParentListener = null;
    protected BalloonTipStyle style;
    protected BalloonTipPositioner positioner;
    protected JLayeredPane topLevelContainer = null;
    protected JComponent attachedComponent;

    public BalloonTip(JComponent attachedComponent, String text) {
        this(attachedComponent, text, new RoundedBalloonStyle(5, 5, Color.WHITE, Color.BLACK), true);
    }

    public BalloonTip(JComponent attachedComponent, String text, BalloonTipStyle style, boolean useCloseButton) {
        this(attachedComponent, text, style, Orientation.LEFT_ABOVE, AttachLocation.ALIGNED, 16, 20, useCloseButton);
    }

    public BalloonTip(JComponent attachedComponent, String text, BalloonTipStyle style, Orientation orientation, AttachLocation attachLocation, int horizontalOffset, int verticalOffset, boolean useCloseButton) {
        BasicBalloonTipPositioner positioner = null;
        float attachX = 0.0f;
        float attachY = 0.0f;
        boolean fixedAttachLocation = true;
        switch (attachLocation) {
            case ALIGNED: {
                fixedAttachLocation = false;
                break;
            }
            case CENTER: {
                attachX = 0.5f;
                attachY = 0.5f;
                break;
            }
            case NORTH: {
                attachX = 0.5f;
                break;
            }
            case NORTHEAST: {
                attachX = 1.0f;
                break;
            }
            case EAST: {
                attachX = 1.0f;
                attachY = 0.5f;
                break;
            }
            case SOUTHEAST: {
                attachX = 1.0f;
                attachY = 1.0f;
                break;
            }
            case SOUTH: {
                attachX = 0.5f;
                attachY = 1.0f;
                break;
            }
            case SOUTHWEST: {
                attachY = 1.0f;
                break;
            }
            case WEST: {
                attachY = 0.5f;
                break;
            }
        }
        switch (orientation) {
            case LEFT_ABOVE: {
                positioner = new Left_Above_Positioner(horizontalOffset, verticalOffset);
                break;
            }
            case LEFT_BELOW: {
                positioner = new Left_Below_Positioner(horizontalOffset, verticalOffset);
                break;
            }
            case RIGHT_ABOVE: {
                positioner = new Right_Above_Positioner(horizontalOffset, verticalOffset);
                break;
            }
            case RIGHT_BELOW: {
                positioner = new Right_Below_Positioner(horizontalOffset, verticalOffset);
            }
        }
        positioner.enableFixedAttachLocation(fixedAttachLocation);
        positioner.setAttachLocation(attachX, attachY);
        this.initializePhase1(attachedComponent, text, style, positioner, useCloseButton);
    }

    public BalloonTip(JComponent attachedComponent, String text, BalloonTipStyle style, BalloonTipPositioner positioner, boolean useCloseButton) {
        this.initializePhase1(attachedComponent, text, style, positioner, useCloseButton);
    }

    public void finalize() {
        this.closeBalloon();
    }

    public void setText(String text) {
        this.label.setText(text);
        this.refreshLocation();
    }

    public String getText() {
        return this.label.getText();
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
        this.refreshLocation();
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setIconTextGap(int iconTextGap) {
        this.label.setIconTextGap(iconTextGap);
        this.refreshLocation();
    }

    public int getIconTextGap() {
        return this.label.getIconTextGap();
    }

    public void setStyle(BalloonTipStyle style) {
        this.firePropertyChange("style", this.style, style);
        this.style = style;
        this.setBorder(this.style);
        this.refreshLocation();
    }

    public BalloonTipStyle getStyle() {
        return this.style;
    }

    public void setPositioner(BalloonTipPositioner positioner) {
        this.firePropertyChange("positioner", this.positioner, positioner);
        this.positioner = positioner;
        this.positioner.setBalloonTip(this);
        this.refreshLocation();
    }

    public BalloonTipPositioner getPositioner() {
        return this.positioner;
    }

    public void setPadding(int padding) {
        this.label.setBorder(new EmptyBorder(padding, padding, padding, padding));
        this.refreshLocation();
    }

    public int getPadding() {
        return this.label.getBorder().getBorderInsets((Component)this).left;
    }

    public void enableClickToHide(boolean enabled) {
        this.clickToHide = enabled;
    }

    public void enableClickToClose(boolean enabled) {
        this.clickToClose = enabled;
    }

    public void closeBalloon() {
        this.setVisible(false);
        this.attachedComponent.removeComponentListener(this.attachedComponentListener);
        if (this.topLevelContainer != null) {
            this.topLevelContainer.remove(this);
            this.topLevelContainer.removeComponentListener(this.attachedComponentListener);
        }
        this.removeMouseListener(this.clickListener);
    }

    public static void setCloseButtonIcons(Icon normal, Icon pressed, Icon rollover) {
        defaultIcon = normal;
        rolloverIcon = rollover;
        pressedIcon = pressed;
    }

    public void setCloseButtonBorder(int top, int left, int bottom, int right) {
        if (this.closeButton != null) {
            this.closeButton.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
            this.refreshLocation();
        }
    }

    public void setCloseButtonActionListener(ActionListener act) {
        ActionListener[] listeners = this.closeButton.getActionListeners();
        this.closeButton.removeActionListener(listeners[0]);
        this.closeButton.addActionListener(act);
    }

    public JComponent getAttachedComponent() {
        return this.attachedComponent;
    }

    public JLayeredPane getTopLevelContainer() {
        return this.topLevelContainer;
    }

    public void refreshLocation() {
        Point location = SwingUtilities.convertPoint(this.attachedComponent, this.getLocation(), this);
        try {
            this.positioner.determineAndSetLocation(new Rectangle(location.x, location.y, this.attachedComponent.getWidth(), this.attachedComponent.getHeight()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
        super.setVisible(visible);
    }

    private void checkVisibility() {
        if (this.attachedComponent.isShowing() && this.isVisible) {
            this.refreshLocation();
            super.setVisible(true);
        } else {
            super.setVisible(false);
        }
    }

    private void initializePhase1(final JComponent attachedComponent, String text, BalloonTipStyle style, BalloonTipPositioner positioner, boolean useCloseButton) {
        this.attachedComponent = attachedComponent;
        this.style = style;
        this.positioner = positioner;
        this.setBorder(this.style);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.label.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.label.setText(text);
        this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (useCloseButton) {
            this.closeButton = new JButton();
            this.closeButton.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
            this.closeButton.setContentAreaFilled(false);
            this.closeButton.setIcon(defaultIcon);
            this.closeButton.setRolloverIcon(rolloverIcon);
            this.closeButton.setPressedIcon(pressedIcon);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonTip.this.closeBalloon();
                }
            });
            this.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        try {
            this.initializePhase2();
        }
        catch (NullPointerException exc) {
            this.attachedComponentParentListener = new AncestorListener(){

                public void ancestorAdded(AncestorEvent event) {
                    BalloonTip.this.initializePhase2();
                    attachedComponent.removeAncestorListener(BalloonTip.this.attachedComponentParentListener);
                    BalloonTip.this.refreshLocation();
                    BalloonTip.this.repaint();
                }

                public void ancestorMoved(AncestorEvent event) {
                }

                public void ancestorRemoved(AncestorEvent event) {
                }
            };
            attachedComponent.addAncestorListener(this.attachedComponentParentListener);
        }
    }

    private void initializePhase2() {
        Container parent = this.attachedComponent.getParent();
        while (true) {
            if (parent instanceof RootPaneContainer) break;
            if (parent instanceof JTabbedPane) {
                ((JTabbedPane)parent).addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        BalloonTip.this.checkVisibility();
                    }
                });
            }
            parent = parent.getParent();
        }
        this.topLevelContainer = ((RootPaneContainer)((Object)parent)).getLayeredPane();
        this.topLevelContainer.add((Component)this, JLayeredPane.POPUP_LAYER);
        this.attachedComponent.addComponentListener(this.attachedComponentListener);
        this.topLevelContainer.addComponentListener(this.topLevelContainerListener);
        this.addMouseListener(this.clickListener);
        this.positioner.setBalloonTip(this);
        this.refreshLocation();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttachLocation {
        ALIGNED,
        CENTER,
        NORTH,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        SOUTH,
        SOUTHWEST,
        WEST,
        NORTHWEST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        LEFT_ABOVE,
        RIGHT_ABOVE,
        LEFT_BELOW,
        RIGHT_BELOW;

    }
}

