/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.gui;

import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.core.EVOptions;
import de.saring.exerciseviewer.gui.EVContext;
import de.saring.exerciseviewer.gui.EVDocument;
import de.saring.exerciseviewer.gui.EVView;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.swing.JOptionPane;

public class EVMain {
    private static final Logger LOGGER = Logger.getLogger(EVMain.class.getName());
    private EVContext context;
    private EVDocument document;
    private EVView view;

    @Inject
    public EVMain(EVContext context, EVDocument document, EVView view) {
        this.context = context;
        this.document = document;
        this.view = view;
    }

    public void showExercise(String exerciseFilename, EVOptions options, boolean modal) {
        this.document.setOptions(options);
        try {
            this.document.openExerciseFile(exerciseFilename);
        }
        catch (EVException pe) {
            LOGGER.log(Level.SEVERE, "Failed to open exercise file " + exerciseFilename + "!", pe);
            JOptionPane.showMessageDialog(this.context.getMainFrame(), this.context.getResReader().getString("pv.error.read_exercise", new Object[]{exerciseFilename}), this.context.getResReader().getString("common.error", new Object[0]), 0);
            return;
        }
        this.view.initView(this.document);
        this.view.setModal(modal);
        this.view.displayExercise();
        this.context.showDialog(this.view);
    }
}

