/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.gui.panels;

import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.data.ExerciseSample;
import de.saring.exerciseviewer.data.Lap;
import de.saring.exerciseviewer.data.Position;
import de.saring.exerciseviewer.gui.EVContext;
import de.saring.exerciseviewer.gui.panels.BasePanel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.JXMapKit;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.painter.Painter;

public class TrackPanel
extends BasePanel {
    private JXMapKit mapKit;
    private boolean panelWasVisible = false;
    private static final Color COLOR_START = new Color(180, 255, 180);
    private static final Color COLOR_END = new Color(255, 180, 180);
    private static final Color COLOR_LAP = Color.WHITE;
    private static final Color COLOR_TRACK = Color.RED;

    @Inject
    public TrackPanel(EVContext context) {
        super(context);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        JLabel laNoTrackData = new JLabel();
        laNoTrackData.setHorizontalAlignment(0);
        laNoTrackData.setName("pv.track.no_track_data");
        this.add((Component)laNoTrackData, "Center");
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.panelWasVisible) {
            this.displayTrack();
            this.panelWasVisible = true;
        }
        super.setVisible(visible);
    }

    @Override
    public void displayExercise() {
    }

    private void displayTrack() {
        EVExercise exercise = this.getDocument().getExercise();
        if (exercise.getRecordingMode().isLocation()) {
            this.setupMapViewer();
            this.showTrack(exercise);
        }
    }

    private void setupMapViewer() {
        this.mapKit = new JXMapKit();
        this.mapKit.setDefaultProvider(JXMapKit.DefaultProviders.OpenStreetMaps);
        this.removeAll();
        this.add((Component)this.mapKit, "Center");
    }

    private void showTrack(EVExercise exercise) {
        List<GeoPosition> sampleGeoPositions = this.createSampleGeoPositionList(exercise);
        List<GeoPosition> lapGeoPositions = this.createLapGeoPositionList(exercise);
        if (!sampleGeoPositions.isEmpty()) {
            this.setupZoomAndCenterPosition(sampleGeoPositions);
            this.setupTrackPainter(sampleGeoPositions, lapGeoPositions);
        }
    }

    private void setupZoomAndCenterPosition(List<GeoPosition> positions) {
        Rectangle2D gpRectangle = this.createGeoPositionRectangle(positions);
        GeoPosition gpCenter = new GeoPosition(gpRectangle.getCenterX(), gpRectangle.getCenterY());
        this.mapKit.setCenterPosition(gpCenter);
        int mapKitWidth = this.getWidth() - 30;
        int mapKitHeight = this.getHeight() - 30;
        boolean fullTrackVisible = false;
        int currentZoom = 0;
        int maxZoom = this.mapKit.getMainMap().getTileFactory().getInfo().getMaximumZoomLevel();
        while (!fullTrackVisible && currentZoom < maxZoom) {
            this.mapKit.setZoom(++currentZoom);
            Point2D ptTopLeft = this.convertGeoPosToPixelPos(new GeoPosition(gpRectangle.getX(), gpRectangle.getY()));
            Point2D ptBottomRight = this.convertGeoPosToPixelPos(new GeoPosition(gpRectangle.getX() + gpRectangle.getWidth(), gpRectangle.getY() + gpRectangle.getHeight()));
            int trackPixelWidth = Math.abs((int)(ptBottomRight.getX() - ptTopLeft.getX()));
            int trackPixelHeight = Math.abs((int)(ptBottomRight.getY() - ptTopLeft.getY()));
            boolean bl = fullTrackVisible = trackPixelWidth < mapKitWidth && trackPixelHeight < mapKitHeight;
        }
    }

    private Rectangle2D createGeoPositionRectangle(List<GeoPosition> positions) {
        Rectangle2D.Double rect = new Rectangle2D.Double(positions.get(0).getLatitude(), positions.get(0).getLongitude(), 0.0, 0.0);
        for (GeoPosition pos : positions) {
            rect.add(new Point2D.Double(pos.getLatitude(), pos.getLongitude()));
        }
        return rect;
    }

    private void setupTrackPainter(final List<GeoPosition> sampleGeoPositions, final List<GeoPosition> lapGeoPositions) {
        Painter<JXMapViewer> lineOverlay = new Painter<JXMapViewer>(){

            public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
                g = (Graphics2D)g.create();
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle rect = TrackPanel.this.mapKit.getMainMap().getViewportBounds();
                g.translate(-rect.x, -rect.y);
                TrackPanel.this.drawTrackLine(g, sampleGeoPositions);
                int i = 0;
                while (i < lapGeoPositions.size()) {
                    GeoPosition geoPosition = (GeoPosition)lapGeoPositions.get(i);
                    TrackPanel.this.drawWaypoint(g, geoPosition, String.valueOf(i + 1), COLOR_LAP);
                    ++i;
                }
                TrackPanel.this.drawWaypoint(g, (GeoPosition)sampleGeoPositions.get(0), "S", COLOR_START);
                TrackPanel.this.drawWaypoint(g, (GeoPosition)sampleGeoPositions.get(sampleGeoPositions.size() - 1), "E", COLOR_END);
                g.dispose();
            }
        };
        this.mapKit.getMainMap().setOverlayPainter((Painter)lineOverlay);
    }

    private void drawTrackLine(Graphics2D g, List<GeoPosition> geoPositions) {
        g.setColor(COLOR_TRACK);
        g.setStroke(new BasicStroke(2.0f));
        int lastX = -1;
        int lastY = -1;
        for (GeoPosition geoPosition : geoPositions) {
            Point2D pt = this.convertGeoPosToPixelPos(geoPosition);
            if (lastX != -1 && lastY != -1) {
                g.drawLine(lastX, lastY, (int)pt.getX(), (int)pt.getY());
            }
            lastX = (int)pt.getX();
            lastY = (int)pt.getY();
        }
    }

    private void drawWaypoint(Graphics2D g, GeoPosition geoPosition, String text, Color color) {
        Point2D pt = this.convertGeoPosToPixelPos(geoPosition);
        g.setColor(Color.GRAY);
        g.setStroke(new BasicStroke(3.0f));
        g.draw(new Ellipse2D.Double(pt.getX() - 6.0, pt.getY() - 6.0, 12.0, 12.0));
        g.setColor(color);
        g.setStroke(new BasicStroke(3.0f));
        g.draw(new Ellipse2D.Double(pt.getX() - 5.0, pt.getY() - 5.0, 10.0, 10.0));
        float textPosX = (float)(pt.getX() + 11.0);
        float textPosY = (float)pt.getY() + 3.0f;
        g.setFont(new Font("Dialog.bold", 1, 12));
        g.setColor(Color.DARK_GRAY);
        g.drawString(text, textPosX + 1.0f, textPosY + 1.0f);
        g.setColor(color);
        g.drawString(text, textPosX, textPosY);
    }

    private List<GeoPosition> createSampleGeoPositionList(EVExercise exercise) {
        ArrayList<GeoPosition> geoPositions = new ArrayList<GeoPosition>();
        ExerciseSample[] exerciseSampleArray = exercise.getSampleList();
        int n = exerciseSampleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExerciseSample exerciseSample = exerciseSampleArray[n2];
            Position pos = exerciseSample.getPosition();
            if (pos != null) {
                geoPositions.add(new GeoPosition(pos.getLatitude(), pos.getLongitude()));
            }
            ++n2;
        }
        return geoPositions;
    }

    private List<GeoPosition> createLapGeoPositionList(EVExercise exercise) {
        ArrayList<GeoPosition> geoPositions = new ArrayList<GeoPosition>();
        int i = 0;
        while (i < exercise.getLapList().length - 1) {
            Lap lap = exercise.getLapList()[i];
            Position pos = lap.getPositionSplit();
            if (pos != null) {
                geoPositions.add(new GeoPosition(pos.getLatitude(), pos.getLongitude()));
            }
            ++i;
        }
        return geoPositions;
    }

    private Point2D convertGeoPosToPixelPos(GeoPosition geoPosition) {
        return this.mapKit.getMainMap().getTileFactory().geoToPixel(geoPosition, this.mapKit.getMainMap().getZoom());
    }
}

