/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.parser.impl.garminfit;

import com.garmin.fit.LapMesg;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgListener;
import com.garmin.fit.RecordMesg;
import com.garmin.fit.SessionMesg;
import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.data.ExerciseAltitude;
import de.saring.exerciseviewer.data.ExerciseCadence;
import de.saring.exerciseviewer.data.ExerciseSample;
import de.saring.exerciseviewer.data.ExerciseSpeed;
import de.saring.exerciseviewer.data.ExerciseTemperature;
import de.saring.exerciseviewer.data.Lap;
import de.saring.exerciseviewer.data.LapAltitude;
import de.saring.exerciseviewer.data.LapSpeed;
import de.saring.exerciseviewer.data.LapTemperature;
import de.saring.exerciseviewer.data.Position;
import de.saring.exerciseviewer.data.RecordingMode;
import de.saring.exerciseviewer.parser.impl.garminfit.FitLap;
import de.saring.util.unitcalc.ConvertUtils;
import java.util.LinkedList;
import java.util.List;

class FitMessageListener
implements MesgListener {
    private EVExercise exercise = null;
    private List<FitLap> lFitLaps = new LinkedList<FitLap>();
    private List<ExerciseSample> lSamples = new LinkedList<ExerciseSample>();
    private boolean temperatureAvailable = false;

    FitMessageListener() {
    }

    public void onMesg(Mesg mesg) {
        switch (mesg.getNum()) {
            case 18: {
                this.readSessionMessage(new SessionMesg(mesg));
                break;
            }
            case 19: {
                this.readLapMessage(new LapMesg(mesg));
                break;
            }
            case 20: {
                this.readRecordMessage(new RecordMesg(mesg));
            }
        }
    }

    private void readSessionMessage(SessionMesg mesg) {
        this.exercise = new EVExercise();
        this.exercise.setFileType(EVExercise.ExerciseFileType.GARMIN_FIT);
        this.exercise.setDate(mesg.getStartTime().getDate());
        this.exercise.setDuration(Math.round(mesg.getTotalTimerTime().floatValue() * 10.0f));
        this.exercise.setRecordingMode(new RecordingMode());
        if (mesg.getAvgHeartRate() != null) {
            this.exercise.setHeartRateAVG(mesg.getAvgHeartRate());
        }
        if (mesg.getMaxHeartRate() != null) {
            this.exercise.setHeartRateMax(mesg.getMaxHeartRate());
        }
        if (mesg.getTotalCalories() != null) {
            this.exercise.setEnergy(mesg.getTotalCalories());
        }
        if (mesg.getTotalDistance() != null) {
            this.exercise.getRecordingMode().setSpeed(true);
            this.exercise.setSpeed(new ExerciseSpeed());
            this.exercise.getSpeed().setDistance(Math.round(mesg.getTotalDistance().floatValue()));
            this.exercise.getSpeed().setSpeedAVG(ConvertUtils.convertMeterPerSecond2KilometerPerHour((float)mesg.getAvgSpeed().floatValue()));
            this.exercise.getSpeed().setSpeedMax(ConvertUtils.convertMeterPerSecond2KilometerPerHour((float)mesg.getMaxSpeed().floatValue()));
        }
        if (mesg.getStartPositionLat() != null && mesg.getStartPositionLong() != null) {
            this.exercise.getRecordingMode().setLocation(true);
        }
        if (mesg.getTotalAscent() != null) {
            this.exercise.getRecordingMode().setAltitude(true);
            this.exercise.setAltitude(new ExerciseAltitude());
            this.exercise.getAltitude().setAscent(mesg.getTotalAscent());
        }
        if (mesg.getAvgCadence() != null) {
            this.exercise.getRecordingMode().setCadence(true);
            this.exercise.setCadence(new ExerciseCadence());
            this.exercise.getCadence().setCadenceAVG(mesg.getAvgCadence());
            this.exercise.getCadence().setCadenceMax(mesg.getMaxCadence());
        }
    }

    private void readLapMessage(LapMesg mesg) {
        Lap lap = new Lap();
        if (mesg.getAvgHeartRate() != null) {
            lap.setHeartRateAVG(mesg.getAvgHeartRate());
        }
        if (mesg.getMaxHeartRate() != null) {
            lap.setHeartRateMax(mesg.getMaxHeartRate());
        }
        if (mesg.getTotalDistance() != null) {
            lap.setSpeed(new LapSpeed());
            lap.getSpeed().setDistance(Math.round(mesg.getTotalDistance().floatValue()));
            lap.getSpeed().setSpeedAVG(ConvertUtils.convertMeterPerSecond2KilometerPerHour((float)mesg.getAvgSpeed().floatValue()));
        }
        if (mesg.getTotalAscent() != null) {
            lap.setAltitude(new LapAltitude());
            lap.getAltitude().setAscent(mesg.getTotalAscent());
        }
        if (mesg.getEndPositionLat() != null && mesg.getEndPositionLong() != null) {
            lap.setPositionSplit(new Position(ConvertUtils.convertSemicircle2Degree((int)mesg.getEndPositionLat()), ConvertUtils.convertSemicircle2Degree((int)mesg.getEndPositionLong())));
        }
        this.lFitLaps.add(new FitLap(lap, mesg.getTimestamp().getDate()));
    }

    private void readRecordMessage(RecordMesg mesg) {
        ExerciseSample sample = new ExerciseSample();
        this.lSamples.add(sample);
        sample.setTimestamp(mesg.getTimestamp().getDate().getTime());
        if (mesg.getHeartRate() != null) {
            sample.setHeartRate(mesg.getHeartRate());
        }
        if (mesg.getDistance() != null) {
            sample.setDistance(Math.round(mesg.getDistance().floatValue()));
        }
        if (mesg.getSpeed() != null) {
            sample.setSpeed(ConvertUtils.convertMeterPerSecond2KilometerPerHour((float)mesg.getSpeed().floatValue()));
        }
        if (mesg.getAltitude() != null) {
            sample.setAltitude((short)Math.round(mesg.getAltitude().floatValue()));
        }
        if (mesg.getCadence() != null) {
            sample.setCadence(mesg.getCadence());
        }
        if (mesg.getPositionLat() != null && mesg.getPositionLong() != null) {
            sample.setPosition(new Position(ConvertUtils.convertSemicircle2Degree((int)mesg.getPositionLat()), ConvertUtils.convertSemicircle2Degree((int)mesg.getPositionLong())));
        }
        if (mesg.getTemperature() != null) {
            this.temperatureAvailable = true;
            sample.setTemperature(mesg.getTemperature().byteValue());
        }
    }

    public EVExercise getExercise() throws EVException {
        if (this.exercise == null) {
            throw new EVException("The FIT file does not contain any exercise (activity) data...");
        }
        this.storeSamples();
        this.storeLaps();
        this.calculateAltitudeSummary();
        this.calculateTemperatureSummary();
        return this.exercise;
    }

    private void storeSamples() {
        long startTime = this.exercise.getDate().getTime();
        for (ExerciseSample sample : this.lSamples) {
            sample.setTimestamp(sample.getTimestamp() - startTime);
        }
        this.exercise.setSampleList(this.lSamples.toArray(new ExerciseSample[0]));
    }

    private void storeLaps() {
        int lapDistanceSum = 0;
        LinkedList<Lap> lLaps = new LinkedList<Lap>();
        long startTime = this.exercise.getDate().getTime();
        for (FitLap fitLap : this.lFitLaps) {
            Lap lap = fitLap.getLap();
            lLaps.add(lap);
            lap.setTimeSplit((int)((fitLap.getSplitTime().getTime() - startTime) / 100L));
            ExerciseSample sampleAtLapEnd = this.getExerciseSampleForLapEnd(lap);
            lap.setHeartRateSplit(sampleAtLapEnd.getHeartRate());
            if (lap.getSpeed() != null) {
                lap.getSpeed().setDistance(lapDistanceSum += lap.getSpeed().getDistance());
                lap.getSpeed().setSpeedEnd(sampleAtLapEnd.getSpeed());
                lap.getSpeed().setCadence(sampleAtLapEnd.getCadence());
            }
            if (lap.getAltitude() != null) {
                lap.getAltitude().setAltitude(sampleAtLapEnd.getAltitude());
            }
            if (!this.temperatureAvailable) continue;
            lap.setTemperature(new LapTemperature());
            lap.getTemperature().setTemperature(sampleAtLapEnd.getTemperature());
        }
        this.exercise.setLapList(lLaps.toArray(new Lap[0]));
    }

    private ExerciseSample getExerciseSampleForLapEnd(Lap lap) {
        long lapSplitTimestamp = (long)lap.getTimeSplit() * 100L;
        ExerciseSample closestSample = null;
        long closestTimeDistance = Long.MAX_VALUE;
        ExerciseSample[] exerciseSampleArray = this.exercise.getSampleList();
        int n = exerciseSampleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExerciseSample sample = exerciseSampleArray[n2];
            long timeDistance = Math.abs(sample.getTimestamp() - lapSplitTimestamp);
            if (timeDistance < closestTimeDistance) {
                closestTimeDistance = timeDistance;
                closestSample = sample;
            }
            ++n2;
        }
        return closestSample;
    }

    private void calculateAltitudeSummary() {
        if (this.exercise.getRecordingMode().isAltitude() && this.exercise.getSampleList().length > 0) {
            short altMin = Short.MAX_VALUE;
            short altMax = Short.MIN_VALUE;
            int altitudeSum = 0;
            ExerciseSample[] exerciseSampleArray = this.exercise.getSampleList();
            int n = exerciseSampleArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExerciseSample sample = exerciseSampleArray[n2];
                altMin = (short)Math.min(sample.getAltitude(), altMin);
                altMax = (short)Math.max(sample.getAltitude(), altMax);
                altitudeSum += sample.getAltitude();
                ++n2;
            }
            this.exercise.getAltitude().setAltitudeMin(altMin);
            this.exercise.getAltitude().setAltitudeMax(altMax);
            this.exercise.getAltitude().setAltitudeAVG((short)Math.round((double)altitudeSum / (double)this.exercise.getSampleList().length));
        }
    }

    private void calculateTemperatureSummary() {
        if (this.temperatureAvailable) {
            this.exercise.getRecordingMode().setTemperature(true);
            this.exercise.setTemperature(new ExerciseTemperature());
            short tempMin = Short.MAX_VALUE;
            short tempMax = Short.MIN_VALUE;
            int temperatureSum = 0;
            ExerciseSample[] exerciseSampleArray = this.exercise.getSampleList();
            int n = exerciseSampleArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExerciseSample sample = exerciseSampleArray[n2];
                tempMin = (short)Math.min(sample.getTemperature(), tempMin);
                tempMax = (short)Math.max(sample.getTemperature(), tempMax);
                temperatureSum += sample.getTemperature();
                ++n2;
            }
            this.exercise.getTemperature().setTemperatureMin(tempMin);
            this.exercise.getTemperature().setTemperatureMax(tempMax);
            this.exercise.getTemperature().setTemperatureAVG((short)Math.round((double)temperatureSum / (double)this.exercise.getSampleList().length));
        }
    }
}

