/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui;

import de.saring.sportstracker.gui.STContext;
import de.saring.util.ResourceReader;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.Component;
import javax.inject.Singleton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.SingleFrameApplication;

@Singleton
public class STContextImpl
implements STContext {
    private ApplicationContext appContext;
    private ResourceReader resReader;
    private FormatUtils formatUtils;

    public STContextImpl(ApplicationContext appContext) {
        this.appContext = appContext;
        this.resReader = new ResourceReader(appContext.getResourceMap());
    }

    @Override
    public ApplicationContext getSAFContext() {
        return this.appContext;
    }

    @Override
    public JFrame getMainFrame() {
        return this.getApplication().getMainFrame();
    }

    @Override
    public void showDialog(JDialog dlg) {
        this.getApplication().show(dlg);
    }

    @Override
    public void showMessageDialog(Component parent, int msgType, String titleKey, String messageKey, Object ... arguments) {
        JOptionPane.showMessageDialog(parent, this.resReader.getString(messageKey, arguments), this.resReader.getString(titleKey, new Object[0]), msgType);
    }

    @Override
    public int showConfirmDialog(Component parent, String titleKey, String messageKey) {
        return JOptionPane.showConfirmDialog(parent, this.resReader.getString(messageKey, new Object[0]), this.resReader.getString(titleKey, new Object[0]), 0);
    }

    @Override
    public ResourceReader getResReader() {
        return this.resReader;
    }

    @Override
    public FormatUtils getFormatUtils() {
        return this.formatUtils;
    }

    @Override
    public void setFormatUtils(FormatUtils formatUtils) {
        this.formatUtils = formatUtils;
    }

    private SingleFrameApplication getApplication() {
        return (SingleFrameApplication)this.appContext.getApplication();
    }
}

