/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.dialogs;

import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.SportType;
import de.saring.sportstracker.data.SportTypeList;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STDocument;
import de.saring.sportstracker.gui.dialogs.SportTypeDialog;
import de.saring.util.gui.DialogUtils;
import de.saring.util.gui.ListCellRendererOddEven;
import de.saring.util.gui.ListUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;

public class SportTypeListDialog
extends JDialog {
    private static final String ACTION_ADD = "st.dlg.sporttype_list.add";
    private static final String ACTION_EDIT = "st.dlg.sporttype_list.edit";
    private static final String ACTION_DELETE = "st.dlg.sporttype_list.delete";
    private static final String ACTION_CLOSE = "st.dlg.sporttype_list.close";
    private static final String PROPERTY_SPORTTYPE_SELECTED = "sportTypeSelected";
    private STContext context;
    private STDocument document;
    @Inject
    private Provider<SportTypeDialog> prSportTypeDialog;
    private JButton btAdd;
    private JButton btClose;
    private JButton btDelete;
    private JButton btEdit;
    private JList liSportTypes;
    private JSeparator separator;
    private JScrollPane spSportTypes;

    @Inject
    public SportTypeListDialog(STContext context, STDocument document) {
        super((Frame)context.getMainFrame(), true);
        this.context = context;
        this.document = document;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.btClose);
        this.liSportTypes.setCellRenderer(new SportTypeCellRenderer());
        ListUtils.increaseListCellHeight(this.liSportTypes);
        ApplicationActionMap actionMap = context.getSAFContext().getActionMap(this.getClass(), this);
        this.btAdd.setAction(actionMap.get(ACTION_ADD));
        this.btEdit.setAction(actionMap.get(ACTION_EDIT));
        this.btDelete.setAction(actionMap.get(ACTION_DELETE));
        javax.swing.Action aClose = actionMap.get(ACTION_CLOSE);
        this.btClose.setAction(aClose);
        DialogUtils.setDialogEscapeKeyAction(this, aClose);
        this.liSportTypes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SportTypeListDialog.this.firePropertyChange(SportTypeListDialog.PROPERTY_SPORTTYPE_SELECTED, true, false);
            }
        });
        this.liSportTypes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SportTypeListDialog.this.liSportTypes.getSelectedIndex() != -1) {
                    SportTypeListDialog.this.editSportType();
                }
            }
        });
        this.updateSportTypeList();
    }

    private void updateSportTypeList() {
        SportTypeList sportTypes = this.document.getSportTypeList();
        String[] sportTypeNames = new String[sportTypes.size()];
        int i = 0;
        while (i < sportTypeNames.length) {
            sportTypeNames[i] = ((SportType)sportTypes.getAt(i)).getName();
            ++i;
        }
        this.liSportTypes.setListData(sportTypeNames);
    }

    @Action(name="st.dlg.sporttype_list.add")
    public void addSportType() {
        SportType newSportType = new SportType(this.document.getSportTypeList().getNewID());
        SportTypeDialog dlg = this.prSportTypeDialog.get();
        dlg.setSportType(newSportType);
        this.context.showDialog(dlg);
        this.updateSportTypeList();
    }

    @Action(name="st.dlg.sporttype_list.edit", enabledProperty="sportTypeSelected")
    public void editSportType() {
        int selectedIndex = this.liSportTypes.getSelectedIndex();
        SportType sportType = (SportType)this.document.getSportTypeList().getAt(selectedIndex);
        SportTypeDialog dlg = this.prSportTypeDialog.get();
        dlg.setSportType(sportType);
        this.context.showDialog(dlg);
        this.updateSportTypeList();
    }

    @Action(name="st.dlg.sporttype_list.delete", enabledProperty="sportTypeSelected")
    public void deleteSportType() {
        if (this.context.showConfirmDialog(this, "st.dlg.sporttype_list.confirm.delete.title", "st.dlg.sporttype_list.confirm.delete.text") != 0) {
            return;
        }
        int selectedIndex = this.liSportTypes.getSelectedIndex();
        SportType sportType = (SportType)this.document.getSportTypeList().getAt(selectedIndex);
        ArrayList<Integer> lRefExerciseIDs = new ArrayList<Integer>();
        for (Exercise exercise : this.document.getExerciseList()) {
            if (exercise.getSportType().getId() != sportType.getId()) continue;
            lRefExerciseIDs.add(exercise.getId());
        }
        if (lRefExerciseIDs.size() > 0) {
            if (this.context.showConfirmDialog(this, "st.dlg.sporttype_list.confirm.delete.title", "st.dlg.sporttype_list.confirm.delete_existing.text") != 0) {
                return;
            }
            Iterator<Object> iterator = lRefExerciseIDs.iterator();
            while (iterator.hasNext()) {
                int refExerciseID = (Integer)iterator.next();
                this.document.getExerciseList().removeByID(refExerciseID);
            }
        }
        this.document.getSportTypeList().removeByID(sportType.getId());
        this.updateSportTypeList();
    }

    @Action(name="st.dlg.sporttype_list.close")
    public void close() {
        this.dispose();
    }

    public boolean isSportTypeSelected() {
        return !this.liSportTypes.isSelectionEmpty();
    }

    private void initComponents() {
        this.btClose = new JButton();
        this.separator = new JSeparator();
        this.spSportTypes = new JScrollPane();
        this.liSportTypes = new JList();
        this.btAdd = new JButton();
        this.btEdit = new JButton();
        this.btDelete = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("_Edit Sport Type List");
        this.setModal(true);
        this.setName("st.dlg.sporttype_list");
        this.setResizable(false);
        this.btClose.setText("_Close");
        this.spSportTypes.setVerticalScrollBarPolicy(22);
        this.liSportTypes.setSelectionMode(0);
        this.spSportTypes.setViewportView(this.liSportTypes);
        this.btAdd.setText("_Add");
        this.btEdit.setText("_Edit");
        this.btDelete.setText("_Delete");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.spSportTypes, -1, 298, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btAdd).addComponent(this.btEdit).addComponent(this.btDelete)).addContainerGap()).addComponent(this.separator, GroupLayout.Alignment.TRAILING, -1, 395, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(329, Short.MAX_VALUE).addComponent(this.btClose).addContainerGap()));
        layout.linkSize(0, this.btAdd, this.btDelete, this.btEdit);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btDelete)).addComponent(this.spSportTypes, -1, 211, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.separator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btClose).addContainerGap()));
        this.pack();
    }

    class SportTypeCellRenderer
    extends ListCellRendererOddEven {
        public SportTypeCellRenderer() {
            super(SportTypeListDialog.this.context.getResReader().getColor("common.table.background_odd"), SportTypeListDialog.this.context.getResReader().getColor("common.table.background_even"));
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (SportTypeListDialog.this.document.getSportTypeList().size() > 0) {
                SportType sportType = (SportType)SportTypeListDialog.this.document.getSportTypeList().getAt(index);
                component.setForeground(sportType.getColor());
            }
            return component;
        }
    }
}

