/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.unitcalc;

import de.saring.util.unitcalc.ConvertUtils;
import java.text.NumberFormat;

public class FormatUtils {
    private UnitSystem unitSystem;
    private SpeedView speedView;
    private NumberFormat numberFormat;

    public FormatUtils(UnitSystem unitSystem, SpeedView speedView) {
        this.unitSystem = unitSystem;
        this.speedView = speedView;
        this.numberFormat = NumberFormat.getInstance();
    }

    public UnitSystem getUnitSystem() {
        return this.unitSystem;
    }

    public SpeedView getSpeedView() {
        return this.speedView;
    }

    public String getDistanceUnitName() {
        switch (this.unitSystem) {
            case English: {
                return "m";
            }
        }
        return "km";
    }

    public String getSpeedUnitName() {
        switch (this.unitSystem) {
            case English: {
                switch (this.speedView) {
                    case MinutesPerDistance: {
                        return "min/m";
                    }
                }
                return "mph";
            }
        }
        switch (this.speedView) {
            case MinutesPerDistance: {
                return "min/km";
            }
        }
        return "km/h";
    }

    public String getTemperatureUnitName() {
        switch (this.unitSystem) {
            case English: {
                return "F";
            }
        }
        return "C";
    }

    public String getAltitudeUnitName() {
        switch (this.unitSystem) {
            case English: {
                return "ft";
            }
        }
        return "m";
    }

    public String getWeightUnitName() {
        switch (this.unitSystem) {
            case English: {
                return "lbs";
            }
        }
        return "kg";
    }

    public String minutes2TimeString(int minutes) {
        int hourPart = minutes / 60;
        int minutePart = minutes % 60;
        StringBuilder sBuilder = new StringBuilder();
        if (hourPart < 10) {
            sBuilder.append("0");
        }
        sBuilder.append(hourPart);
        sBuilder.append(":");
        if (minutePart < 10) {
            sBuilder.append("0");
        }
        sBuilder.append(minutePart);
        return sBuilder.toString();
    }

    public String seconds2TimeString(int seconds) {
        int secondPart = seconds % 60;
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(this.minutes2TimeString(seconds / 60));
        sBuilder.append(":");
        if (secondPart < 10) {
            sBuilder.append("0");
        }
        sBuilder.append(secondPart);
        return sBuilder.toString();
    }

    public String seconds2MinuteTimeString(int seconds) {
        int secondPart = seconds % 60;
        int minutePart = seconds / 60;
        StringBuilder stringBuilder = new StringBuilder();
        if (minutePart < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(minutePart);
        stringBuilder.append(":");
        if (secondPart < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(secondPart);
        return stringBuilder.toString();
    }

    public String tenthSeconds2TimeString(int tenthSeconds) {
        int tenthSecondPart = tenthSeconds % 10;
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(this.seconds2TimeString(tenthSeconds / 10));
        sBuilder.append(".");
        sBuilder.append(tenthSecondPart);
        return sBuilder.toString();
    }

    public int timeString2TotalSeconds(String time) {
        if (time == null || time.length() == 0) {
            return -1;
        }
        String[] timeSplitted = time.split(":");
        if (timeSplitted.length == 0 || timeSplitted.length > 3) {
            return -1;
        }
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        try {
            seconds = Integer.parseInt(timeSplitted[timeSplitted.length - 1]);
            if (timeSplitted.length >= 2) {
                minutes = Integer.parseInt(timeSplitted[timeSplitted.length - 2]);
            }
            if (timeSplitted.length >= 3) {
                hours = Integer.parseInt(timeSplitted[timeSplitted.length - 3]);
            }
        }
        catch (Exception exception) {
            return -1;
        }
        if (seconds < 0 || seconds > 59 || minutes < 0 || minutes > 59 || hours < 0) {
            return -1;
        }
        return hours * 60 * 60 + minutes * 60 + seconds;
    }

    public String heartRateToString(int heartRate) {
        this.numberFormat.setMaximumFractionDigits(0);
        return String.valueOf(this.numberFormat.format(heartRate)) + " bpm";
    }

    public String temperatureToString(short temperature) {
        this.numberFormat.setMaximumFractionDigits(0);
        switch (this.unitSystem) {
            case English: {
                return String.valueOf(this.numberFormat.format(ConvertUtils.convertCelsius2Fahrenheit(temperature))) + " " + this.getTemperatureUnitName();
            }
        }
        return String.valueOf(this.numberFormat.format(temperature)) + " " + this.getTemperatureUnitName();
    }

    public String distanceToStringWithoutUnitName(double distance, int decimals) {
        this.numberFormat.setMaximumFractionDigits(decimals);
        switch (this.unitSystem) {
            case English: {
                return this.numberFormat.format(ConvertUtils.convertKilometer2Miles(distance, false));
            }
        }
        return this.numberFormat.format(distance);
    }

    public String distanceToString(double distance, int decimals) {
        return String.valueOf(this.distanceToStringWithoutUnitName(distance, decimals)) + " " + this.getDistanceUnitName();
    }

    public String speedToStringWithoutUnitName(float speed, int decimals) {
        this.numberFormat.setMaximumFractionDigits(decimals);
        switch (this.unitSystem) {
            case English: {
                switch (this.speedView) {
                    case MinutesPerDistance: {
                        if (speed == 0.0f) {
                            return "N/A";
                        }
                        return this.seconds2MinuteTimeString((int)(3600.0 / ConvertUtils.convertKilometer2Miles(speed, false)));
                    }
                }
                return this.numberFormat.format(ConvertUtils.convertKilometer2Miles(speed, false));
            }
        }
        switch (this.speedView) {
            case MinutesPerDistance: {
                if (speed == 0.0f) {
                    return "N/A";
                }
                return this.seconds2MinuteTimeString((int)(3600.0f / speed));
            }
        }
        return this.numberFormat.format(speed);
    }

    public String speedToString(float speed, int decimals) {
        if (speed == 0.0f) {
            return this.speedToStringWithoutUnitName(speed, decimals);
        }
        return String.valueOf(this.speedToStringWithoutUnitName(speed, decimals)) + " " + this.getSpeedUnitName();
    }

    public String heightToStringWithoutUnitName(int height) {
        this.numberFormat.setMaximumFractionDigits(0);
        switch (this.unitSystem) {
            case English: {
                return this.numberFormat.format(ConvertUtils.convertMeter2Feet(height));
            }
        }
        return this.numberFormat.format(height);
    }

    public String heightToString(int height) {
        return String.valueOf(this.heightToStringWithoutUnitName(height)) + " " + this.getAltitudeUnitName();
    }

    public String cadenceToString(int cadence) {
        this.numberFormat.setMaximumFractionDigits(0);
        return String.valueOf(this.numberFormat.format(cadence)) + " rpm";
    }

    public String caloriesToString(int calories) {
        this.numberFormat.setMaximumFractionDigits(0);
        return String.valueOf(this.numberFormat.format(calories)) + " kCal";
    }

    public String weightToStringWithoutUnitName(float weight, int maxFractionDigits) {
        this.numberFormat.setMaximumFractionDigits(maxFractionDigits);
        switch (this.unitSystem) {
            case English: {
                return this.numberFormat.format(ConvertUtils.convertKilogram2Lbs(weight));
            }
        }
        return this.numberFormat.format(weight);
    }

    public String weightToString(float weight, int maxFractionDigits) {
        return String.valueOf(this.weightToStringWithoutUnitName(weight, maxFractionDigits)) + " " + this.getWeightUnitName();
    }

    public String firstLineOfText(String text) {
        if (text == null) {
            return null;
        }
        int firstNewLineIndex = text.indexOf(10);
        if (firstNewLineIndex >= 0) {
            return text.substring(0, firstNewLineIndex);
        }
        return text;
    }

    public static enum SpeedView {
        DistancePerHour,
        MinutesPerDistance;

    }

    public static enum UnitSystem {
        Metric,
        English;

    }
}

