/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core;

import devplugin.Marker;
import devplugin.Program;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class PendingMarkings {
    private static Map<Program, ArrayList<Marker>> PENDING_MAP = Collections.synchronizedMap(new ProgramMap());
    private static boolean USE_PENDING = true;

    public static synchronized void addMarker(Program p, Marker marker) {
        if (p != null) {
            if (USE_PENDING) {
                ArrayList<Marker> list = PENDING_MAP.get(p);
                if (list == null) {
                    list = new ArrayList();
                    PENDING_MAP.put(p, list);
                }
                if (!list.contains(marker)) {
                    list.add(marker);
                }
            } else {
                p.mark(marker);
            }
        }
    }

    public static synchronized void markMapEntries() {
        USE_PENDING = false;
        for (Program p : PENDING_MAP.keySet()) {
            ArrayList<Marker> list = PENDING_MAP.get(p);
            if (list == null) continue;
            for (Marker marker : list) {
                p.mark(marker);
            }
        }
        PENDING_MAP.clear();
    }

    public static boolean usePending() {
        return USE_PENDING;
    }

    private static final class ProgramMap
    extends HashMap<Program, ArrayList<Marker>> {
        private ProgramMap() {
        }

        @Override
        public ArrayList<Marker> get(Object key) {
            ArrayList list = (ArrayList)super.get(key);
            if (list == null && !this.isEmpty()) {
                String test = null;
                if (key instanceof Program) {
                    test = ((Program)key).getID();
                } else if (key instanceof String) {
                    test = (String)key;
                }
                if (test != null) {
                    for (Program p : this.keySet()) {
                        if (!p.getID().equals(test)) continue;
                        list = (ArrayList)super.get(p);
                        break;
                    }
                }
            }
            return list;
        }
    }
}

