/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Channel;
import devplugin.Program;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.JPanel;
import tvbrowser.core.ChannelList;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.ui.Localizer;
import util.ui.OrderChooser;

public class ChannelFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ChannelFilterComponent.class);
    private OrderChooser mList;
    private Channel[] mSelectedChannels = new Channel[0];
    private ArrayList<String> mSelectedChannelsIdList = new ArrayList(0);

    public ChannelFilterComponent(String name, String desc) {
        super(name, desc);
    }

    public ChannelFilterComponent() {
        this("", "");
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        Channel ch;
        int i;
        ArrayList<Channel> channels = new ArrayList<Channel>();
        int channelCnt = in.readInt();
        for (i = 0; i < channelCnt; ++i) {
            if (version < 3) {
                String channelId;
                Channel ch2;
                String dataServiceClassName = (String)in.readObject();
                String groupId = null;
                if (version >= 2) {
                    groupId = (String)in.readObject();
                }
                if ((ch2 = Channel.getChannel(dataServiceClassName, groupId, null, channelId = (String)in.readObject())) == null) continue;
                channels.add(ch2);
                continue;
            }
            if (version < 4) {
                ch = Channel.readData(in, true);
                if (ch == null) continue;
                channels.add(ch);
                this.mSelectedChannelsIdList.add(ch.getUniqueId());
                continue;
            }
            this.mSelectedChannelsIdList.add(in.readUTF());
        }
        if (version >= 4) {
            channelCnt = in.readInt();
            for (i = 0; i < channelCnt; ++i) {
                ch = Channel.readData(in, true);
                if (ch == null) continue;
                channels.add(ch);
            }
        }
        this.mSelectedChannels = new Channel[channels.size()];
        channels.toArray(this.mSelectedChannels);
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.mSelectedChannelsIdList.size());
        for (String id : this.mSelectedChannelsIdList) {
            out.writeUTF(id);
        }
        out.writeInt(this.mSelectedChannels.length);
        for (Channel selectedChannel : this.mSelectedChannels) {
            selectedChannel.writeData(out);
        }
    }

    public String toString() {
        return Localizer.getLocalization("i18n_channel");
    }

    @Override
    public void saveSettings() {
        Object[] o = this.mList.getOrder();
        this.mSelectedChannels = new Channel[o.length];
        this.mSelectedChannelsIdList.clear();
        for (int i = 0; i < o.length; ++i) {
            this.mSelectedChannels[i] = (Channel)o[i];
            this.mSelectedChannelsIdList.add(this.mSelectedChannels[i].getUniqueId());
        }
    }

    @Override
    public String getTypeDescription() {
        return mLocalizer.msg("description", "This filter accepts programs belonging to the following channels:");
    }

    @Override
    public JPanel getSettingsPanel() {
        JPanel content = new JPanel(new FormLayout("50dlu:grow", "fill:default:grow"));
        Object[] channels = ChannelList.getSubscribedChannels(false);
        this.mList = new OrderChooser(this.mSelectedChannels, channels);
        this.mList.getUpButton().setVisible(false);
        this.mList.getDownButton().setVisible(false);
        content.add((Component)this.mList, CC.xy(1, 1));
        return content;
    }

    @Override
    public boolean accept(Program program) {
        for (Channel selectedChannel : this.mSelectedChannels) {
            if (!selectedChannel.equals(program.getChannel())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getVersion() {
        return 4;
    }

    public Channel[] getChannels() {
        return this.mSelectedChannels;
    }

    public void updateAvailableChannels(Channel[] channels) {
        ArrayList<Channel> selectedAvailable = new ArrayList<Channel>();
        for (Channel ch : channels) {
            if (!this.mSelectedChannelsIdList.contains(ch.getUniqueId())) continue;
            selectedAvailable.add(ch);
        }
        this.mSelectedChannels = selectedAvailable.toArray(new Channel[selectedAvailable.size()]);
    }

    public boolean isBrokenPartially() {
        return this.mSelectedChannels.length != this.mSelectedChannelsIdList.size() || this.isBrokenCompletely();
    }

    public boolean isBrokenCompletely() {
        return this.mSelectedChannels.length == 0;
    }
}

