/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.ui.Localizer;

public class ProgramLengthFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramLengthFilterComponent.class);
    private int mMin = 5;
    private int mMax = 90;
    private boolean mUseMin = true;
    private boolean mUseMax = true;
    private JSpinner mMinSpinner;
    private JSpinner mMaxSpinner;
    private JCheckBox mMinCheck;
    private JCheckBox mMaxCheck;

    public ProgramLengthFilterComponent() {
        this("", "");
    }

    public ProgramLengthFilterComponent(String name, String description) {
        super(name, description);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean accept(Program program) {
        int length = program.getLength();
        if (length < 0) {
            return true;
        }
        if (this.mUseMin && length < this.mMin) {
            return false;
        }
        return !this.mUseMax || length <= this.mMax;
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        this.mUseMin = in.readBoolean();
        this.mUseMax = in.readBoolean();
        this.mMin = in.readInt();
        this.mMax = in.readInt();
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.mUseMin);
        out.writeBoolean(this.mUseMax);
        out.writeInt(this.mMin);
        out.writeInt(this.mMax);
    }

    @Override
    public JPanel getSettingsPanel() {
        JPanel panel = new JPanel();
        this.mMin = Math.min(1000, Math.max(0, this.mMin));
        this.mMax = Math.min(1000, Math.max(1, this.mMax));
        this.mMinSpinner = new JSpinner(new SpinnerNumberModel(this.mMin, 0, 1000, 1));
        this.mMaxSpinner = new JSpinner(new SpinnerNumberModel(this.mMax, 1, 1000, 1));
        this.mMinCheck = new JCheckBox(mLocalizer.msg("minimum", "minimum in Minutes") + ":", this.mUseMin);
        this.mMaxCheck = new JCheckBox(mLocalizer.msg("maximum", "maximum in Minutes") + ":", this.mUseMax);
        if (!this.mUseMin) {
            this.mMinSpinner.setEnabled(false);
        }
        if (!this.mUseMax) {
            this.mMaxSpinner.setEnabled(false);
        }
        this.mMinCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramLengthFilterComponent.this.mMinSpinner.setEnabled(ProgramLengthFilterComponent.this.mMinCheck.isSelected());
            }
        });
        this.mMaxCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramLengthFilterComponent.this.mMaxSpinner.setEnabled(ProgramLengthFilterComponent.this.mMaxCheck.isSelected());
            }
        });
        panel.setLayout(new GridBagLayout());
        GridBagConstraints a = new GridBagConstraints();
        a.gridwidth = 0;
        a.fill = 0;
        GridBagConstraints b = new GridBagConstraints();
        b.fill = 0;
        this.mMinSpinner.setEditor(new JSpinner.NumberEditor(this.mMinSpinner, "###0"));
        this.mMaxSpinner.setEditor(new JSpinner.NumberEditor(this.mMaxSpinner, "###0"));
        panel.add((Component)this.mMinCheck, b);
        panel.add((Component)this.mMinSpinner, a);
        panel.add((Component)this.mMaxCheck, b);
        panel.add((Component)this.mMaxSpinner, a);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)panel, "North");
        return centerPanel;
    }

    @Override
    public void saveSettings() {
        this.mMin = (Integer)this.mMinSpinner.getValue();
        this.mMax = (Integer)this.mMaxSpinner.getValue();
        this.mUseMin = this.mMinCheck.isSelected();
        this.mUseMax = this.mMaxCheck.isSelected();
    }

    public String toString() {
        return mLocalizer.msg("ProgrammLength", "Program length");
    }
}

