/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.icontheme;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import tvbrowser.core.icontheme.InfoThemeLoader;

public class InfoIconTheme
implements Comparable<InfoIconTheme> {
    public static byte INFO_16_9 = 0;
    public static byte INFO_ARTS = 1;
    public static byte INFO_AUDIO_DESCRIPTION = (byte)2;
    public static byte INFO_BLACK_AND_WHITE = (byte)3;
    public static byte INFO_CHILDREN = (byte)4;
    public static byte INFO_DOCU = (byte)5;
    public static byte INFO_DOLBY_DIGITAL_5_1 = (byte)6;
    public static byte INFO_DOLBY_SOURROUND = (byte)7;
    public static byte INFO_HAS_PICTURE = (byte)8;
    public static byte INFO_HD = (byte)9;
    public static byte INFO_INFOTAINMENT = (byte)10;
    public static byte INFO_LIVE = (byte)11;
    public static byte INFO_MONO = (byte)12;
    public static byte INFO_MOVIE = (byte)13;
    public static byte INFO_NEW = (byte)14;
    public static byte INFO_NEWS = (byte)15;
    public static byte INFO_ORIGINAL_WITH_SUBTITLE = (byte)16;
    public static byte INFO_SERIES = (byte)17;
    public static byte INFO_SHOW = (byte)18;
    public static byte INFO_SIGN_LANGUGAGE = (byte)19;
    public static byte INFO_SPORTS = (byte)20;
    public static byte INFO_STEREO = (byte)21;
    public static byte INFO_SUBTITLE_FOR_AURALLY_HANDICAPPED = (byte)22;
    public static byte INFO_TWO_CHANNEL_TONE = (byte)23;
    public static byte INFO_4_3 = (byte)24;
    public static byte INFO_OTHERS = (byte)25;
    private HashMap<Byte, ImageIcon> mIconMap;
    private String mID;
    private String mName;
    private File mDirOrZip;
    private Icon[] mInfoIconArr;
    private String[] mInfoIconURLs;

    public InfoIconTheme(File dirOrZip) {
        this.mDirOrZip = dirOrZip;
        this.mID = dirOrZip.getName();
        this.mIconMap = new HashMap();
        this.loadName(dirOrZip);
    }

    private void loadName(File dirOrZip) {
        if (this.mDirOrZip.isDirectory()) {
            File name = new File(this.mDirOrZip, "name_" + Locale.getDefault().getLanguage());
            if (name.isFile()) {
                try {
                    this.readName(new FileInputStream(name));
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
            }
            if (this.mName == null) {
                name = new File(this.mDirOrZip, "name");
                try {
                    this.readName(new FileInputStream(name));
                }
                catch (FileNotFoundException e) {}
            }
        } else if (this.mDirOrZip.isFile() && this.mDirOrZip.getName().toLowerCase().endsWith(".zip")) {
            try {
                ZipFile iconFile = new ZipFile(dirOrZip);
                ZipEntry name = iconFile.getEntry("name_" + Locale.getDefault().getLanguage());
                if (name != null) {
                    try {
                        this.readName(iconFile.getInputStream(name));
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                }
                if (this.mName == null) {
                    name = iconFile.getEntry("name");
                    try {
                        this.readName(iconFile.getInputStream(name));
                    }
                    catch (IOException e) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void readName(InputStream in) {
        try {
            BufferedReader read = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            this.mName = read.readLine();
            read.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void loadIcons() {
        if (this.mIconMap.isEmpty()) {
            if (this.mDirOrZip.isDirectory()) {
                this.loadIconsFromDirectory(this.mDirOrZip);
            } else if (this.mDirOrZip.isFile() && this.mDirOrZip.getName().toLowerCase().endsWith(".zip")) {
                this.loadIconsFromZipFile(this.mDirOrZip);
            }
        }
    }

    private void loadIconsFromDirectory(File dir2) {
        File[] files;
        for (File icon : files = dir2.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                return name.startsWith("Info_");
            }
        })) {
            try {
                URL url = icon.toURI().toURL();
                this.mapIcon(new ImageIcon(url), icon.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadIconsFromZipFile(File zip) {
        try {
            ZipFile iconFile = new ZipFile(zip);
            Enumeration<? extends ZipEntry> entries = iconFile.entries();
            String zipURL = zip.toURI().toURL().toString();
            while (entries.hasMoreElements()) {
                ZipEntry iconEntry = entries.nextElement();
                if (!iconEntry.getName().startsWith("Info_")) continue;
                try {
                    URL url = new URL("jar:" + zipURL + "!/" + URLEncoder.encode(iconEntry.getName(), "UTF-8"));
                    this.mapIcon(new ImageIcon(url), iconEntry.getName());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ZipException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void mapIcon(ImageIcon icon, String name) {
        if (name.startsWith("Info_16to9")) {
            this.mIconMap.put(INFO_16_9, icon);
        } else if (name.startsWith("Info_Arts")) {
            this.mIconMap.put(INFO_ARTS, icon);
        } else if (name.startsWith("Info_AudioDescription")) {
            this.mIconMap.put(INFO_AUDIO_DESCRIPTION, icon);
        } else if (name.startsWith("Info_BlackAndWhite")) {
            this.mIconMap.put(INFO_BLACK_AND_WHITE, icon);
        } else if (name.startsWith("Info_Children")) {
            this.mIconMap.put(INFO_CHILDREN, icon);
        } else if (name.startsWith("Info_Docu")) {
            this.mIconMap.put(INFO_DOCU, icon);
        } else if (name.startsWith("Info_DolbyDigital51")) {
            this.mIconMap.put(INFO_DOLBY_DIGITAL_5_1, icon);
        } else if (name.startsWith("Info_DolbySurround")) {
            this.mIconMap.put(INFO_DOLBY_SOURROUND, icon);
        } else if (name.startsWith("Info_HasPicture")) {
            this.mIconMap.put(INFO_HAS_PICTURE, icon);
        } else if (name.startsWith("Info_HD")) {
            this.mIconMap.put(INFO_HD, icon);
        } else if (name.startsWith("Info_Infotainment")) {
            this.mIconMap.put(INFO_INFOTAINMENT, icon);
        } else if (name.startsWith("Info_Live")) {
            this.mIconMap.put(INFO_LIVE, icon);
        } else if (name.startsWith("Info_Mono")) {
            this.mIconMap.put(INFO_MONO, icon);
        } else if (name.startsWith("Info_Movie")) {
            this.mIconMap.put(INFO_MOVIE, icon);
        } else if (name.startsWith("Info_News")) {
            this.mIconMap.put(INFO_NEWS, icon);
        } else if (name.startsWith("Info_New")) {
            this.mIconMap.put(INFO_NEW, icon);
        } else if (name.startsWith("Info_OriginalWithSubtitle_EN")) {
            if (Locale.getDefault().getLanguage().equals("en")) {
                this.mIconMap.put(INFO_ORIGINAL_WITH_SUBTITLE, icon);
            }
        } else if (name.startsWith("Info_OriginalWithSubtitle")) {
            if (this.mIconMap.get(INFO_ORIGINAL_WITH_SUBTITLE) == null) {
                this.mIconMap.put(INFO_ORIGINAL_WITH_SUBTITLE, icon);
            }
        } else if (name.startsWith("Info_Series")) {
            this.mIconMap.put(INFO_SERIES, icon);
        } else if (name.startsWith("Info_Show")) {
            this.mIconMap.put(INFO_SHOW, icon);
        } else if (name.startsWith("Info_Signlanguage")) {
            this.mIconMap.put(INFO_SIGN_LANGUGAGE, icon);
        } else if (name.startsWith("Info_Sports")) {
            this.mIconMap.put(INFO_SPORTS, icon);
        } else if (name.startsWith("Info_Stereo")) {
            this.mIconMap.put(INFO_STEREO, icon);
        } else if (name.startsWith("Info_SubtitleForAurallyHandicapped_DK")) {
            if (Locale.getDefault().getCountry().equalsIgnoreCase("dk")) {
                this.mIconMap.put(INFO_SUBTITLE_FOR_AURALLY_HANDICAPPED, icon);
            }
        } else if (name.startsWith("Info_SubtitleForAurallyHandicapped_US")) {
            if (Locale.getDefault().getCountry().equalsIgnoreCase("us")) {
                this.mIconMap.put(INFO_SUBTITLE_FOR_AURALLY_HANDICAPPED, icon);
            }
        } else if (name.startsWith("Info_SubtitleForAurallyHandicapped")) {
            if (this.mIconMap.get(INFO_SUBTITLE_FOR_AURALLY_HANDICAPPED) == null) {
                this.mIconMap.put(INFO_SUBTITLE_FOR_AURALLY_HANDICAPPED, icon);
            }
        } else if (name.startsWith("Info_TwoChannelTone")) {
            this.mIconMap.put(INFO_TWO_CHANNEL_TONE, icon);
        } else if (name.startsWith("Info_4to3")) {
            this.mIconMap.put(INFO_4_3, icon);
        } else if (name.startsWith("Others")) {
            this.mIconMap.put(INFO_OTHERS, icon);
        }
    }

    public ImageIcon getInfoIcon(byte type) {
        InfoIconTheme test;
        this.loadIcons();
        ImageIcon icon = this.mIconMap.get(type);
        if (icon == null && (test = InfoThemeLoader.getInstance().getDefaultTheme()) != null && !this.mID.equals(test.getID())) {
            icon = test.getInfoIcon(type);
        }
        return icon;
    }

    public String getID() {
        return this.mID;
    }

    public String toString() {
        return this.mName;
    }

    public Icon[] getInfoIcons() {
        this.loadIcons();
        if (this.mInfoIconArr == null) {
            this.mInfoIconArr = new Icon[25];
            this.mInfoIconArr[0] = this.getInfoIcon(INFO_BLACK_AND_WHITE);
            this.mInfoIconArr[1] = this.getInfoIcon(INFO_4_3);
            this.mInfoIconArr[2] = this.getInfoIcon(INFO_16_9);
            this.mInfoIconArr[3] = this.getInfoIcon(INFO_MONO);
            this.mInfoIconArr[4] = this.getInfoIcon(INFO_STEREO);
            this.mInfoIconArr[5] = this.getInfoIcon(INFO_DOLBY_SOURROUND);
            this.mInfoIconArr[6] = this.getInfoIcon(INFO_DOLBY_DIGITAL_5_1);
            this.mInfoIconArr[7] = this.getInfoIcon(INFO_TWO_CHANNEL_TONE);
            this.mInfoIconArr[8] = this.getInfoIcon(INFO_SUBTITLE_FOR_AURALLY_HANDICAPPED);
            this.mInfoIconArr[9] = this.getInfoIcon(INFO_LIVE);
            this.mInfoIconArr[10] = this.getInfoIcon(INFO_ORIGINAL_WITH_SUBTITLE);
            this.mInfoIconArr[11] = this.getInfoIcon(INFO_NEW);
            this.mInfoIconArr[12] = this.getInfoIcon(INFO_AUDIO_DESCRIPTION);
            this.mInfoIconArr[13] = this.getInfoIcon(INFO_HD);
            this.mInfoIconArr[14] = this.getInfoIcon(INFO_MOVIE);
            this.mInfoIconArr[15] = this.getInfoIcon(INFO_SERIES);
            this.mInfoIconArr[16] = this.getInfoIcon(INFO_NEWS);
            this.mInfoIconArr[17] = this.getInfoIcon(INFO_SHOW);
            this.mInfoIconArr[18] = this.getInfoIcon(INFO_INFOTAINMENT);
            this.mInfoIconArr[19] = this.getInfoIcon(INFO_DOCU);
            this.mInfoIconArr[20] = this.getInfoIcon(INFO_ARTS);
            this.mInfoIconArr[21] = this.getInfoIcon(INFO_SPORTS);
            this.mInfoIconArr[22] = this.getInfoIcon(INFO_CHILDREN);
            this.mInfoIconArr[23] = this.getInfoIcon(INFO_OTHERS);
            this.mInfoIconArr[24] = this.getInfoIcon(INFO_SIGN_LANGUGAGE);
        }
        return this.mInfoIconArr;
    }

    private String getDescriptionForIconType(byte type) {
        ImageIcon icon = this.getInfoIcon(type);
        if (icon != null) {
            return icon.getDescription();
        }
        return null;
    }

    public String[] getInfoIconURLs() {
        this.loadIcons();
        if (this.mInfoIconURLs == null) {
            this.mInfoIconURLs = new String[25];
            this.mInfoIconURLs[0] = this.getDescriptionForIconType(INFO_BLACK_AND_WHITE);
            this.mInfoIconURLs[1] = this.getDescriptionForIconType(INFO_4_3);
            this.mInfoIconURLs[2] = this.getDescriptionForIconType(INFO_16_9);
            this.mInfoIconURLs[3] = this.getDescriptionForIconType(INFO_MONO);
            this.mInfoIconURLs[4] = this.getDescriptionForIconType(INFO_STEREO);
            this.mInfoIconURLs[5] = this.getDescriptionForIconType(INFO_DOLBY_SOURROUND);
            this.mInfoIconURLs[6] = this.getDescriptionForIconType(INFO_DOLBY_DIGITAL_5_1);
            this.mInfoIconURLs[7] = this.getDescriptionForIconType(INFO_TWO_CHANNEL_TONE);
            this.mInfoIconURLs[8] = this.getDescriptionForIconType(INFO_SUBTITLE_FOR_AURALLY_HANDICAPPED);
            this.mInfoIconURLs[9] = this.getDescriptionForIconType(INFO_LIVE);
            this.mInfoIconURLs[10] = this.getDescriptionForIconType(INFO_ORIGINAL_WITH_SUBTITLE);
            this.mInfoIconURLs[11] = this.getDescriptionForIconType(INFO_NEW);
            this.mInfoIconURLs[12] = this.getDescriptionForIconType(INFO_AUDIO_DESCRIPTION);
            this.mInfoIconURLs[13] = this.getDescriptionForIconType(INFO_HD);
            this.mInfoIconURLs[14] = this.getDescriptionForIconType(INFO_MOVIE);
            this.mInfoIconURLs[15] = this.getDescriptionForIconType(INFO_SERIES);
            this.mInfoIconURLs[16] = this.getDescriptionForIconType(INFO_NEWS);
            this.mInfoIconURLs[17] = this.getDescriptionForIconType(INFO_SHOW);
            this.mInfoIconURLs[18] = this.getDescriptionForIconType(INFO_INFOTAINMENT);
            this.mInfoIconURLs[19] = this.getDescriptionForIconType(INFO_DOCU);
            this.mInfoIconURLs[20] = this.getDescriptionForIconType(INFO_ARTS);
            this.mInfoIconURLs[21] = this.getDescriptionForIconType(INFO_SPORTS);
            this.mInfoIconURLs[22] = this.getDescriptionForIconType(INFO_CHILDREN);
            this.mInfoIconURLs[23] = this.getDescriptionForIconType(INFO_OTHERS);
            this.mInfoIconURLs[24] = this.getDescriptionForIconType(INFO_SIGN_LANGUGAGE);
        }
        return this.mInfoIconURLs;
    }

    @Override
    public int compareTo(InfoIconTheme o) {
        return this.mName != null && o.mName != null ? this.mName.compareToIgnoreCase(o.mName) : this.mID.compareToIgnoreCase(o.mID);
    }
}

