/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.common;

import devplugin.Channel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ChannelItem {
    private String mChannelDataServiceId;
    private String mCertainChannelId;
    private String mGroupId;
    private String mCountry;
    private Channel mChannel;
    private boolean mNullChannel;

    public ChannelItem(Channel channel) {
        if (channel != null) {
            this.mChannelDataServiceId = channel.getDataServiceId();
            this.mGroupId = channel.getGroup().getId();
            this.mCertainChannelId = channel.getId();
            this.mCountry = channel.getBaseCountry();
            this.mChannel = channel;
            this.mNullChannel = false;
        } else {
            this.mNullChannel = true;
            this.mChannelDataServiceId = "";
            this.mGroupId = "";
            this.mCertainChannelId = "";
            this.mCountry = "";
            this.mChannel = null;
        }
    }

    public ChannelItem(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        if (version == 1) {
            this.mChannelDataServiceId = (String)in.readObject();
            this.mCertainChannelId = (String)in.readObject();
            this.mChannel = Channel.getChannel(this.mChannelDataServiceId, null, null, this.mCertainChannelId);
            if (this.mChannel != null) {
                this.mGroupId = this.mChannel.getGroup().getId();
                this.mCountry = this.mChannel.getBaseCountry();
            }
        } else {
            this.mChannelDataServiceId = in.readUTF();
            this.mGroupId = in.readUTF();
            this.mCountry = in.readUTF();
            this.mCertainChannelId = in.readUTF();
            if (version == 3) {
                this.mNullChannel = in.readBoolean();
            }
            this.mChannel = Channel.getChannel(this.mChannelDataServiceId, this.mGroupId, this.mCountry, this.mCertainChannelId);
        }
    }

    public boolean isValid() {
        return this.mChannelDataServiceId != null && this.mGroupId != null && this.mCountry != null && this.mCertainChannelId != null;
    }

    public boolean isAvailableOrNullChannel() {
        return this.mChannel != null || this.mNullChannel;
    }

    public Channel getChannel() {
        return this.mChannel;
    }

    public void saveItem(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.mChannelDataServiceId);
        out.writeUTF(this.mGroupId);
        out.writeUTF(this.mCountry);
        out.writeUTF(this.mCertainChannelId);
        out.writeBoolean(this.mNullChannel);
    }

    public boolean isNullChannel() {
        return this.mNullChannel;
    }

    public void reValidate() {
        this.mChannel = Channel.getChannel(this.mChannelDataServiceId, this.mGroupId, this.mCountry, this.mCertainChannelId);
        this.mNullChannel = this.mChannel == null;
    }
}

