/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.core;

import devplugin.Channel;
import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramReceiveTarget;
import devplugin.ProgramSearcher;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.common.LimitationConfiguration;
import tvbrowser.extras.common.ReminderConfiguration;
import tvbrowser.extras.favoritesplugin.FavoriteConfigurator;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.favoritesplugin.core.Exclusion;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.program.ProgramUtilities;
import util.ui.SearchFormSettings;

public abstract class Favorite {
    private ArrayList<Program> mPrograms;
    private ArrayList<Program> mNewPrograms;
    private String mName;
    private ReminderConfiguration mReminderConfiguration;
    private LimitationConfiguration mLimitationConfiguration;
    private boolean mRemindAfterDownload;
    private ArrayList<Exclusion> mExclusionList;
    private ProgramReceiveTarget[] mForwardPluginArr;
    protected SearchFormSettings mSearchFormSettings;
    private HashMap<String, ReminderInfo> mRemovedPrograms;
    private ArrayList<Program> mRemovedBlacklistPrograms;
    private boolean mNewProgramsWasRequested;
    private boolean mProvideFilter;
    private long mFilterKey;
    private ArrayList<Program> mBlackList;

    public Favorite() {
        String[] stringArray;
        if (FavoritesPlugin.getInstance().isAutoSelectingReminder()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "window";
        } else {
            stringArray = new String[]{};
        }
        this.mReminderConfiguration = new ReminderConfiguration(stringArray);
        this.mLimitationConfiguration = new LimitationConfiguration();
        this.mPrograms = new ArrayList(0);
        this.mNewPrograms = new ArrayList(0);
        this.mRemovedPrograms = new HashMap(0);
        this.mRemovedBlacklistPrograms = new ArrayList(0);
        this.mExclusionList = null;
        this.mBlackList = null;
        this.mNewProgramsWasRequested = false;
        this.mFilterKey = 0L;
        this.mForwardPluginArr = new ProgramReceiveTarget[0];
        this.handleNewGlobalReceiveTargets(new ProgramReceiveTarget[0]);
    }

    public Favorite(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this();
        int version = in.readInt();
        this.mName = (String)in.readObject();
        this.mReminderConfiguration = new ReminderConfiguration(in);
        this.mLimitationConfiguration = new LimitationConfiguration(in);
        this.mRemindAfterDownload = in.readBoolean();
        int exclSize = in.readInt();
        if (exclSize > 0) {
            this.mExclusionList = new ArrayList();
        }
        for (int i = 0; i < exclSize; ++i) {
            Exclusion exclusion = new Exclusion(in);
            if (exclusion.isInvalid()) continue;
            this.mExclusionList.add(exclusion);
        }
        int cnt = in.readInt();
        this.mForwardPluginArr = new ProgramReceiveTarget[cnt];
        for (int i = 0; i < cnt; ++i) {
            if (version <= 2) {
                String id = (String)in.readObject();
                this.mForwardPluginArr[i] = ProgramReceiveTarget.createDefaultTargetForProgramReceiveIfId(id);
                continue;
            }
            this.mForwardPluginArr[i] = new ProgramReceiveTarget(in);
        }
        if (version < 4) {
            this.handleNewGlobalReceiveTargets(new ProgramReceiveTarget[0]);
        }
        int size = in.readInt();
        ArrayList<Program> programList = new ArrayList<Program>(size);
        this.readProgramsToList(programList, size, in);
        if (version >= 2) {
            size = in.readInt();
            if (size > 0) {
                this.mBlackList = new ArrayList(size);
                this.readProgramsToList(this.mBlackList, size, in);
            }
        } else {
            this.mBlackList = null;
        }
        if (this.mBlackList != null) {
            Collections.sort(this.mBlackList, ProgramUtilities.getProgramComparator());
        }
        this.mPrograms = programList;
        this.mNewPrograms = new ArrayList(0);
        this.mRemovedPrograms = new HashMap(0);
        if (version > 4) {
            this.mProvideFilter = in.readBoolean();
            this.mFilterKey = in.readLong();
        } else {
            this.mFilterKey = 0L;
            this.mProvideFilter = false;
        }
    }

    private void readProgramsToList(ArrayList<Program> list, int size, ObjectInputStream in) throws IOException, ClassNotFoundException {
        for (int i = 0; i < size; ++i) {
            Date date = Date.readData(in);
            String progID = (String)in.readObject();
            Program program = Plugin.getPluginManager().getProgram(date, progID);
            if (program == null) continue;
            list.add(program);
        }
    }

    public abstract String getTypeID();

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public LimitationConfiguration getLimitationConfiguration() {
        return this.mLimitationConfiguration;
    }

    public ReminderConfiguration getReminderConfiguration() {
        return this.mReminderConfiguration;
    }

    public void setRemindAfterDownload(boolean b) {
        this.mRemindAfterDownload = b;
    }

    public boolean isRemindAfterDownload() {
        return this.mRemindAfterDownload;
    }

    public void setForwardPlugins(ProgramReceiveTarget[] pluginArr) {
        this.mForwardPluginArr = pluginArr;
    }

    public ProgramReceiveTarget[] getForwardPlugins() {
        return this.mForwardPluginArr;
    }

    private String getReceiveTargetId(ProgramReceiveTarget target) {
        return target.getReceiveIfId() + "_" + target.getTargetId();
    }

    public void handleNewGlobalReceiveTargets(ProgramReceiveTarget[] oldDefaultTargets) {
        ProgramReceiveTarget[] defaultTargets = FavoritesPlugin.getInstance().getDefaultClientPluginsTargets();
        ArrayList<ProgramReceiveTarget> newTargets = new ArrayList<ProgramReceiveTarget>(defaultTargets.length);
        for (ProgramReceiveTarget target : defaultTargets) {
            newTargets.add(target);
        }
        for (ProgramReceiveTarget target : this.mForwardPluginArr) {
            if (this.arrayContains(oldDefaultTargets, target) || this.arrayContains(defaultTargets, target)) continue;
            newTargets.add(target);
        }
        this.mForwardPluginArr = newTargets.toArray(new ProgramReceiveTarget[newTargets.size()]);
    }

    private boolean arrayContains(ProgramReceiveTarget[] targetArr, ProgramReceiveTarget target) {
        if (targetArr != null && target != null) {
            for (ProgramReceiveTarget arrayEntry : targetArr) {
                if (arrayEntry == null || !arrayEntry.getReceiveIfId().equals(target.getReceiveIfId()) || !arrayEntry.getTargetId().equals(target.getTargetId())) continue;
                return true;
            }
        }
        return false;
    }

    public Program[] getPrograms() {
        Program[] programs = this.mPrograms.toArray(new Program[this.mPrograms.size()]);
        if (programs.length > 0) {
            Arrays.sort(programs, ProgramUtilities.getProgramComparator());
        }
        return programs;
    }

    public Program[] getNewPrograms() {
        this.mNewProgramsWasRequested = true;
        for (int i = this.mNewPrograms.size() - 1; i >= 0; --i) {
            Program test = this.mNewPrograms.get(i);
            if (test != null) {
                Program[] newProgs = Plugin.getPluginManager().getPrograms(this.mNewPrograms.get(i).getUniqueID());
                Program newProg = null;
                for (Program check : newProgs) {
                    if (!check.getTitle().equals(test.getTitle())) continue;
                    newProg = check;
                    break;
                }
                if (newProg != null && newProg.getProgramState() == 0 && !newProg.isExpired()) {
                    this.mNewPrograms.set(i, newProg);
                    continue;
                }
                this.mNewPrograms.remove(i);
                continue;
            }
            this.mNewPrograms.remove(i);
        }
        Program[] programs = this.mNewPrograms.toArray(new Program[this.mNewPrograms.size()]);
        if (programs.length > 0) {
            Arrays.sort(programs, ProgramUtilities.getProgramComparator());
        }
        return programs;
    }

    public void handleContainingPrograms(Program[] progs) {
        for (Program p : progs) {
            if (!this.mPrograms.contains(p)) continue;
            p.mark(FavoritesPluginProxy.getInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(5);
        out.writeObject(this.mName);
        this.mReminderConfiguration.store(out);
        this.mLimitationConfiguration.store(out);
        out.writeBoolean(this.mRemindAfterDownload);
        if (this.mExclusionList == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.mExclusionList.size());
            for (Exclusion exclusion : this.mExclusionList) {
                exclusion.writeData(out);
            }
        }
        out.writeInt(this.mForwardPluginArr.length);
        for (ProgramReceiveTarget receiveTarget : this.mForwardPluginArr) {
            receiveTarget.writeData(out);
        }
        ArrayList<Program> arrayList = this.mPrograms;
        synchronized (arrayList) {
            out.writeInt(this.mPrograms.size());
            for (Program p : this.mPrograms) {
                p.getDate().writeData((DataOutput)out);
                out.writeObject(p.getID());
            }
        }
        if (this.mBlackList == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.mBlackList.size());
            for (Program p : this.mBlackList) {
                p.getDate().writeData((DataOutput)out);
                out.writeObject(p.getID());
            }
        }
        out.writeBoolean(this.mProvideFilter);
        out.writeLong(this.mFilterKey);
        this.internalWriteData(out);
    }

    public Exclusion[] getExclusions() {
        if (this.mExclusionList == null) {
            return new Exclusion[0];
        }
        return this.mExclusionList.toArray(new Exclusion[this.mExclusionList.size()]);
    }

    public void addExclusion(Exclusion exclusion) {
        if (this.mExclusionList == null) {
            this.mExclusionList = new ArrayList(1);
        }
        this.mExclusionList.add(exclusion);
        try {
            this.refreshPrograms(FavoritesPlugin.getInstance().isShowingNewFoundPrograms());
            FavoritesPlugin.getInstance().updateRootNode(true);
        }
        catch (TvBrowserException exc) {
            ErrorHandler.handle("Could not update favorites.", exc);
        }
        this.updateManageDialog();
    }

    public void removeExclusion(Exclusion exclusion) {
        if (this.mExclusionList == null) {
            return;
        }
        this.mExclusionList.remove(exclusion);
    }

    public void setExclusions(Exclusion[] exclusionArr) {
        if (this.mExclusionList == null) {
            this.mExclusionList = new ArrayList(exclusionArr.length);
        } else {
            this.mExclusionList.clear();
        }
        this.mExclusionList.addAll(Arrays.asList(exclusionArr));
    }

    public boolean contains(Program prog) {
        return (this.mBlackList == null || !this.mBlackList.contains(prog)) && this.mPrograms.contains(prog);
    }

    private Program[] filterByLimitations(Program[] progArr) {
        Exclusion[] globalExclusions = FavoritesPlugin.getInstance().getGlobalExclusions();
        Exclusion[] exclusions = new Exclusion[this.getExclusions().length + globalExclusions.length];
        System.arraycopy(globalExclusions, 0, exclusions, 0, globalExclusions.length);
        System.arraycopy(this.getExclusions(), 0, exclusions, globalExclusions.length, exclusions.length - globalExclusions.length);
        ArrayList<Program> list = new ArrayList<Program>();
        int allowedDayOfWeek = this.getLimitationConfiguration().getDayLimit();
        for (Program program : progArr) {
            boolean isExcluded = false;
            for (Exclusion exclusion : exclusions) {
                if (!exclusion.isProgramExcluded(program)) continue;
                isExcluded = true;
                break;
            }
            if (!isExcluded && this.getLimitationConfiguration().isLimitedByTime()) {
                if (ProgramUtilities.isNotInTimeRange(this.getLimitationConfiguration().getTimeFrom(), this.getLimitationConfiguration().getTimeTo(), program)) {
                    isExcluded = true;
                } else if (allowedDayOfWeek != -1) {
                    Calendar cal = program.getDate().getCalendar();
                    int dayOfWeek = cal.get(7);
                    if (allowedDayOfWeek == -2) {
                        if (dayOfWeek != 1 && dayOfWeek != 7) {
                            isExcluded = true;
                        }
                    } else if (allowedDayOfWeek == -3) {
                        if (dayOfWeek == 1 || dayOfWeek == 7) {
                            isExcluded = true;
                        }
                    } else if (allowedDayOfWeek != dayOfWeek) {
                        isExcluded = true;
                    }
                }
            }
            if (isExcluded) continue;
            list.add(program);
        }
        return list.toArray(new Program[list.size()]);
    }

    public void searchNewPrograms(Program[] added, Program[] removed, boolean dataUpdate, boolean sendToPlugins) throws TvBrowserException {
        SearchFormSettings searchForm = this.mSearchFormSettings;
        ArrayList<Program> currentList = new ArrayList<Program>(this.mPrograms);
        ProgramSearcher searcher = searchForm.createSearcher();
        for (Program p : added) {
            if (!searcher.matches(p, searchForm.getFieldTypes()) || currentList.contains(p)) continue;
            currentList.add(p);
        }
        for (Program p : removed) {
            if (!currentList.contains(p)) continue;
            currentList.remove(p);
        }
        this.updatePrograms(currentList.toArray(new Program[currentList.size()]), dataUpdate, sendToPlugins);
    }

    public void updatePrograms() throws TvBrowserException {
        this.updatePrograms(false, true);
    }

    public void updatePrograms(boolean send) throws TvBrowserException {
        this.updatePrograms(false, send);
    }

    public void updatePrograms(boolean dataUpdate, boolean sendToPlugins) throws TvBrowserException {
        this.updatePrograms(this.internalSearchForPrograms(), dataUpdate, sendToPlugins);
    }

    public void refreshPrograms(boolean noNewProgramsUpdate) throws TvBrowserException {
        this.updatePrograms(this.mPrograms.toArray(new Program[this.mPrograms.size()]), false, false, noNewProgramsUpdate);
    }

    private void updatePrograms(Program[] progs, boolean dataUpdate, boolean send) throws TvBrowserException {
        this.updatePrograms(progs, dataUpdate, send, false);
    }

    private void updatePrograms(Program[] progs, boolean dataUpdate, boolean send, boolean noNewProgramsUpdate) throws TvBrowserException {
        int i;
        Program[] newProgList = this.filterByLimitations(progs);
        Comparator<Program> comparator = ProgramUtilities.getProgramComparator();
        Arrays.sort(newProgList, comparator);
        Program[] p1 = this.mPrograms.toArray(new Program[this.mPrograms.size()]);
        Arrays.sort(p1, comparator);
        ArrayList<Program> resultList = new ArrayList<Program>();
        ArrayList<Program> newPrograms = new ArrayList<Program>();
        int inx1 = 0;
        int inx2 = 0;
        while (inx1 < p1.length && inx2 < newProgList.length) {
            if (comparator.compare(p1[inx1], newProgList[inx2]) < 0) {
                this.unmarkProgram(p1[inx1]);
                ++inx1;
                continue;
            }
            if (comparator.compare(p1[inx1], newProgList[inx2]) > 0) {
                this.markProgram(newProgList[inx2], -31);
                newPrograms.add(newProgList[inx2]);
                resultList.add(newProgList[inx2]);
                ++inx2;
                continue;
            }
            if (p1[inx1].getProgramState() == 2) {
                int minutes = ReminderPlugin.getInstance().getReminderMinutesForProgram(p1[inx1]);
                this.markProgram(newProgList[inx2], minutes);
            }
            resultList.add(newProgList[inx2]);
            ++inx1;
            ++inx2;
        }
        if (inx2 < newProgList.length) {
            for (i = inx2; i < newProgList.length; ++i) {
                this.markProgram(newProgList[i], -31);
                newPrograms.add(newProgList[i]);
                resultList.add(newProgList[i]);
            }
        }
        if (inx1 < p1.length) {
            for (i = inx1; i < p1.length; ++i) {
                this.unmarkProgram(p1[i]);
            }
        }
        if (!noNewProgramsUpdate) {
            this.mNewPrograms = newPrograms;
        } else {
            for (i = this.mNewPrograms.size() - 1; i >= 0; --i) {
                if (resultList.contains(this.mNewPrograms.get(i))) continue;
                this.mNewPrograms.remove(i);
            }
        }
        ProgramReceiveTarget[] pluginArr = this.getForwardPlugins();
        if (this.mNewPrograms.size() > 0 && send && !noNewProgramsUpdate) {
            if (!dataUpdate) {
                for (ProgramReceiveTarget receiveTarget : pluginArr) {
                    if (receiveTarget == null || receiveTarget.getReceifeIfForIdOfTarget() == null) continue;
                    receiveTarget.getReceifeIfForIdOfTarget().receivePrograms(this.mNewPrograms.toArray(new Program[this.mNewPrograms.size()]), receiveTarget);
                }
            } else {
                FavoritesPlugin.getInstance().addProgramsForSending(pluginArr, this.mNewPrograms.toArray(new Program[this.mNewPrograms.size()]));
            }
        }
        this.mPrograms = resultList;
    }

    private void markProgram(Program p, int reminderMinutes) {
        if (this.mBlackList == null || !this.mBlackList.contains(p)) {
            String[] reminderServices;
            p.mark(FavoritesPluginProxy.getInstance());
            for (String reminderService : reminderServices = this.getReminderConfiguration().getReminderServices()) {
                if (!"window".equals(reminderService)) continue;
                ReminderPlugin.getInstance().addProgram(p, reminderMinutes);
            }
        }
    }

    private int unmarkProgram(Program p) {
        String[] reminderServices;
        if (!FavoriteTreeModel.getInstance().isContainedByOtherFavorites(this, p)) {
            p.unmark(FavoritesPluginProxy.getInstance());
        }
        int reminderMinutes = -42;
        for (String reminderService : reminderServices = this.getReminderConfiguration().getReminderServices()) {
            if (!"window".equals(reminderService)) continue;
            reminderMinutes = ReminderPlugin.getInstance().removeProgram(p);
        }
        return reminderMinutes;
    }

    public void refreshBlackList() {
        if (this.mBlackList == null) {
            return;
        }
        for (int i = this.mBlackList.size() - 1; i >= 0; --i) {
            Program programInList = this.mBlackList.remove(i);
            Program testProg = PluginManagerImpl.getInstance().getProgram(programInList.getDate(), programInList.getID());
            if (testProg == null || programInList.getTitle().toLowerCase().compareTo(testProg.getTitle().toLowerCase()) != 0) continue;
            this.mBlackList.add(testProg);
        }
    }

    public boolean isOnBlackList(Program program) {
        return this.mBlackList != null && this.mBlackList.contains(program);
    }

    public void addToBlackList(Program program) {
        if (this.mBlackList == null) {
            this.mBlackList = new ArrayList(1);
        }
        if (!this.mBlackList.contains(program)) {
            this.mBlackList.add(program);
            Collections.sort(this.mBlackList, ProgramUtilities.getProgramComparator());
            this.unmarkProgram(program);
            FavoritesPlugin.getInstance().updateRootNode(true);
            this.updateManageDialog();
        }
    }

    public void removeFromBlackList(Program program) {
        if (this.mBlackList == null) {
            return;
        }
        if (this.mBlackList.remove(program)) {
            this.markProgram(program, -31);
            FavoritesPlugin.getInstance().updateRootNode(true);
            this.updateManageDialog();
        }
    }

    private void updateManageDialog() {
        FavoritesPlugin.getInstance().favoriteSelectionChanged();
    }

    public Program[] getWhiteListPrograms() {
        return this.getWhiteListPrograms(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Program[] getWhiteListPrograms(boolean onlyNotExpiredPrograms) {
        ArrayList<Program> tempProgramArr = new ArrayList<Program>();
        ArrayList<Program> arrayList = this.mPrograms;
        synchronized (arrayList) {
            for (Program p : this.mPrograms) {
                if (this.mBlackList != null && this.mBlackList.contains(p) || onlyNotExpiredPrograms && p.isExpired()) continue;
                tempProgramArr.add(p);
            }
        }
        Program[] retArray = tempProgramArr.toArray(new Program[tempProgramArr.size()]);
        Arrays.sort(retArray, ProgramUtilities.getProgramComparator());
        return retArray;
    }

    public Program[] getBlackListPrograms() {
        if (this.mBlackList == null) {
            return new Program[0];
        }
        return this.mBlackList.toArray(new Program[this.mBlackList.size()]);
    }

    public abstract FavoriteConfigurator createConfigurator();

    protected abstract void internalWriteData(ObjectOutputStream var1) throws IOException;

    protected Program[] internalSearchForPrograms() throws TvBrowserException {
        SearchFormSettings searchForm = this.mSearchFormSettings;
        ProgramSearcher searcher = searchForm.createSearcher();
        return searcher.search(searchForm.getFieldTypes(), new Date().addDays(-1), 1000, this.getChannels(), false);
    }

    public boolean containsReceiveTarget(ProgramReceiveTarget target) {
        if (this.mForwardPluginArr != null && target != null) {
            for (ProgramReceiveTarget tar : this.mForwardPluginArr) {
                if (!tar.getReceiveIfId().equals(target.getReceiveIfId()) || !tar.getTargetId().equals(target.getTargetId())) continue;
                return true;
            }
        }
        return false;
    }

    protected Channel[] getChannels() {
        Channel[] channelArr = this.getLimitationConfiguration().isLimitedByChannel() ? this.getLimitationConfiguration().getChannels() : Plugin.getPluginManager().getSubscribedChannels();
        return channelArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryToMatch(Program p) throws TvBrowserException {
        block33: {
            try {
                ArrayList<Program> arrayList;
                if (!this.matches(p) || this.filterByLimitations(new Program[]{p}).length <= 0 || this.getLimitationConfiguration().isLimitedByChannel() && !Arrays.asList(this.getChannels()).contains(p.getChannel())) break block33;
                boolean wasOnBlackList = false;
                if (this.mBlackList == null) {
                    arrayList = this.mRemovedBlacklistPrograms;
                    synchronized (arrayList) {
                        if (this.mRemovedBlacklistPrograms.remove(p)) {
                            ArrayList<Program> arrayList2 = this.mBlackList = new ArrayList();
                            synchronized (arrayList2) {
                                this.mBlackList.add(p);
                            }
                            wasOnBlackList = true;
                        }
                    }
                }
                arrayList = this.mBlackList;
                synchronized (arrayList) {
                    int blackListPos = this.mBlackList.indexOf(p);
                    ArrayList<Program> arrayList3 = this.mRemovedBlacklistPrograms;
                    synchronized (arrayList3) {
                        if (this.mRemovedBlacklistPrograms.remove(p) || blackListPos >= 0) {
                            if (blackListPos >= 0) {
                                this.mBlackList.remove(blackListPos);
                            }
                            this.mBlackList.add(p);
                            wasOnBlackList = true;
                        }
                    }
                }
                if (wasOnBlackList) break block33;
                arrayList = this.mPrograms;
                synchronized (arrayList) {
                    boolean newFound = false;
                    int pos = this.mPrograms.indexOf(p);
                    ReminderInfo info = null;
                    if (pos >= 0) {
                        this.mPrograms.remove(pos);
                        this.mPrograms.add(p);
                    }
                    boolean wasOnList = false;
                    Cloneable cloneable = this.mRemovedPrograms;
                    synchronized (cloneable) {
                        info = this.mRemovedPrograms.remove(this.getProgramKeyFor(p));
                        if (info != null) {
                            this.mPrograms.add(p);
                            int reminderMinutes = info.getReminderMinutes();
                            if (reminderMinutes == -42 && !info.equals(p)) {
                                reminderMinutes = -31;
                            }
                            this.markProgram(p, reminderMinutes);
                            wasOnList = true;
                        }
                    }
                    if (pos < 0 && !wasOnList) {
                        this.mPrograms.add(p);
                        this.markProgram(p, -31);
                        if (!p.isExpired()) {
                            cloneable = this.mNewPrograms;
                            synchronized (cloneable) {
                                this.mNewPrograms.add(p);
                            }
                            newFound = true;
                        }
                    }
                    if (newFound) {
                        ProgramReceiveTarget[] pluginArr = this.getForwardPlugins();
                        FavoritesPlugin.getInstance().addProgramsForSending(pluginArr, this.mNewPrograms.toArray(new Program[this.mNewPrograms.size()]));
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public boolean matches(Program p) throws TvBrowserException {
        return this.getSearcher().matches(p, this.mSearchFormSettings.getFieldTypes());
    }

    public ProgramSearcher getSearcher() throws TvBrowserException {
        return this.mSearchFormSettings.createSearcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgram(Program p) {
        boolean wasInList = false;
        ArrayList<Program> arrayList = this.mPrograms;
        synchronized (arrayList) {
            if (this.mPrograms.remove(p)) {
                int reminderMinutes = this.unmarkProgram(p);
                wasInList = true;
                HashMap<String, ReminderInfo> hashMap = this.mRemovedPrograms;
                synchronized (hashMap) {
                    this.mRemovedPrograms.put(this.getProgramKeyFor(p), new ReminderInfo(p.getTitle(), p.getTextField(ProgramFieldType.EPISODE_TYPE), reminderMinutes));
                }
            }
        }
        if (!wasInList && this.mBlackList != null) {
            arrayList = this.mBlackList;
            synchronized (arrayList) {
                if (this.mBlackList != null && this.mBlackList.remove(p)) {
                    ArrayList<Program> arrayList2 = this.mRemovedBlacklistPrograms;
                    synchronized (arrayList2) {
                        this.mRemovedBlacklistPrograms.add(p);
                    }
                }
            }
        }
    }

    public void clearNewPrograms() {
        if (this.mNewProgramsWasRequested) {
            this.mNewPrograms = new ArrayList(0);
            this.mNewProgramsWasRequested = false;
        }
    }

    public void clearRemovedPrograms() {
        this.mRemovedPrograms = new HashMap(0);
        this.mRemovedBlacklistPrograms = new ArrayList(0);
    }

    private String getProgramKeyFor(Program p) {
        return p.getChannel().getUniqueId() + p.getDate().getValue() + "_" + p.getStartTime() + "_" + p.getTitle();
    }

    public void reValidateChannelLimitation() {
        this.mLimitationConfiguration.reValidateChannels();
    }

    public void revalidatePrograms() {
        new Thread("revalidate favorites"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Program prog;
                int i;
                this.setPriority(1);
                Date todayMinus2 = Date.getCurrentDate().addDays(-2);
                ArrayList arrayList = Favorite.this.mPrograms;
                synchronized (arrayList) {
                    for (i = Favorite.this.mPrograms.size() - 1; i >= 0; --i) {
                        try {
                            if (((Program)Favorite.this.mPrograms.get(i)).getDate().compareTo(todayMinus2) <= 0) {
                                Favorite.this.mPrograms.remove(i);
                                continue;
                            }
                            if (((Program)Favorite.this.mPrograms.get(i)).getProgramState() != 1) continue;
                            prog = (Program)Favorite.this.mPrograms.remove(i);
                            Favorite.this.mPrograms.add(i, Plugin.getPluginManager().getProgram(prog.getDate(), prog.getID()));
                            continue;
                        }
                        catch (Exception e) {
                            Favorite.this.mPrograms.remove(i);
                        }
                    }
                }
                if (Favorite.this.mBlackList != null) {
                    arrayList = Favorite.this.mBlackList;
                    synchronized (arrayList) {
                        for (i = Favorite.this.mBlackList.size() - 1; i >= 0; --i) {
                            try {
                                if (((Program)Favorite.this.mBlackList.get(i)).getDate().compareTo(todayMinus2) <= 0) {
                                    Favorite.this.mBlackList.remove(i);
                                    continue;
                                }
                                if (((Program)Favorite.this.mBlackList.get(i)).getProgramState() != 1) continue;
                                prog = (Program)Favorite.this.mBlackList.remove(i);
                                Favorite.this.mBlackList.add(i, Plugin.getPluginManager().getProgram(prog.getDate(), prog.getID()));
                                continue;
                            }
                            catch (Exception e) {
                                Favorite.this.mBlackList.remove(i);
                            }
                        }
                    }
                }
            }
        }.start();
    }

    public void setProvideFilter(boolean provideFilter) {
        if (provideFilter && !this.mProvideFilter) {
            this.mFilterKey = System.currentTimeMillis();
        }
        this.mProvideFilter = provideFilter;
    }

    public boolean isProvidingFilter() {
        return this.mProvideFilter;
    }

    public boolean accept(Program p) {
        if (this.mProvideFilter) {
            return this.mPrograms.contains(p);
        }
        return false;
    }

    public boolean hasFilterForKey(long key) {
        return this.isProvidingFilter() && this.mFilterKey == key;
    }

    public long getFilterKey() {
        return this.mFilterKey;
    }

    public abstract boolean isValidSearch();

    private class ReminderInfo {
        private String mTitle;
        private String mEpisode;
        private int mMinutes;

        public ReminderInfo(String title, String episode, int minutes) {
            this.mTitle = title;
            this.mEpisode = episode;
            this.mMinutes = minutes;
        }

        public int getReminderMinutes() {
            return this.mMinutes;
        }

        public boolean equals(Object o) {
            if (o instanceof Program) {
                Program test = (Program)o;
                return !(!test.getTitle().trim().equalsIgnoreCase(this.mTitle.trim()) || test.hasFieldValue(ProgramFieldType.EPISODE_TYPE) && this.mEpisode != null && !test.getTextField(ProgramFieldType.EPISODE_TYPE).equalsIgnoreCase(this.mEpisode) || !test.hasFieldValue(ProgramFieldType.EPISODE_TYPE) && this.mEpisode != null);
            }
            return this == o;
        }
    }
}

