/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.programinfo;

import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import devplugin.ProgramFieldType;
import devplugin.ProgramInfo;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.UIManager;
import tvbrowser.extras.common.ConfigurationHandler;
import util.program.CompoundedProgramFieldType;
import util.program.ProgramTextCreator;

class ProgramInfoSettings {
    private static final int DEFAULT_BODY_STYLE = 0;
    private static final int DEFAULT_TITLE_STYLE = 1;
    private static final String KEY_FIELD_ORDER = "order";
    private static final String KEY_FIELD_KNOWN_ORDER = "knownOrder";
    private static final String KEY_LOOK = "look";
    private static final String DEFAULT_BODY_FONT_NAME = "Verdana";
    private static final String DEFAULT_TITLE_FONT_NAME = "Verdana";
    private static final String KEY_LEFT_SPLIT_WIDTH = "LeftSplit.Width";
    private static final String KEY_LEFT_SPLIT_HEIGHT = "LeftSplit.Height";
    private static final String KEY_SETUPWASDONE = "setupwasdone";
    private static final String KEY_SHOW_SEARCH = "showSearch";
    private static final String KEY_PICTURE_SETTINGS = "pictureSettings";
    private static final String KEY_ENABLE_SEARCH = "enableSearch";
    private static final String KEY_ZOOM_VALUE = "zoomValue";
    private static final String KEY_ZOOM_ENABLED = "zoom";
    private static final String KEY_USERFONT_ENABLED = "userfont";
    private static final String KEY_SHOW_TEXT_SEARCH_BUTTON = "showTextSearchButton";
    private static final String KEY_SHOW_FUNCTIONS = "showFunctions";
    private static final String KEY_BODYFONT_SIZE = "small";
    private static final String KEY_TITLEFONT_SIZE = "title";
    private static final String KEY_ANTIALIASING = "antialiasing";
    private static final String KEY_TITLEFONT_NAME = "titlefont";
    private static final String KEY_BODYFONT_NAME = "bodyfont";
    private static final String KEY_ACTOR_SEARCH_DEFAULT = "actorSearchDefault";
    private static final String KEY_HIGHLIGHT_COLOR = "highlightColor";
    private static final String KEY_HIGHLIGHT_ACTIVE = "highlightActive";
    private static final String TITLE_FONT_STYLE = "titleFontStyle";
    private static final String BODY_FONT_STYLE = "bodyFontStyle";
    static final int DURATION_END_TYPE_VALUE = 1000;
    private Properties mProperties;

    protected ProgramInfoSettings(Properties properties) {
        this.mProperties = properties;
    }

    protected boolean getShowFunctions() {
        return this.getProperty(KEY_SHOW_FUNCTIONS, true);
    }

    protected boolean getShowSearchButton() {
        return this.getProperty(KEY_SHOW_TEXT_SEARCH_BUTTON, true);
    }

    protected boolean getAntialiasing() {
        return this.getProperty(KEY_ANTIALIASING, true);
    }

    private String getProperty(String key, String defaultValue) {
        return this.mProperties.getProperty(key, defaultValue);
    }

    protected boolean getUserFont() {
        return this.getProperty(KEY_USERFONT_ENABLED, false);
    }

    protected int getTitleFontSize() {
        return this.getProperty(KEY_TITLEFONT_SIZE, UIManager.getFont("MenuItem.font").getSize() + 7);
    }

    protected int getBodyFontSize() {
        return this.getProperty(KEY_BODYFONT_SIZE, UIManager.getFont("MenuItem.font").getSize());
    }

    protected String getTitleFontName() {
        return this.getProperty(KEY_TITLEFONT_NAME, "Verdana");
    }

    protected String getBodyFontName() {
        return this.getProperty(KEY_BODYFONT_NAME, "Verdana");
    }

    protected void setAntialiasing(boolean value) {
        this.setProperty(KEY_ANTIALIASING, value);
    }

    private void setProperty(String key, String value) {
        this.mProperties.setProperty(key, value);
    }

    private void setProperty(String key, int value) {
        this.mProperties.setProperty(key, Integer.toString(value));
    }

    private void setProperty(String key, boolean value) {
        this.mProperties.setProperty(key, Boolean.toString(value));
    }

    protected void setTitleFontName(String name) {
        this.setProperty(KEY_TITLEFONT_NAME, name);
    }

    protected void setTitleFontSize(int size) {
        this.setProperty(KEY_TITLEFONT_SIZE, size);
    }

    protected void setBodyFontName(String name) {
        this.setProperty(KEY_BODYFONT_NAME, name);
    }

    protected void setUserFont(boolean selected) {
        this.setProperty(KEY_USERFONT_ENABLED, selected);
    }

    protected void setBodyFontSize(int size) {
        this.setProperty(KEY_BODYFONT_SIZE, size);
    }

    protected String getActorSearch() {
        return this.getProperty(KEY_ACTOR_SEARCH_DEFAULT, "internalWikipedia");
    }

    protected void setActorSearch(String value) {
        this.setProperty(KEY_ACTOR_SEARCH_DEFAULT, value);
    }

    protected void setZoomEnabled(boolean enabled) {
        this.setProperty(KEY_ZOOM_ENABLED, enabled);
    }

    protected void setZoomValue(int value) {
        this.setProperty(KEY_ZOOM_VALUE, value);
    }

    protected void setShowFunctions(boolean show) {
        this.setProperty(KEY_SHOW_FUNCTIONS, show);
    }

    protected void setShowSearchButton(boolean show) {
        this.setProperty(KEY_SHOW_TEXT_SEARCH_BUTTON, show);
    }

    protected boolean getZoomEnabled() {
        return this.getProperty(KEY_ZOOM_ENABLED, true);
    }

    protected int getZoomValue() {
        return this.getProperty(KEY_ZOOM_VALUE, 120);
    }

    protected boolean getEnableSearch() {
        return this.getProperty(KEY_ENABLE_SEARCH, true);
    }

    protected void setEnableSearch(boolean enable) {
        this.setProperty(KEY_ENABLE_SEARCH, enable);
    }

    protected void setPictureSettings(int type) {
        this.setProperty(KEY_PICTURE_SETTINGS, type);
    }

    protected int getPictureSettings() {
        return Integer.parseInt(this.getProperty(KEY_PICTURE_SETTINGS, String.valueOf(0)));
    }

    protected void setWidth(int width) {
        this.setProperty(KEY_LEFT_SPLIT_WIDTH, width);
    }

    protected void setHeight(int height) {
        this.setProperty(KEY_LEFT_SPLIT_HEIGHT, height);
    }

    protected int getWidth() {
        return this.getProperty(KEY_LEFT_SPLIT_WIDTH, 0);
    }

    private int getProperty(String key, int defaultValue) {
        return Integer.parseInt(this.getProperty(key, String.valueOf(defaultValue)));
    }

    protected int getHeight() {
        return this.getProperty(KEY_LEFT_SPLIT_HEIGHT, 0);
    }

    protected boolean getExpanded(String key) {
        return this.getProperty(key, true);
    }

    private boolean getProperty(String key, boolean defaultValue) {
        return Boolean.valueOf(this.getProperty(key, String.valueOf(defaultValue)));
    }

    protected void setExpanded(String key, boolean value) {
        this.setProperty(key, String.valueOf(value));
    }

    protected void setSetupwasdone(boolean b) {
        this.setProperty(KEY_SETUPWASDONE, b);
    }

    protected boolean getSetupwasdone() {
        return this.getProperty(KEY_SETUPWASDONE, false);
    }

    protected void setShowSearch(boolean show) {
        this.setProperty(KEY_SHOW_SEARCH, show);
    }

    protected boolean getShowSearch() {
        return this.getProperty(KEY_SHOW_SEARCH, false);
    }

    protected void storeSettings(ConfigurationHandler configurationHandler) throws IOException {
        configurationHandler.storeSettings(this.mProperties);
    }

    protected Font getUsedTitleFont() {
        if (this.getUserFont()) {
            return new Font(this.getTitleFontName(), this.getTitleFontStyle(), this.getTitleFontSize());
        }
        return new Font("Verdana", 1, UIManager.getFont("MenuItem.font").getSize() + 7);
    }

    protected Font getUsedBodyFont() {
        if (this.getUserFont()) {
            return new Font(this.getBodyFontName(), this.getBodyFontStyle(), this.getBodyFontSize());
        }
        return new Font("Verdana", 0, UIManager.getFont("MenuItem.font").getSize());
    }

    protected String getLook() {
        return this.getProperty(KEY_LOOK, LookAndFeelAddons.getBestMatchAddonClassName());
    }

    protected void setLook(String name) {
        this.setProperty(KEY_LOOK, name);
    }

    protected Object[] getFieldOrder() {
        if (!this.getSetupwasdone()) {
            return ProgramTextCreator.getDefaultOrderWithActivatedPluginInfo();
        }
        StringBuilder defaultOrder = new StringBuilder();
        Object[] defaultOrderArr = ProgramTextCreator.getDefaultOrderWithActivatedPluginInfo();
        ProgramInfo[] defaultPluginOrderArr = ProgramTextCreator.getDefaultOrderOfActivatedPluginInfo();
        for (Object field : defaultOrderArr) {
            defaultOrder.append(field.toString()).append(";");
        }
        String[] id = this.getProperty(KEY_FIELD_ORDER, defaultOrder.toString()).trim().split(";");
        ArrayList<Object> result = new ArrayList<Object>(id.length);
        for (int i = 0; i < id.length; ++i) {
            try {
                if (id[i].startsWith("plugin:")) {
                    for (ProgramInfo pluginAdditonalInfo : defaultPluginOrderArr) {
                        if (!id[i].equals(pluginAdditonalInfo.getPluginUniqueId())) continue;
                        result.add(pluginAdditonalInfo);
                    }
                    continue;
                }
                int parsedId = Integer.parseInt(id[i]);
                if (parsedId >= 0) {
                    ProgramFieldType type = ProgramFieldType.getTypeForId(parsedId);
                    if (type.getFormat() != 1) {
                        result.add(type);
                        continue;
                    }
                    if (result.contains(ProgramTextCreator.getDurationTypeString()) || parsedId != 1000) continue;
                    result.add(ProgramTextCreator.getDurationTypeString());
                    continue;
                }
                CompoundedProgramFieldType type = CompoundedProgramFieldType.getCompoundedProgramFieldTypeForId(parsedId);
                if (type == null) continue;
                result.add(type);
                continue;
            }
            catch (NumberFormatException e) {
                return ProgramTextCreator.getDefaultOrder();
            }
        }
        String[] knownIds = this.getProperty(KEY_FIELD_KNOWN_ORDER, this.getProperty(KEY_FIELD_ORDER, defaultOrder.toString())).trim().split(";");
        for (Object orderDefault : defaultOrderArr) {
            boolean found = false;
            for (String knownId : knownIds) {
                if (!(orderDefault instanceof ProgramInfo && knownId.equals(((ProgramInfo)orderDefault).getPluginUniqueId()) || orderDefault instanceof ProgramFieldType && knownId.equals(String.valueOf(((ProgramFieldType)orderDefault).getTypeId())) || orderDefault instanceof String && knownId.equals(String.valueOf(1000))) && (!(orderDefault instanceof CompoundedProgramFieldType) || !knownId.equals(String.valueOf(((CompoundedProgramFieldType)orderDefault).getId())))) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(orderDefault);
        }
        Object[] fields = result.toArray(new Object[result.size()]);
        this.setFieldOrder(fields);
        this.setFieldOrder(defaultOrderArr, KEY_FIELD_KNOWN_ORDER);
        return fields;
    }

    protected void setFieldOrder(Object[] order) {
        this.setFieldOrder(order, KEY_FIELD_ORDER);
    }

    private void setFieldOrder(Object[] order, String key) {
        StringBuilder temp = new StringBuilder();
        for (Object object : order) {
            if (object instanceof String) {
                temp.append(1000).append(';');
                continue;
            }
            if (object instanceof ProgramInfo) {
                temp.append(((ProgramInfo)object).getPluginUniqueId()).append(';');
                continue;
            }
            if (object instanceof CompoundedProgramFieldType) {
                temp.append(((CompoundedProgramFieldType)object).getId()).append(';');
                continue;
            }
            temp.append(((ProgramFieldType)object).getTypeId()).append(';');
        }
        this.setProperty(key, temp.toString());
    }

    protected void setHighlightColor(Color color) {
        this.setProperty(KEY_HIGHLIGHT_COLOR, color.getRGB());
    }

    protected Color getHighlightColor() {
        int code = this.getProperty(KEY_HIGHLIGHT_COLOR, -1);
        if (code == -1) {
            return Color.PINK;
        }
        return new Color(code, true);
    }

    protected boolean getHighlightFavorite() {
        return this.getProperty(KEY_HIGHLIGHT_ACTIVE, true);
    }

    protected void setHighlightFavorite(boolean highlight) {
        this.setProperty(KEY_HIGHLIGHT_ACTIVE, highlight);
    }

    protected int getTitleFontStyle() {
        return this.getProperty(TITLE_FONT_STYLE, 1);
    }

    protected int getBodyFontStyle() {
        return this.getProperty(BODY_FONT_STYLE, 0);
    }

    protected void setTitleFontStyle(int style) {
        this.setProperty(TITLE_FONT_STYLE, style);
    }

    protected void setBodyFontStyle(int style) {
        this.setProperty(BODY_FONT_STYLE, style);
    }
}

