/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import tvbrowser.core.Settings;
import util.ui.Localizer;

public class DontShowAgainOptionBox {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(DontShowAgainOptionBox.class);

    public static int showOptionDialog(String messageBoxId, Component parent, String message, String title, int messageType, int optionType, Object[] options, Object initialValue, String dontShowAgainLabel) {
        if (Settings.propHiddenMessageBoxes.containsItem(messageBoxId)) {
            return 0;
        }
        if (!message.endsWith("\n\n")) {
            message = message.concat("\n\n");
        }
        JCheckBox askAgain = new JCheckBox(dontShowAgainLabel == null ? mLocalizer.msg("dontShowAgain", "Don't show this message again") : dontShowAgainLabel);
        Object[] shownObjects = new Object[]{message, askAgain};
        int result = JOptionPane.showOptionDialog(parent, shownObjects, title, optionType, messageType, null, options, initialValue);
        if (askAgain.isSelected()) {
            Settings.propHiddenMessageBoxes.addItem(messageBoxId);
        }
        return result;
    }

    public static int showOptionDialog(String messageBoxId, Component parent, String message, String title, int messageType) {
        return DontShowAgainOptionBox.showOptionDialog(messageBoxId, parent, message, title, messageType, -1, null, null, null);
    }

    public static int showOptionDialog(String messageBoxId, Component parentComponent, String message, String title) {
        return DontShowAgainOptionBox.showOptionDialog(messageBoxId, parentComponent, message, title, 1);
    }

    public static int showOptionDialog(String messageBoxId, Component parentComponent, String message) {
        return DontShowAgainOptionBox.showOptionDialog(messageBoxId, parentComponent, message, UIManager.getString("OptionPane.messageDialogTitle"));
    }
}

