/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe.searchfield;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTextFieldUI;
import org.apache.commons.lang3.StringUtils;
import util.ui.Localizer;
import util.ui.UiUtilities;

public class SearchTextField
extends JTextField
implements FocusListener {
    protected static final Localizer mLocalizer = Localizer.getLocalizerFor(SearchTextField.class);
    private Color mTextColor;
    private Color mNoTextColor;

    public SearchTextField(int len) {
        super(len);
        this.setUI(new BasicTextFieldUI(){

            @Override
            protected void paintBackground(Graphics g) {
                if (!UiUtilities.isGTKLookAndFeel() && !UiUtilities.isNimbusLookAndFeel()) {
                    super.paintBackground(g);
                }
            }
        });
        this.addFocusListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    SearchTextField.this.requestFocus();
                }
            }
        });
        int r = this.getForeground().getRed() + this.getBackground().getRed() >> 1;
        int g = this.getForeground().getGreen() + this.getBackground().getGreen() >> 1;
        int b = this.getForeground().getBlue() + this.getBackground().getBlue() >> 1;
        this.mNoTextColor = new Color(r, g, b);
        this.mTextColor = this.getForeground();
        this.setText(mLocalizer.ellipsisMsg("search", "Search"));
        this.setForeground(this.mNoTextColor);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.getText().equals(mLocalizer.ellipsisMsg("search", "Search"))) {
            this.setText("");
        }
        this.setForeground(this.mTextColor);
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (StringUtils.isEmpty(this.getText())) {
            this.setText(mLocalizer.ellipsisMsg("search", "Search"));
            this.setForeground(this.mNoTextColor);
        }
        this.repaint();
    }

    @Override
    public void replaceSelection(String content) {
        if (this.getSelectionStart() == this.getSelectionEnd() && this.getText().equals(mLocalizer.ellipsisMsg("search", "Search"))) {
            this.setText("");
            this.setSelectionStart(0);
            this.setSelectionEnd(0);
        }
        super.replaceSelection(content);
        this.requestFocus();
    }
}

