/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe.toolbar;

import devplugin.ActionMenu;
import devplugin.Channel;
import devplugin.ContextMenuSeparatorAction;
import devplugin.Date;
import devplugin.ProgressMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import tvbrowser.core.DateListener;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.ButtonActionIf;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.ui.filter.dlgs.SelectFilterPopup;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.actions.TVBrowserAction;
import tvbrowser.ui.mainframe.actions.TVBrowserActions;
import tvbrowser.ui.mainframe.toolbar.ToolBarModel;
import util.ui.Localizer;
import util.ui.ScrollableMenu;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;

public class DefaultToolBarModel
implements ToolBarModel,
DateListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(DefaultToolBarModel.class);
    private Map<String, Action> mAvailableActions;
    private ArrayList<Action> mVisibleActions;
    private ArrayList<Action> actionOrder;
    private Action mUpdateAction;
    private Action mSettingsAction;
    private Action mFilterAction;
    private Action mPluginViewAction;
    private Action mSeparatorAction;
    private Action mScrollToNowAction;
    private Action mGoToTodayAction;
    private Action mGoToPreviousDayAction;
    private Action mGoToNextDayAction;
    private Action mGoToPreviousWeekAction;
    private Action mGoToNextWeekAction;
    private Action mGoToDateAction;
    private Action mScrollToChannelAction;
    private Action mScrollToTimeAction;
    private Action mGlueAction;
    private Action mSpaceAction;
    private Action mFontSizeSmallerAction;
    private Action mFontSizeLargerAction;
    private static DefaultToolBarModel sInstance;

    private DefaultToolBarModel(String[] buttonIds) {
        this.createAvailableActions();
        this.mSeparatorAction = this.getSeparatorAction();
        this.mGlueAction = this.getGlueAction();
        this.mSpaceAction = this.getSpaceAction();
        this.setButtonIds(buttonIds);
    }

    public void setButtonIds(String[] ids) {
        if (ids == null) {
            this.createDefaultVisibleActions();
        } else {
            this.createVisibleActions(ids);
        }
    }

    public static DefaultToolBarModel getInstance() {
        if (sInstance == null) {
            sInstance = new DefaultToolBarModel(Settings.propToolbarButtons.getStringArray());
        }
        return sInstance;
    }

    public void setFilterButtonSelected(boolean arg) {
        this.mFilterAction.putValue("ActionIsSelected", arg);
        if (arg) {
            this.mFilterAction.putValue("SmallIcon", IconLoader.getInstance().getIconFromTheme("status", "view-filter-set-list", 16));
            this.mFilterAction.putValue("BigIcon", IconLoader.getInstance().getIconFromTheme("status", "view-filter-set-list", 22));
        } else {
            this.mFilterAction.putValue("SmallIcon", IconLoader.getInstance().getIconFromTheme("actions", "view-filter-list", 16));
            this.mFilterAction.putValue("BigIcon", IconLoader.getInstance().getIconFromTheme("actions", "view-filter-list", 22));
        }
    }

    private void createAvailableActions() {
        TvDataServiceProxy[] dataServiceProxys;
        PluginProxy[] pluginProxys;
        InternalPluginProxyIf[] internalPlugins;
        this.mAvailableActions = new HashMap<String, Action>();
        this.actionOrder = new ArrayList();
        this.mUpdateAction = this.createAction(TVBrowserActions.update);
        this.mSettingsAction = this.createAction(TVBrowserActions.settings);
        this.mFilterAction = this.createAction(TVBrowserActions.filter);
        this.mPluginViewAction = this.createAction(TVBrowserActions.pluginView);
        this.mScrollToNowAction = this.createAction(TVBrowserActions.scrollToNow);
        this.mGoToPreviousDayAction = this.createAction(TVBrowserActions.goToPreviousDay);
        this.mGoToTodayAction = this.createAction(TVBrowserActions.goToToday);
        this.mGoToNextDayAction = this.createAction(TVBrowserActions.goToNextDay);
        this.mGoToPreviousWeekAction = this.createAction(TVBrowserActions.goToPreviousWeek);
        this.mGoToNextWeekAction = this.createAction(TVBrowserActions.goToNextWeek);
        this.mGoToDateAction = this.createAction(TVBrowserActions.goToDate);
        this.mScrollToChannelAction = this.createAction(TVBrowserActions.scrollToChannel);
        this.mScrollToTimeAction = this.createAction(TVBrowserActions.scrollToTime);
        this.mFontSizeSmallerAction = this.createAction(TVBrowserActions.fontSizeSmaller);
        this.mFontSizeLargerAction = this.createAction(TVBrowserActions.fontSizeLarger);
        this.updateTimeButtons();
        for (InternalPluginProxyIf internalPlugin : internalPlugins = InternalPluginProxyList.getInstance().getAvailableProxys()) {
            if (!(internalPlugin instanceof ButtonActionIf)) continue;
            this.createPluginAction((ButtonActionIf)((Object)internalPlugin));
        }
        for (PluginProxy pluginProxy : pluginProxys = PluginProxyManager.getInstance().getActivatedPlugins()) {
            this.createPluginAction(pluginProxy);
        }
        for (TvDataServiceProxy dataServiceProxy : dataServiceProxys = TvDataServiceProxyManager.getInstance().getDataServices()) {
            this.createPluginAction(dataServiceProxy);
        }
    }

    private void createPluginAction(ButtonActionIf plugin) {
        ActionMenu actionMenu = plugin.getButtonAction();
        if (actionMenu != null) {
            if (!actionMenu.hasSubItems()) {
                Action action = actionMenu.getAction();
                action.putValue("ActionId", plugin.getId());
                this.mAvailableActions.put(plugin.getId(), action);
                String tooltip = (String)action.getValue("ShortDescription");
                if (tooltip == null) {
                    action.putValue("ShortDescription", plugin.getButtonActionDescription());
                }
            } else {
                this.createPluginAction(plugin, actionMenu.getSubItems());
            }
        }
    }

    private void createPluginAction(ButtonActionIf plugin, ActionMenu[] subMenus) {
        for (ActionMenu menu : subMenus) {
            if (menu.hasSubItems()) {
                this.createPluginAction(plugin, menu.getSubItems());
                continue;
            }
            Action action = menu.getAction();
            if (ContextMenuSeparatorAction.getInstance().equals(action)) continue;
            try {
                String key = plugin.getId() + "##" + (action.getValue("ActionId") != null ? action.getValue("ActionId") : action.getValue("Name"));
                action.putValue("ActionId", key);
                this.mAvailableActions.put(key, action);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            String tooltip = (String)action.getValue("ShortDescription");
            if (tooltip != null) continue;
            if (subMenus.length == 1) {
                action.putValue("ShortDescription", plugin.getButtonActionDescription());
                continue;
            }
            action.putValue("ShortDescription", action.getValue("Name"));
        }
    }

    protected void updatePluginButtons() {
        String[] deactivatedPlugins;
        PluginProxy[] activatedPlugins = PluginProxyManager.getInstance().getActivatedPlugins();
        for (int i = 0; i < activatedPlugins.length; ++i) {
            if (this.mAvailableActions.containsKey(activatedPlugins[i].getId())) continue;
            this.createPluginAction(activatedPlugins[i]);
            String[] buttonNames = Settings.propToolbarButtons.getStringArray();
            if (buttonNames == null) continue;
            for (int j = 0; j < buttonNames.length; ++j) {
                Action action;
                if (buttonNames[j].compareTo(activatedPlugins[i].getId()) != 0 || (action = this.mAvailableActions.get(buttonNames[j])) == null) continue;
                int index = this.mVisibleActions.size();
                this.mVisibleActions.add(j > index ? index : j, action);
            }
        }
        for (String deactivatedPlugin : deactivatedPlugins = PluginProxyManager.getInstance().getDeactivatedPluginIds()) {
            if (!this.mAvailableActions.containsKey(deactivatedPlugin)) continue;
            this.mVisibleActions.remove(this.mAvailableActions.remove(deactivatedPlugin));
        }
    }

    protected void updateTimeButtons() {
        String[] keys = new String[this.mAvailableActions.keySet().size()];
        this.mAvailableActions.keySet().toArray(keys);
        ArrayList<String> availableTimeActions = new ArrayList<String>();
        for (String key : keys) {
            Action action = this.mAvailableActions.get(key);
            String test = action.getValue("Name").toString();
            if (test.indexOf(58) == -1 || test.length() != 4 && test.length() != 5) continue;
            availableTimeActions.add(key);
        }
        String scrollTo = MainFrame.mLocalizer.msg("menuinfo.scrollTo", "Scroll to") + ": ";
        for (final int timeMinutes : Settings.propTimeButtons.getIntArray()) {
            int hour = timeMinutes / 60;
            String time = String.valueOf(timeMinutes % 60);
            time = time.length() == 1 ? hour + ":0" + time : hour + ":" + time;
            if (availableTimeActions.contains("#scrollTo" + time)) {
                availableTimeActions.remove("#scrollTo" + time);
                continue;
            }
            this.createAction(time, "#scrollTo" + time, scrollTo + time, IconLoader.getInstance().getIconFromTheme("actions", "scroll-to-specific-time", 16), IconLoader.getInstance().getIconFromTheme("actions", "scroll-to-specific-time", 22), 0, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.getInstance().scrollToTime(timeMinutes, true);
                }
            });
        }
        for (String timeActionId : availableTimeActions) {
            Action action = this.mAvailableActions.remove(timeActionId);
            if (!this.mVisibleActions.contains(action)) continue;
            this.mVisibleActions.remove(action);
        }
    }

    private void createVisibleActions(String[] buttonNames) {
        this.mVisibleActions = new ArrayList();
        for (String buttonName : buttonNames) {
            Action action = this.mAvailableActions.get(buttonName);
            if (action != null) {
                this.mVisibleActions.add(action);
                continue;
            }
            if ("#separator".equals(buttonName)) {
                this.mVisibleActions.add(this.mSeparatorAction);
                continue;
            }
            if ("#glue".equals(buttonName)) {
                this.mVisibleActions.add(this.mGlueAction);
                continue;
            }
            if ("#space".equals(buttonName)) {
                this.mVisibleActions.add(this.mSpaceAction);
                continue;
            }
            if (buttonName.equals("java.searchplugin.SearchPlugin") || buttonName.equals("#search")) {
                this.mVisibleActions.add(this.mAvailableActions.get("searchplugin.SearchPlugin"));
                continue;
            }
            if (buttonName.equals("java.reminderplugin.ReminderPlugin") || buttonName.equals("#reminder") || buttonName.equals("reminderplugin.ReminderPlugin")) {
                try {
                    this.mVisibleActions.add(this.mAvailableActions.get("reminderplugin.ReminderPlugin##reminderListAction"));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                continue;
            }
            if (buttonName.equals("java.favoritesplugin.FavoritesPlugin") || buttonName.equals("#favorite")) {
                this.mVisibleActions.add(this.mAvailableActions.get("favoritesplugin.FavoritesPlugin"));
                continue;
            }
            action = this.mAvailableActions.get("java." + buttonName);
            if (action == null) continue;
            this.mVisibleActions.add(action);
        }
    }

    private void createDefaultVisibleActions() {
        PluginProxy[] pluginProxys;
        InternalPluginProxyIf[] internalPlugins;
        this.mVisibleActions = new ArrayList();
        this.mVisibleActions.add(this.mUpdateAction);
        this.mVisibleActions.add(this.mPluginViewAction);
        this.mVisibleActions.add(this.mSettingsAction);
        this.mVisibleActions.add(this.getSeparatorAction());
        for (InternalPluginProxyIf internalPlugin : internalPlugins = InternalPluginProxyList.getInstance().getAvailableProxys()) {
            if (!(internalPlugin instanceof ButtonActionIf)) continue;
            this.addButtonActionIfToVisibleActions((ButtonActionIf)((Object)internalPlugin));
        }
        this.mVisibleActions.add(this.getSeparatorAction());
        for (PluginProxy pluginProxy : pluginProxys = PluginProxyManager.getInstance().getActivatedPlugins()) {
            this.addButtonActionIfToVisibleActions(pluginProxy);
        }
        this.mVisibleActions.add(this.getGlueAction());
        this.mVisibleActions.add(this.mFilterAction);
        this.mVisibleActions.add(this.getSeparatorAction());
        this.mVisibleActions.add(this.mFontSizeSmallerAction);
        this.mVisibleActions.add(this.mFontSizeLargerAction);
        this.mVisibleActions.add(this.getSeparatorAction());
        this.mVisibleActions.add(this.mGoToPreviousDayAction);
        this.mVisibleActions.add(this.mGoToTodayAction);
        this.mVisibleActions.add(this.mGoToNextDayAction);
        this.mVisibleActions.add(this.mScrollToNowAction);
    }

    private void addButtonActionIfToVisibleActions(ButtonActionIf buttonAction) {
        Action action;
        ActionMenu actionMenu = buttonAction.getButtonAction();
        if (actionMenu != null && !actionMenu.hasSubItems() && (action = this.mAvailableActions.get(buttonAction.getId())) != null && !ContextMenuSeparatorAction.getInstance().equals(action)) {
            this.mVisibleActions.add(action);
        }
    }

    public Action getSeparatorAction() {
        if (this.mSeparatorAction == null) {
            this.mSeparatorAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
            this.mSeparatorAction.putValue("ActionId", "#separator");
            this.mSeparatorAction.putValue("ActionType", 2);
            this.mSeparatorAction.putValue("Name", "Separator");
            this.mSeparatorAction.putValue("BigIcon", new Icon(){

                @Override
                public int getIconHeight() {
                    return 22;
                }

                @Override
                public int getIconWidth() {
                    return 22;
                }

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    int width = c.getWidth();
                    int height = c.getHeight();
                    int xStart = width / 2 - 1;
                    g.setColor(c.getBackground().darker().darker());
                    g.drawLine(xStart, 1, xStart++, height / 2);
                    g.setColor(c.getBackground().brighter());
                    g.drawLine(xStart, 1, xStart, height / 2);
                }
            });
        }
        return this.mSeparatorAction;
    }

    public Action getGlueAction() {
        if (this.mGlueAction == null) {
            this.mGlueAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
            this.mGlueAction.putValue("ActionId", "#glue");
            this.mGlueAction.putValue("ActionType", 4);
            this.mGlueAction.putValue("Name", mLocalizer.msg("flexibleSpace", "Flexible Space"));
            this.mGlueAction.putValue("BigIcon", new Icon(){

                @Override
                public int getIconHeight() {
                    return 22;
                }

                @Override
                public int getIconWidth() {
                    return 22;
                }

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    int width = c.getWidth();
                    int height = c.getHeight();
                    int yMiddle = height / 4 + 2;
                    int xStart = width / 2 - 20;
                    int[] x1Values = new int[]{xStart + 4, xStart + 11, xStart + 11};
                    int[] x2Values = new int[]{xStart + 36, xStart + 29, xStart + 29};
                    int[] yValues = new int[]{yMiddle, yMiddle - 7, yMiddle + 7};
                    g.setColor(c.getBackground().darker().darker());
                    g.drawRect(xStart, 1, 40, height / 2 + 1);
                    g.setColor(c.getBackground().brighter());
                    g.fillRect(xStart + 1, 2, 38, height / 2 - 1);
                    g.setColor(Color.gray);
                    g.fillPolygon(x1Values, yValues, 3);
                    g.fillPolygon(x2Values, yValues, 3);
                    for (int i = 0; i < 4; ++i) {
                        g.drawRect(xStart + 13 + 4 * i, yMiddle, 1, 1);
                    }
                }
            });
        }
        return this.mGlueAction;
    }

    public Action getSpaceAction() {
        if (this.mSpaceAction == null) {
            this.mSpaceAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
            this.mSpaceAction.putValue("ActionId", "#space");
            this.mSpaceAction.putValue("ActionType", 3);
            this.mSpaceAction.putValue("Name", mLocalizer.msg("space", "Space"));
            this.mSpaceAction.putValue("BigIcon", new Icon(){

                @Override
                public int getIconHeight() {
                    return 22;
                }

                @Override
                public int getIconWidth() {
                    return 22;
                }

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    int width = c.getWidth();
                    int height = c.getHeight();
                    int xStart = width / 2 - 10;
                    g.setColor(c.getBackground().darker().darker());
                    g.drawRect(xStart, 1, 20, height / 2 + 1);
                    g.setColor(c.getBackground().brighter());
                    g.fillRect(xStart + 1, 2, 18, height / 2 - 1);
                }
            });
        }
        return this.mSpaceAction;
    }

    private Action createAction(String name, String id, String description, Icon smallIcon, Icon bigIcon, int type, final ActionListener listener) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.actionPerformed(new ActionEvent(this, e.getID(), e.getActionCommand()));
            }
        };
        action.putValue("Name", name);
        action.putValue("SmallIcon", smallIcon);
        action.putValue("BigIcon", bigIcon);
        action.putValue("ShortDescription", description);
        action.putValue("ActionType", type);
        action.putValue("ActionId", id);
        this.mAvailableActions.put(id, action);
        this.actionOrder.add(action);
        return action;
    }

    private Action createAction(TVBrowserAction action) {
        this.mAvailableActions.put(action.getToolbarIdentifier(), action);
        this.actionOrder.add(action);
        return action;
    }

    @Override
    public Action[] getActions() {
        Action[] result = new Action[this.mVisibleActions.size()];
        this.mVisibleActions.toArray(result);
        return result;
    }

    @Override
    public Action[] getAvailableActions() {
        ArrayList<Action> orderedList = new ArrayList<Action>(this.actionOrder);
        for (Action action : this.mAvailableActions.values()) {
            if (orderedList.contains(action)) continue;
            orderedList.add(action);
        }
        Action[] result = new Action[this.mAvailableActions.size()];
        orderedList.toArray(result);
        return result;
    }

    public void store() {
    }

    protected Action getUpdateAction() {
        return this.mUpdateAction;
    }

    protected void showStopButton() {
        this.mUpdateAction.putValue("Name", TVBrowserActions.update.getToolbarText());
        this.mUpdateAction.putValue("SmallIcon", IconLoader.getInstance().getIconFromTheme("actions", "process-stop", 16));
        this.mUpdateAction.putValue("BigIcon", IconLoader.getInstance().getIconFromTheme("actions", "process-stop", 22));
        this.mUpdateAction.putValue("ShortDescription", MainFrame.mLocalizer.msg("menuinfo.stop", ""));
    }

    protected void showUpdateButton() {
        this.mUpdateAction.putValue("Name", TVBrowserActions.update.getToolbarText());
        this.mUpdateAction.putValue("SmallIcon", IconLoader.getInstance().getIconFromTheme("apps", "system-software-update", 16));
        this.mUpdateAction.putValue("BigIcon", IconLoader.getInstance().getIconFromTheme("apps", "system-software-update", 22));
        this.mUpdateAction.putValue("ShortDescription", MainFrame.mLocalizer.msg("menuinfo.update", ""));
    }

    void showPopupMenu(final Action item) {
        ScrollableMenu menu;
        final AbstractButton btn = (AbstractButton)item.getValue("ActionValue");
        JPopupMenu popup = null;
        if (item == this.mFilterAction) {
            menu = new SelectFilterPopup(MainFrame.getInstance());
            popup = menu.getPopupMenu();
        } else if (item == this.mGoToDateAction) {
            popup = new JPopupMenu();
            Date curDate = Date.getCurrentDate().addDays(-1);
            if (TvDataBase.getInstance().dataAvailable(curDate)) {
                popup.add(this.createDateMenuItem(curDate));
            }
            curDate = curDate.addDays(1);
            Date maxDate = TvDataBase.getInstance().getMaxSupportedDate();
            while (maxDate.getNumberOfDaysSince(curDate) >= 0 && TvDataBase.getInstance().dataAvailable(curDate)) {
                if (curDate.isFirstDayOfWeek()) {
                    popup.addSeparator();
                }
                popup.add(this.createDateMenuItem(curDate));
                curDate = curDate.addDays(1);
            }
        } else if (item == this.mScrollToChannelAction) {
            menu = new ScrollableMenu();
            popup = menu.getPopupMenu();
            Channel[] channels = Settings.propSubscribedChannels.getChannelArray();
            int lastSeparatorIndex = 0;
            String[] separatorArr = Settings.propSubscribedChannelsSeparators.getStringArray();
            Channel previousChannel = null;
            for (int i = 0; i < channels.length; ++i) {
                for (int j = lastSeparatorIndex; j < separatorArr.length; ++j) {
                    String separator = separatorArr[j];
                    if (!separator.endsWith(channels[i].getUniqueId()) || previousChannel == null || !separator.startsWith(previousChannel.getUniqueId())) continue;
                    menu.addSeparator();
                    lastSeparatorIndex = j + 1;
                }
                previousChannel = channels[i];
                menu.add(this.createChannelMenuItem(channels[i], btn));
                if (channels[i].getJointChannel() == null) continue;
                ++i;
            }
        } else if (item == this.mScrollToTimeAction) {
            int[] array;
            popup = new JPopupMenu();
            for (int element : array = Settings.propTimeButtons.getIntArray()) {
                popup.add(this.createTimeMenuItem(element, btn));
            }
            if (popup.getComponentCount() > 0) {
                popup.addSeparator();
            }
            JMenuItem menuItem = new JMenuItem(TVBrowserActions.scrollToNow.getValue("Name").toString());
            menuItem.setHorizontalTextPosition(0);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.getInstance().scrollToNow();
                    btn.setSelected(false);
                    MainFrame.getInstance().updateToolbar();
                }
            });
            popup.add(menuItem);
        }
        if (popup != null) {
            popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    AbstractButton button = (AbstractButton)item.getValue("ActionValue");
                    if (item == DefaultToolBarModel.this.mFilterAction) {
                        button.setSelected(!FilterManagerImpl.getInstance().getCurrentFilter().equals(FilterManagerImpl.getInstance().getDefaultFilter()));
                        DefaultToolBarModel.this.setFilterButtonSelected(button.isSelected());
                    }
                    if (item == DefaultToolBarModel.this.mGoToDateAction) {
                        button.setSelected(false);
                    }
                    MainFrame.getInstance().updateToolbar();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }
            });
            Point p = new Point(0, 0);
            p.y = btn.getHeight() + 1;
            popup.show(btn, p.x, p.y);
        }
    }

    private JMenuItem createDateMenuItem(final Date date) {
        String buttonText = date.equals(Date.getCurrentDate().addDays(-1)) ? Localizer.getLocalization("i18n_yesterday") : (date.equals(Date.getCurrentDate()) ? Localizer.getLocalization("i18n_today") : (date.equals(Date.getCurrentDate().addDays(1)) ? Localizer.getLocalization("i18n_tomorrow") : date.toString()));
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(buttonText);
        if (MainFrame.getInstance().getProgramTableModel().getDate().equals(date)) {
            item.setFont(item.getFont().deriveFont(1));
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().goTo(date);
            }
        });
        return item;
    }

    private JMenuItem createChannelMenuItem(final Channel ch, final AbstractButton btn) {
        JMenuItem item = new JMenuItem();
        StringBuilder text = new StringBuilder();
        if (Settings.propShowSortNumberInProgramLists.getBoolean() && ch.getSortNumber().trim().length() > 0) {
            text.append(ch.getSortNumber()).append(". ");
        }
        if (Settings.propShowChannelNamesInChannellist.getBoolean()) {
            text.append(ch.getJointChannel() != null ? ch.getJointChannelName() : ch.getName());
        }
        item.setText(text.toString());
        if (Settings.propShowChannelIconsInChannellist.getBoolean()) {
            item.setIcon(UiUtilities.createChannelIcon(ch.getJointChannel() != null ? ch.getJointChannelIcon() : ch.getIcon()));
            item.setPreferredSize(new Dimension(item.getPreferredSize().width, item.getIcon().getIconHeight()));
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().showChannel(ch);
                btn.setSelected(false);
                MainFrame.getInstance().updateToolbar();
            }
        });
        return item;
    }

    private JMenuItem createTimeMenuItem(final int time, final AbstractButton btn) {
        String minute = String.valueOf(time % 60);
        String hour = String.valueOf(time / 60);
        if (minute.length() == 1) {
            minute = "0" + minute;
        }
        if (hour.length() == 1) {
            hour = "0" + hour;
        }
        JMenuItem item = new JMenuItem(hour + ":" + minute);
        item.setHorizontalTextPosition(0);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().scrollToTime(time, true);
                btn.setSelected(false);
                MainFrame.getInstance().updateToolbar();
            }
        });
        return item;
    }

    @Override
    public void dateChanged(final Date date, ProgressMonitor monitor, Runnable callback, boolean informPluginPanels) {
        UIThreadRunner.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultToolBarModel.this.mGoToPreviousDayAction.setEnabled(TvDataBase.getInstance().dataAvailable(date.addDays(-1)));
                DefaultToolBarModel.this.mGoToNextDayAction.setEnabled(TvDataBase.getInstance().dataAvailable(date.addDays(1)));
                DefaultToolBarModel.this.mGoToPreviousWeekAction.setEnabled(TvDataBase.getInstance().dataAvailable(date.addDays(-7)));
                DefaultToolBarModel.this.mGoToNextWeekAction.setEnabled(TvDataBase.getInstance().dataAvailable(date.addDays(7)));
            }
        });
    }

    @Override
    public void dateChanged(Date date, ProgressMonitor monitor, Runnable callback) {
        this.dateChanged(date, monitor, callback, false);
    }
}

