/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.settings.TrayBaseSettingsTab;
import tvbrowser.ui.settings.TrayProgramsChannelsSettingsTab;
import tvbrowser.ui.settings.util.ColorButton;
import tvbrowser.ui.settings.util.ColorLabel;
import util.ui.Localizer;
import util.ui.UiUtilities;

public class TrayOnTimeSettingsTab
implements SettingsTab {
    private JCheckBox mIsEnabled;
    private JCheckBox mShowTime;
    private JCheckBox mShowToolTip;
    private JCheckBox mShowProgress;
    private JRadioButton mShowInSubMenu;
    private JRadioButton mShowInTray;
    private static final Localizer mLocalizer = TrayBaseSettingsTab.mLocalizer;
    private JLabel mIconSeparator;
    private JLabel mSeparator1;
    private JLabel mSeparator2;
    private JLabel mDarkLabel;
    private JLabel mLightLabel;
    private static boolean mTrayIsEnabled = Settings.propTrayIsEnabled.getBoolean();
    private JEditorPane mHelpLabel;
    private JEditorPane mInfo;
    private JEditorPane mTimeHelp;
    private JRadioButton mShowIconAndName;
    private JRadioButton mShowName;
    private JRadioButton mShowIcon;
    private JCheckBox mShowSortNumber;
    private ColorLabel mLightColorLb;
    private ColorLabel mDarkColorLb;
    private ColorButton mLight;
    private ColorButton mDark;
    private static TrayOnTimeSettingsTab mInstance;

    @Override
    public JPanel createSettingsPanel() {
        mInstance = this;
        PanelBuilder builder = new PanelBuilder(new FormLayout("5dlu,12dlu,pref:grow,5dlu", "pref,5dlu,pref,pref,pref,5dlu,pref,10dlu,pref,5dlu,pref,pref,pref,5dlu,pref,10dlu,pref,5dlu,pref,pref,pref,3dlu,pref,5dlu,pref,fill:pref:grow,pref"));
        builder.border(Borders.DIALOG);
        this.mIsEnabled = new JCheckBox(mLocalizer.msg("onTimeEnabled", "Show programs at..."), Settings.propTrayOnTimeProgramsEnabled.getBoolean());
        ButtonGroup bg = new ButtonGroup();
        this.mShowInSubMenu = new JRadioButton(mLocalizer.msg("inSubMenu", "in a sub menu"), Settings.propTrayOnTimeProgramsInSubMenu.getBoolean());
        this.mShowInTray = new JRadioButton(mLocalizer.msg("inTray", "in the tray menu"), !this.mShowInSubMenu.isSelected());
        bg.add(this.mShowInSubMenu);
        bg.add(this.mShowInTray);
        this.mShowIconAndName = new JRadioButton(mLocalizer.msg("showIconName", "Show channel icon and channel name"), Settings.propTrayOnTimeProgramsContainsName.getBoolean() && Settings.propTrayOnTimeProgramsContainsIcon.getBoolean());
        this.mShowIcon = new JRadioButton(mLocalizer.msg("showIcon", "Show channel icon"), Settings.propTrayOnTimeProgramsContainsIcon.getBoolean() && !Settings.propTrayOnTimeProgramsContainsName.getBoolean());
        this.mShowName = new JRadioButton(mLocalizer.msg("showName", "Show channel name"), !Settings.propTrayOnTimeProgramsContainsIcon.getBoolean() && Settings.propTrayOnTimeProgramsContainsName.getBoolean());
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.mShowIconAndName);
        bg1.add(this.mShowIcon);
        bg1.add(this.mShowName);
        this.mShowSortNumber = new JCheckBox(mLocalizer.msg("showChannelNumber", "Show sort number"), Settings.propTrayOnTimeProgramsShowingSortNumber.getBoolean());
        this.mShowTime = new JCheckBox(mLocalizer.msg("showTime", "Show start time"), Settings.propTrayOnTimeProgramsContainsTime.getBoolean());
        this.mShowToolTip = new JCheckBox(mLocalizer.msg("showToolTip", "Show additional information of the program in a tool tip"), Settings.propTrayOnTimeProgramsContainsToolTip.getBoolean());
        this.mShowToolTip.setToolTipText(mLocalizer.msg("toolTipTip", "Tool tips are small helper to something, like this one."));
        this.mShowProgress = new JCheckBox(mLocalizer.msg("showProgress", "Show progress bar"), Settings.propTrayOnTimeProgramsShowProgress.getBoolean());
        this.mLightColorLb = new ColorLabel(Settings.propTrayOnTimeProgramsLightBackground.getColor());
        this.mLightColorLb.setStandardColor(Settings.propTrayOnTimeProgramsLightBackground.getDefaultColor());
        this.mDarkColorLb = new ColorLabel(Settings.propTrayOnTimeProgramsDarkBackground.getColor());
        this.mDarkColorLb.setStandardColor(Settings.propTrayOnTimeProgramsDarkBackground.getDefaultColor());
        this.mTimeHelp = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("helpTime", "If you want to change the times of this view, you simply have to change the times of the <a href=\"#link\">time buttons</a>."), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SettingsDialog.getInstance().showSettingsTab("#timebuttons");
                }
            }
        });
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("help", "The Tray is deactivated. To activate these settings activate the option <b>Tray activated</b> in the <a href=\"#link\">Tray Base settings</a>."), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SettingsDialog.getInstance().showSettingsTab("#tray");
                }
            }
        });
        this.mInfo = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("trayProgressInfo", "The progress bar simulates the progress of the program if the time would be reached."));
        this.mLight = new ColorButton(this.mLightColorLb);
        this.mDark = new ColorButton(this.mDarkColorLb);
        PanelBuilder colors = new PanelBuilder(new FormLayout("default,5dlu,default,5dlu,default", "pref,2dlu,pref"));
        this.mDarkLabel = colors.addLabel(mLocalizer.msg("progressLight", "Background color of the programs at..."), CC.xy(1, 1));
        colors.add((Component)this.mLightColorLb, CC.xy(3, 1));
        colors.add((Component)this.mLight, CC.xy(5, 1));
        this.mLightLabel = colors.addLabel(mLocalizer.msg("progressDark", "Progress color of the programs at..."), CC.xy(1, 3));
        colors.add((Component)this.mDarkColorLb, CC.xy(3, 3));
        colors.add((Component)this.mDark, CC.xy(5, 3));
        JPanel c = (JPanel)builder.addSeparator(mLocalizer.msg("onTime", "Programs at..."), CC.xyw(1, 1, 4));
        builder.add((Component)this.mIsEnabled, CC.xyw(2, 3, 2));
        builder.add((Component)this.mShowInTray, CC.xy(3, 4));
        builder.add((Component)this.mShowInSubMenu, CC.xy(3, 5));
        builder.add((Component)this.mTimeHelp, CC.xyw(2, 7, 2));
        JPanel c1 = (JPanel)builder.addSeparator(mLocalizer.msg("iconNameSeparator", "Channel icons/channel name"), CC.xyw(1, 9, 4));
        builder.add((Component)this.mShowIconAndName, CC.xyw(2, 11, 2));
        builder.add((Component)this.mShowIcon, CC.xyw(2, 12, 2));
        builder.add((Component)this.mShowName, CC.xyw(2, 13, 2));
        builder.add((Component)this.mShowSortNumber, CC.xyw(2, 15, 2));
        JPanel c2 = (JPanel)builder.addSeparator(mLocalizer.msg("settings", "Settings"), CC.xyw(1, 17, 4));
        builder.add((Component)this.mShowTime, CC.xyw(2, 19, 2));
        builder.add((Component)this.mShowToolTip, CC.xyw(2, 20, 2));
        builder.add((Component)this.mShowProgress, CC.xyw(2, 21, 2));
        builder.add((Component)colors.getPanel(), CC.xy(3, 23));
        builder.add((Component)this.mInfo, CC.xyw(2, 25, 2));
        builder.add((Component)this.mHelpLabel, CC.xyw(1, 27, 4));
        this.mSeparator1 = (JLabel)c.getComponent(0);
        this.mIconSeparator = (JLabel)c1.getComponent(0);
        this.mSeparator2 = (JLabel)c2.getComponent(0);
        this.setEnabled(true);
        this.mIsEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayOnTimeSettingsTab.this.setEnabled(false);
            }
        });
        this.mShowProgress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayOnTimeSettingsTab.this.mLightColorLb.setEnabled(TrayOnTimeSettingsTab.this.mIsEnabled.isSelected() && TrayOnTimeSettingsTab.this.mShowProgress.isSelected());
                TrayOnTimeSettingsTab.this.mDarkColorLb.setEnabled(TrayOnTimeSettingsTab.this.mIsEnabled.isSelected() && TrayOnTimeSettingsTab.this.mShowProgress.isSelected());
                TrayOnTimeSettingsTab.this.mLight.setEnabled(TrayOnTimeSettingsTab.this.mIsEnabled.isSelected() && TrayOnTimeSettingsTab.this.mShowProgress.isSelected());
                TrayOnTimeSettingsTab.this.mDark.setEnabled(TrayOnTimeSettingsTab.this.mIsEnabled.isSelected() && TrayOnTimeSettingsTab.this.mShowProgress.isSelected());
                TrayOnTimeSettingsTab.this.mDarkLabel.setEnabled(TrayOnTimeSettingsTab.this.mIsEnabled.isSelected() && TrayOnTimeSettingsTab.this.mShowProgress.isSelected());
                TrayOnTimeSettingsTab.this.mLightLabel.setEnabled(TrayOnTimeSettingsTab.this.mIsEnabled.isSelected() && TrayOnTimeSettingsTab.this.mShowProgress.isSelected());
                TrayOnTimeSettingsTab.this.mInfo.setEnabled(TrayOnTimeSettingsTab.this.mIsEnabled.isSelected() && TrayOnTimeSettingsTab.this.mShowProgress.isSelected());
            }
        });
        return builder.getPanel();
    }

    private void setEnabled(boolean trayStateChange) {
        this.mHelpLabel.setVisible(!mTrayIsEnabled);
        if (trayStateChange) {
            this.mSeparator1.setEnabled(mTrayIsEnabled);
            this.mIsEnabled.setEnabled(mTrayIsEnabled);
        }
        TrayProgramsChannelsSettingsTab.setOnTimeIsEnabled(this.mIsEnabled.isSelected());
        this.mSeparator2.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowInSubMenu.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowInTray.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mIconSeparator.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mTimeHelp.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowName.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowIconAndName.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowIcon.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowTime.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowToolTip.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mShowProgress.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
        this.mLightColorLb.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mDarkColorLb.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mLight.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mDark.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mDarkLabel.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mLightLabel.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mInfo.setEnabled(this.mIsEnabled.isSelected() && this.mShowProgress.isSelected() && mTrayIsEnabled);
        this.mShowSortNumber.setEnabled(this.mIsEnabled.isSelected() && mTrayIsEnabled);
    }

    @Override
    public void saveSettings() {
        if (this.mIsEnabled != null) {
            Settings.propTrayOnTimeProgramsEnabled.setBoolean(this.mIsEnabled.isSelected());
        }
        if (this.mShowInSubMenu != null) {
            Settings.propTrayOnTimeProgramsInSubMenu.setBoolean(this.mShowInSubMenu.isSelected());
        }
        if (this.mShowIconAndName != null && this.mShowName != null && this.mShowIcon != null) {
            Settings.propTrayOnTimeProgramsContainsName.setBoolean(this.mShowIconAndName.isSelected() || this.mShowName.isSelected());
            Settings.propTrayOnTimeProgramsContainsIcon.setBoolean(this.mShowIconAndName.isSelected() || this.mShowIcon.isSelected());
        }
        if (this.mShowTime != null) {
            Settings.propTrayOnTimeProgramsContainsTime.setBoolean(this.mShowTime.isSelected());
        }
        if (this.mShowToolTip != null) {
            Settings.propTrayOnTimeProgramsContainsToolTip.setBoolean(this.mShowToolTip.isSelected());
        }
        if (this.mShowProgress != null) {
            Settings.propTrayOnTimeProgramsShowProgress.setBoolean(this.mShowProgress.isSelected());
        }
        if (this.mLightColorLb != null) {
            Settings.propTrayOnTimeProgramsLightBackground.setColor(this.mLightColorLb.getColor());
        }
        if (this.mDarkColorLb != null) {
            Settings.propTrayOnTimeProgramsDarkBackground.setColor(this.mDarkColorLb.getColor());
        }
        if (this.mShowSortNumber != null) {
            Settings.propTrayOnTimeProgramsShowingSortNumber.setBoolean(this.mShowSortNumber.isSelected());
        }
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return TrayOnTimeSettingsTab.getName();
    }

    public static String getName() {
        return mLocalizer.msg("onTime", "Programs at...");
    }

    protected static void setTrayIsEnabled(boolean value) {
        mTrayIsEnabled = value;
        if (mInstance != null) {
            mInstance.setEnabled(true);
        }
    }
}

