/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.tablebackgroundstyles;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.ProgramTableSettingsTab;
import tvbrowser.ui.settings.tablebackgroundstyles.TableBackgroundStyle;
import util.ui.Localizer;
import util.ui.TabLayout;

public class DayTimeBackgroundStyle
implements TableBackgroundStyle {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(DayTimeBackgroundStyle.class);
    private JTextField mTimeOfDayEdgeTF;
    private JTextField mTimeOfDayEarlyTF;
    private JTextField mTimeOfDayMiddayTF;
    private JTextField mTimeOfDayAfternoonTF;
    private JTextField mTimeOfDayEveningTF;
    private JPanel mContent;

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public JPanel createSettingsContent() {
        this.mContent = new JPanel(new TabLayout(3));
        this.mContent.add(new JLabel(mLocalizer.msg("timeOfDay.edge", "Edge")));
        this.mTimeOfDayEdgeTF = new JTextField(Settings.propTimeOfDayBackgroundEdge.getString(), 25);
        this.mContent.add(this.mTimeOfDayEdgeTF);
        this.mContent.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeOfDayEdgeTF));
        this.mContent.add(new JLabel(mLocalizer.msg("timeOfDay.early", "Early")));
        this.mTimeOfDayEarlyTF = new JTextField(Settings.propTimeOfDayBackgroundEarly.getString(), 25);
        this.mContent.add(this.mTimeOfDayEarlyTF);
        this.mContent.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeOfDayEarlyTF));
        this.mContent.add(new JLabel(mLocalizer.msg("timeOfDay.midday", "Midday")));
        this.mTimeOfDayMiddayTF = new JTextField(Settings.propTimeOfDayBackgroundMidday.getString(), 25);
        this.mContent.add(this.mTimeOfDayMiddayTF);
        this.mContent.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeOfDayMiddayTF));
        this.mContent.add(new JLabel(mLocalizer.msg("timeOfDay.afternoon", "Afternoon")));
        this.mTimeOfDayAfternoonTF = new JTextField(Settings.propTimeOfDayBackgroundAfternoon.getString(), 25);
        this.mContent.add(this.mTimeOfDayAfternoonTF);
        this.mContent.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeOfDayAfternoonTF));
        this.mContent.add(new JLabel(mLocalizer.msg("timeOfDay.evening", "Evening")));
        this.mTimeOfDayEveningTF = new JTextField(Settings.propTimeOfDayBackgroundEvening.getString(), 25);
        this.mContent.add(this.mTimeOfDayEveningTF);
        this.mContent.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeOfDayEveningTF));
        return this.mContent;
    }

    @Override
    public void storeSettings() {
        if (this.mContent == null) {
            return;
        }
        Settings.propTimeOfDayBackgroundEdge.setString(this.mTimeOfDayEdgeTF.getText());
        Settings.propTimeOfDayBackgroundEarly.setString(this.mTimeOfDayEarlyTF.getText());
        Settings.propTimeOfDayBackgroundMidday.setString(this.mTimeOfDayMiddayTF.getText());
        Settings.propTimeOfDayBackgroundAfternoon.setString(this.mTimeOfDayAfternoonTF.getText());
        Settings.propTimeOfDayBackgroundEvening.setString(this.mTimeOfDayEveningTF.getText());
    }

    @Override
    public String getName() {
        return mLocalizer.msg("style", "Day time");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getSettingsString() {
        return "timeOfDay";
    }
}

