/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.tablebackgroundstyles;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.ProgramTableSettingsTab;
import tvbrowser.ui.settings.tablebackgroundstyles.TableBackgroundStyle;
import util.ui.Localizer;
import util.ui.TabLayout;

public class TimeBlockBackgroundStyle
implements TableBackgroundStyle {
    public static final Localizer mLocalizer = Localizer.getLocalizerFor(TimeBlockBackgroundStyle.class);
    private JSpinner mTimeBlockSizeSp;
    private JTextField mTimeBlockBackground1TF;
    private JTextField mTimeBlockBackground2TF;
    private JTextField mTimeBlockWestImage1TF;
    private JTextField mTimeBlockWestImage2TF;
    private JCheckBox mTimeBlockShowWestChB;
    private JLabel mTimeBlockWestImage1Lb;
    private JLabel mTimeBlockWestImage2Lb;
    private JButton mTimeBlockWestImage1Bt;
    private JButton mTimeBlockWestImage2Bt;
    private JPanel mContent;

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public JPanel createSettingsContent() {
        this.mContent = new JPanel(new TabLayout(1));
        JPanel p1 = new JPanel(new FlowLayout(3));
        this.mContent.add(p1);
        p1.add(new JLabel(mLocalizer.msg("timeBlock.blockSize", "Block size")));
        this.mTimeBlockSizeSp = new JSpinner(new SpinnerNumberModel(Settings.propTimeBlockSize.getInt(), 1, 23, 1));
        p1.add(this.mTimeBlockSizeSp);
        p1.add(new JLabel(mLocalizer.msg("timeBlock.hours", "hours")));
        p1 = new JPanel(new TabLayout(3));
        this.mContent.add(p1);
        p1.add(new JLabel(mLocalizer.msg("timeBlock.background1", "Image 1")));
        this.mTimeBlockBackground1TF = new JTextField(Settings.propTimeBlockBackground1.getString(), 25);
        p1.add(this.mTimeBlockBackground1TF);
        p1.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeBlockBackground1TF));
        p1.add(new JLabel(mLocalizer.msg("timeBlock.background2", "Image 2")));
        this.mTimeBlockBackground2TF = new JTextField(Settings.propTimeBlockBackground2.getString(), 25);
        p1.add(this.mTimeBlockBackground2TF);
        p1.add(ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeBlockBackground2TF));
        this.mTimeBlockShowWestChB = new JCheckBox(mLocalizer.msg("timeBlock.showWest", "Show left border"), Settings.propTimeBlockShowWest.getBoolean());
        this.mTimeBlockShowWestChB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeBlockBackgroundStyle.this.handleTimeBlockShowWest();
            }
        });
        this.mContent.add(this.mTimeBlockShowWestChB);
        this.mTimeBlockShowWestChB.setSelected(Settings.propTimeBlockShowWest.getBoolean());
        p1 = new JPanel(new TabLayout(3));
        this.mContent.add(p1);
        this.mTimeBlockWestImage1Lb = new JLabel(mLocalizer.msg("timeBlock.west1", "Border image 1"));
        p1.add(this.mTimeBlockWestImage1Lb);
        this.mTimeBlockWestImage1TF = new JTextField(Settings.propTimeBlockWestImage1.getString(), 25);
        p1.add(this.mTimeBlockWestImage1TF);
        this.mTimeBlockWestImage1Bt = ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeBlockWestImage1TF);
        p1.add(this.mTimeBlockWestImage1Bt);
        this.mTimeBlockWestImage2Lb = new JLabel(mLocalizer.msg("timeBlock.west2", "Border image 2"));
        p1.add(this.mTimeBlockWestImage2Lb);
        this.mTimeBlockWestImage2TF = new JTextField(Settings.propTimeBlockWestImage2.getString(), 25);
        p1.add(this.mTimeBlockWestImage2TF);
        this.mTimeBlockWestImage2Bt = ProgramTableSettingsTab.createBrowseButton(this.mContent, this.mTimeBlockWestImage2TF);
        p1.add(this.mTimeBlockWestImage2Bt);
        return this.mContent;
    }

    private void handleTimeBlockShowWest() {
        boolean enabled = this.mTimeBlockShowWestChB.isSelected();
        this.mTimeBlockWestImage1Lb.setEnabled(enabled);
        this.mTimeBlockWestImage1TF.setEnabled(enabled);
        this.mTimeBlockWestImage1Bt.setEnabled(enabled);
        this.mTimeBlockWestImage2Lb.setEnabled(enabled);
        this.mTimeBlockWestImage2TF.setEnabled(enabled);
        this.mTimeBlockWestImage2Bt.setEnabled(enabled);
    }

    @Override
    public void storeSettings() {
        if (this.mContent == null) {
            return;
        }
        Integer blockSize = (Integer)this.mTimeBlockSizeSp.getValue();
        Settings.propTimeBlockSize.setInt(blockSize);
        Settings.propTimeBlockBackground1.setString(this.mTimeBlockBackground1TF.getText());
        Settings.propTimeBlockBackground2.setString(this.mTimeBlockBackground2TF.getText());
        Settings.propTimeBlockShowWest.setBoolean(this.mTimeBlockShowWestChB.isSelected());
        Settings.propTimeBlockWestImage1.setString(this.mTimeBlockWestImage1TF.getText());
        Settings.propTimeBlockWestImage2.setString(this.mTimeBlockWestImage2TF.getText());
    }

    @Override
    public String getName() {
        return mLocalizer.msg("style", "Time block");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getSettingsString() {
        return "timeBlock";
    }
}

