/*
 * Decompiled with CFR 0.152.
 */
package util.misc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;
import util.io.ExecutionHandler;

public class AppleScriptRunner {
    private static final Logger mLog = Logger.getLogger(AppleScriptRunner.class.getName());
    private int mTimeOut = 60;

    public AppleScriptRunner() {
    }

    public AppleScriptRunner(int timeout) {
        this.mTimeOut = timeout;
    }

    public String executeScript(String script) throws IOException {
        int time;
        mLog.info("Applescript start:");
        mLog.info(script);
        File scriptFile = File.createTempFile("osascript", "temp");
        scriptFile.deleteOnExit();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(scriptFile), "UTF-8");
        writer.write(script);
        writer.close();
        ExecutionHandler executionHandler = new ExecutionHandler(scriptFile.getAbsolutePath(), "osascript");
        executionHandler.execute(true, "UTF-8");
        if (this.mTimeOut > 0) {
            for (time = 0; time < this.mTimeOut * 1000; time += 100) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                try {
                    executionHandler.exitValue();
                    break;
                }
                catch (IllegalThreadStateException e) {
                    continue;
                }
            }
        } else {
            while (true) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                try {
                    executionHandler.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    continue;
                }
                break;
            }
        }
        while (time < this.mTimeOut * 1000) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            time += 100;
            try {
                executionHandler.exitValue();
                break;
            }
            catch (IllegalThreadStateException e) {
            }
        }
        String output = "";
        if (!executionHandler.getInputStreamReaderThread().isAlive()) {
            output = executionHandler.getOutput();
        }
        mLog.info("AppleScript Output:");
        mLog.info(output);
        if (executionHandler.exitValue() >= 0) {
            return output;
        }
        try {
            scriptFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String formatTextAsParam(String string) {
        return string.replaceAll("\"", "\\\"").replace('\n', ' ');
    }
}

