/*
 * Decompiled with CFR 0.152.
 */
package util.misc;

import java.util.HashMap;
import java.util.Properties;

public class PropertyDefaults {
    private HashMap<String, String> mDefaultValueMap;
    private Properties mProperties;

    public PropertyDefaults(HashMap<String, String> defaultValueMap) {
        this.mDefaultValueMap = defaultValueMap;
    }

    public void setProperties(Properties properties) {
        this.mProperties = properties;
    }

    public String getValueFromProperties(String key) {
        return this.getValueFromProperties(key, null);
    }

    public String getValueFromProperties(String key, Properties properties) {
        if (key != null) {
            if (properties != null) {
                return properties.getProperty(key, this.mDefaultValueMap.get(key));
            }
            if (this.mProperties != null) {
                return this.mProperties.getProperty(key, this.mDefaultValueMap.get(key));
            }
            return this.mDefaultValueMap.get(key);
        }
        return null;
    }

    public String getDefaultValueForKey(String key) {
        if (key != null) {
            return this.mDefaultValueMap.get(key);
        }
        return null;
    }

    public Properties getProperties() {
        return this.mProperties;
    }
}

