/*
 * Decompiled with CFR 0.152.
 */
package util.paramhandler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import util.paramhandler.ParamLibrary;
import util.ui.Localizer;
import util.ui.UiUtilities;

public class ParamDescriptionPanel
extends JPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ParamDescriptionPanel.class);

    public ParamDescriptionPanel() {
        this(new ParamLibrary());
    }

    public ParamDescriptionPanel(ParamLibrary lib) {
        this.createGui(lib);
    }

    private void createGui(ParamLibrary lib) {
        this.setLayout(new BorderLayout());
        JEditorPane helpPanel = new JEditorPane();
        helpPanel.setEditable(false);
        helpPanel.setContentType("text/html");
        StringBuilder text = new StringBuilder("<html> <head><style type=\"text/css\" media=\"screen\"><!--body {font-family:Dialog;}--></style>  </head><body><b>" + mLocalizer.msg("possibleParameters", "Possible Parameters") + ":</b>\n\n" + "<table>");
        List<String> params = Arrays.asList(lib.getPossibleKeys());
        Collections.sort(params);
        for (String param : params) {
            text.append("<tr><td valign='top'>{");
            text.append(param);
            text.append("}</td><td>");
            text.append(lib.getDescriptionForKey(param));
            text.append("</td></tr>");
        }
        text.append("</table> <br>\n\n<b>" + mLocalizer.msg("possibleFunctions", "Possible Functions") + ":</b>\n\n<table>");
        List<String> functions = Arrays.asList(lib.getPossibleFunctions());
        Collections.sort(functions);
        for (String function : functions) {
            text.append("<tr><td valign='top'>");
            text.append(function);
            text.append("</td><td>");
            text.append(lib.getDescriptionForFunctions(function));
            text.append("</td></tr>");
        }
        text.append("</table></body></html>");
        UiUtilities.updateHtmlHelpTextArea(helpPanel, text.toString(), UIManager.getColor("List.background"));
        final JScrollPane spane = new JScrollPane(helpPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                spane.getVerticalScrollBar().setValue(0);
            }
        });
        this.add((Component)spane, "Center");
    }
}

