/*
 * Decompiled with CFR 0.152.
 */
package util.paramhandler;

import com.l2fprod.util.StringUtils;
import devplugin.Program;
import devplugin.ProgramFieldType;
import java.io.StringReader;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import util.misc.TextLineBreakerStringWidth;
import util.ui.Localizer;

public class ParamLibrary {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ParamLibrary.class);
    private boolean mError = false;
    private String mErrorString = "";

    public boolean hasErrors() {
        return this.mError;
    }

    public void setErrors(boolean errors) {
        this.mError = errors;
    }

    public String getErrorString() {
        return this.mErrorString;
    }

    public void setErrorString(String error) {
        this.mErrorString = error;
    }

    public String[] getPossibleKeys() {
        String[] str = new String[]{"title", "original_title", "start_day", "start_month", "start_year", "start_hour", "start_minute", "end_month", "end_year", "end_day", "end_hour", "end_minute", "length_minutes", "length_sec", "short_info", "description", "episode", "original_episode", "episode_number", "channel_name", "channel_sort_number", "url", "start_day_of_week", "start_month_name", "genre", "start_unix", "end_unix", "custom", "production_year", "actors", "origin"};
        return str;
    }

    public String getDescriptionForKey(String key) {
        String translation = mLocalizer.msg("parameter_" + key, "");
        if (translation.startsWith("[ParamLibrary.parameter")) {
            return mLocalizer.msg("noDescription", "No Description available");
        }
        return translation;
    }

    public String[] getPossibleFunctions() {
        String[] str = new String[]{"isset", "urlencode", "concat", "clean", "cleanLess", "leadingZero", "splitAt", "testparam", "maxlength", "replace"};
        return str;
    }

    public String getDescriptionForFunctions(String function) {
        String translation = mLocalizer.msg("function_" + function, "");
        if (translation.startsWith("[ParamLibrary.function")) {
            return mLocalizer.msg("noDescription", "No Description available");
        }
        return translation;
    }

    public String getStringForKey(Program program, String key) {
        if (key.equalsIgnoreCase("title")) {
            return program.getTitle();
        }
        if (key.equalsIgnoreCase("original_title")) {
            return this.removeNull(program.getTextField(ProgramFieldType.ORIGINAL_TITLE_TYPE));
        }
        if (key.equalsIgnoreCase("origin")) {
            return this.removeNull(program.getTextField(ProgramFieldType.ORIGIN_TYPE));
        }
        if (key.equalsIgnoreCase("start_day")) {
            return String.valueOf(program.getDate().getDayOfMonth());
        }
        if (key.equalsIgnoreCase("start_month")) {
            return String.valueOf(program.getDate().getMonth());
        }
        if (key.equalsIgnoreCase("start_year")) {
            return String.valueOf(program.getDate().getYear());
        }
        if (key.equalsIgnoreCase("end_day")) {
            return String.valueOf(this.getEndTimeFieldInProgram(program, 5));
        }
        if (key.equalsIgnoreCase("end_month")) {
            return String.valueOf(this.getEndTimeFieldInProgram(program, 2) + 1);
        }
        if (key.equalsIgnoreCase("end_year")) {
            return String.valueOf(this.getEndTimeFieldInProgram(program, 1));
        }
        if (key.equalsIgnoreCase("start_hour")) {
            return String.valueOf(program.getHours());
        }
        if (key.equalsIgnoreCase("start_minute")) {
            return String.valueOf(program.getMinutes());
        }
        if (key.equalsIgnoreCase("end_hour")) {
            return String.valueOf(this.getEndTimeFieldInProgram(program, 11));
        }
        if (key.equalsIgnoreCase("end_minute")) {
            return String.valueOf(this.getEndTimeFieldInProgram(program, 12));
        }
        if (key.equalsIgnoreCase("length_minutes")) {
            return String.valueOf(program.getLength());
        }
        if (key.equalsIgnoreCase("length_sec")) {
            return String.valueOf(program.getLength() * 60);
        }
        if (key.equalsIgnoreCase("short_info")) {
            return this.removeNull(program.getShortInfo());
        }
        if (key.equalsIgnoreCase("description")) {
            String res = this.removeNull(program.getDescription());
            String copyright = program.getChannel().getCopyrightNotice();
            if (copyright != null) {
                return res + '\n' + copyright;
            }
            return res;
        }
        if (key.equalsIgnoreCase("episode")) {
            return this.removeNull(program.getTextField(ProgramFieldType.EPISODE_TYPE));
        }
        if (key.equalsIgnoreCase("original_episode")) {
            return this.removeNull(program.getTextField(ProgramFieldType.ORIGINAL_EPISODE_TYPE));
        }
        if (key.equalsIgnoreCase("channel_name")) {
            return this.removeNull(program.getChannel().getName());
        }
        if (key.equalsIgnoreCase("channel_sort_number")) {
            return this.removeNull(program.getChannel().getSortNumber());
        }
        if (key.equalsIgnoreCase("url")) {
            return this.removeNull(program.getTextField(ProgramFieldType.URL_TYPE));
        }
        if (key.equalsIgnoreCase("start_day_of_week")) {
            SimpleDateFormat format = new SimpleDateFormat("EEEE");
            return format.format(new Date(program.getDate().getCalendar().getTimeInMillis()));
        }
        if (key.equalsIgnoreCase("start_month_name")) {
            SimpleDateFormat format = new SimpleDateFormat("MMMM");
            return format.format(new Date(program.getDate().getCalendar().getTimeInMillis()));
        }
        if (key.equalsIgnoreCase("start_unix")) {
            return Long.toString(this.createStartTime(program).getTimeInMillis() / 1000L);
        }
        if (key.equalsIgnoreCase("end_unix")) {
            return Long.toString(this.createEndTime(program).getTimeInMillis() / 1000L);
        }
        if (key.equalsIgnoreCase("custom")) {
            return this.removeNull(program.getTextField(ProgramFieldType.CUSTOM_TYPE));
        }
        if (key.equalsIgnoreCase("genre")) {
            return this.removeNull(program.getTextField(ProgramFieldType.GENRE_TYPE));
        }
        if (key.equalsIgnoreCase("episode_number")) {
            int epNum = program.getIntField(ProgramFieldType.EPISODE_NUMBER_TYPE);
            if (epNum == -1) {
                return "";
            }
            return Integer.toString(epNum);
        }
        if (key.equalsIgnoreCase("production_year")) {
            int productionYear = program.getIntField(ProgramFieldType.PRODUCTION_YEAR_TYPE);
            if (productionYear < 1800) {
                return "";
            }
            return Integer.toString(productionYear);
        }
        if (key.equalsIgnoreCase("actors")) {
            return this.removeNull(program.getTextField(ProgramFieldType.ACTOR_LIST_TYPE));
        }
        this.mError = true;
        this.mErrorString = mLocalizer.msg("unkownParam", "Unknown Parameter") + ": '" + key + "'";
        return null;
    }

    private String removeNull(String str) {
        if (str == null) {
            str = "";
        }
        return str;
    }

    private int getEndTimeFieldInProgram(Program prg, int field) {
        Calendar c = this.createEndTime(prg);
        return c.get(field);
    }

    private Calendar createStartTime(Program prg) {
        Calendar c = (Calendar)prg.getDate().getCalendar().clone();
        c.set(11, prg.getHours());
        c.set(12, prg.getMinutes());
        c.set(13, 0);
        return c;
    }

    private Calendar createEndTime(Program prg) {
        Calendar c = (Calendar)prg.getDate().getCalendar().clone();
        c.set(11, prg.getHours());
        c.set(12, prg.getMinutes());
        c.add(12, prg.getLength());
        c.set(13, 0);
        return c;
    }

    public String getStringForFunction(Program prg, String function, String[] params) {
        if (function.equalsIgnoreCase("isset")) {
            if (params.length != 2) {
                this.mError = true;
                this.mErrorString = mLocalizer.msg("isset2Params", "isset needs 2 Parameters");
                return null;
            }
            if (params[0] != null && params[0].length() > 0) {
                return params[0];
            }
            return params[1];
        }
        if (function.equalsIgnoreCase("testparam")) {
            if (params.length < 2 || params.length > 3) {
                this.mError = true;
                this.mErrorString = mLocalizer.msg("testparam2Params", "testparam needs 2-3 Parameters");
                return null;
            }
            if (params[0] != null && params[0].length() > 0) {
                return params[1];
            }
            if (params.length == 3) {
                return params[2];
            }
            return "";
        }
        if (function.equalsIgnoreCase("urlencode")) {
            if (params.length != 2) {
                this.mError = true;
                this.mErrorString = mLocalizer.msg("urlencode2Params", "urlencode needs 2 Parameters");
                return null;
            }
            try {
                return URLEncoder.encode(params[0], params[1]);
            }
            catch (Exception e) {
                this.mError = true;
                this.mErrorString = mLocalizer.msg("urlencodeProblems", "Problems with encoding : ") + e.toString();
                return null;
            }
        }
        if (function.equalsIgnoreCase("concat")) {
            StringBuilder buffer = new StringBuilder();
            for (String param : params) {
                buffer.append(param);
            }
            return buffer.toString();
        }
        if (function.equalsIgnoreCase("clean")) {
            StringBuilder buffer = new StringBuilder();
            for (String param : params) {
                buffer.append(this.clean(param));
            }
            return buffer.toString();
        }
        if (function.equalsIgnoreCase("cleanLess")) {
            StringBuilder buffer = new StringBuilder();
            for (String param : params) {
                buffer.append(this.cleanLess(param));
            }
            return buffer.toString();
        }
        if (function.equalsIgnoreCase("leadingZero")) {
            if (params.length > 2) {
                this.mError = true;
                this.mErrorString = mLocalizer.msg("leadingZero2Params", "leadingZero has max. 2 Parameters");
                return null;
            }
            int num = 2;
            if (params.length == 2) {
                try {
                    num = Integer.parseInt(params[1]);
                }
                catch (Exception ex) {
                    this.mError = true;
                    this.mErrorString = mLocalizer.msg("leadingZeroProblems", "Could not parse Number") + " : " + params[1];
                    return null;
                }
            }
            return this.addLeadingZeros(params[0], num);
        }
        if (function.equalsIgnoreCase("splitAt")) {
            if (params.length != 2) {
                this.mError = true;
                this.mErrorString = mLocalizer.msg("splitAt2Params", "splitAt needs 2 Parameters");
                return null;
            }
            int num = 2;
            try {
                num = Integer.parseInt(params[1]);
            }
            catch (Exception ex) {
                this.mError = true;
                this.mErrorString = mLocalizer.msg("splitAtNumberProblems", "Could not parse Number") + " : " + params[1];
                return null;
            }
            TextLineBreakerStringWidth breaker = new TextLineBreakerStringWidth();
            StringBuilder result = new StringBuilder();
            try {
                String[] lines;
                for (String line : lines = breaker.breakLines(new StringReader(params[0]), num)) {
                    result.append(line);
                    result.append('\n');
                }
            }
            catch (Exception ex) {
                this.mError = true;
                this.mErrorString = mLocalizer.msg("splitAtSplitProblems", "Could not split String") + " :\n " + ex.toString();
                return null;
            }
            return result.toString().trim();
        }
        if (function.equalsIgnoreCase("maxlength")) {
            if (params.length != 2) {
                this.mError = true;
                this.mErrorString = mLocalizer.msg("maxlength2Params", "maxlength needs 2 Parameters");
                return null;
            }
            int num = -1;
            try {
                num = Integer.parseInt(params[1]);
            }
            catch (Exception ex) {
                this.mError = true;
                this.mErrorString = mLocalizer.msg("maxlengthNumberProblems", "Could not parse Number") + " : " + params[1];
                return null;
            }
            String result = params[0];
            if (result.length() > num) {
                result = result.substring(0, num);
            }
            return result;
        }
        if (function.equalsIgnoreCase("replace")) {
            String[] replaceValues;
            if (params.length != 2) {
                this.mError = true;
                this.mErrorString = mLocalizer.msg("replace2Params", "replace needs 2 Parameters");
                return null;
            }
            String haystack = params[0];
            for (String replace : replaceValues = params[1].split(",")) {
                if (!replace.contains("::")) {
                    this.mError = true;
                    this.mErrorString = mLocalizer.msg("replaceMissingColon", "Replace values need to contain two following colons");
                    return null;
                }
                String[] parts = replace.split("::");
                haystack = haystack.replace(parts[0], parts[1]);
            }
            return haystack;
        }
        this.mError = true;
        this.mErrorString = mLocalizer.msg("unknownFunction", "Unknown function : {0}", function);
        return null;
    }

    private String addLeadingZeros(String string, int num) {
        StringBuilder buffer = new StringBuilder(string);
        while (buffer.length() < num) {
            buffer.insert(0, '0');
        }
        return buffer.toString();
    }

    private String clean(String clean) {
        char[] chars;
        StringBuilder buffer = new StringBuilder();
        for (char c : chars = clean.trim().toCharArray()) {
            if (c >= 'A' && c <= 'Z') {
                buffer.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                buffer.append(c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                buffer.append(c);
                continue;
            }
            buffer.append('_');
        }
        String retStr = buffer.toString();
        while (retStr.indexOf("__") >= 0) {
            retStr = StringUtils.replace(retStr, "__", "_");
        }
        return retStr;
    }

    private String cleanLess(String clean) {
        char[] chars;
        StringBuilder buffer = new StringBuilder();
        for (char c : chars = clean.trim().toCharArray()) {
            if (Character.isDigit(c) || Character.isLetter(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append('_');
        }
        String retStr = buffer.toString();
        while (retStr.indexOf("__") >= 0) {
            retStr = StringUtils.replace(retStr, "__", "_");
        }
        return retStr;
    }
}

