/*
 * Decompiled with CFR 0.152.
 */
package util.program;

import devplugin.Date;
import devplugin.Marker;
import devplugin.Plugin;
import devplugin.PluginAccess;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramInfo;
import devplugin.ProgramInfoHelper;
import devplugin.ToolTipIcon;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import util.program.CompoundedProgramFieldType;
import util.program.ProgramUtilities;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.html.ExtendedHTMLDocument;
import util.ui.html.HTMLTextHelper;
import util.ui.html.HorizontalLine;

public class ProgramTextCreator {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramTextCreator.class);
    private static String mBodyFontSize;
    public static final String TVBROWSER_URL_PROTOCOL = "tvbrowser://";

    public static String createInfoText(Program prog, ExtendedHTMLDocument doc, Object[] fieldArr, Font tFont, Font bFont, boolean showImage, boolean showHelpLinks) {
        return ProgramTextCreator.createInfoText(prog, doc, fieldArr, tFont, bFont, new ProgramPanelSettings(showImage ? 1 : 0, -1, -1, false, true, 10), showHelpLinks, 100);
    }

    public static String createInfoText(Program prog, ExtendedHTMLDocument doc, Object[] fieldArr, Font tFont, Font bFont, ProgramPanelSettings settings, boolean showHelpLinks, int zoom) {
        return ProgramTextCreator.createInfoText(prog, doc, fieldArr, tFont, bFont, settings, showHelpLinks, zoom, true);
    }

    public static String createInfoText(Program prog, ExtendedHTMLDocument doc, Object[] fieldArr, Font tFont, Font bFont, PluginPictureSettings settings, boolean showHelpLinks, int zoom) {
        return ProgramTextCreator.createInfoText(prog, doc, fieldArr, tFont, bFont, new ProgramPanelSettings(settings, false), showHelpLinks, zoom, true);
    }

    public static String createInfoText(Program prog, ExtendedHTMLDocument doc, Object[] fieldArr, Font tFont, Font bFont, ProgramPanelSettings settings, boolean showHelpLinks, int zoom, boolean showPluginIcons) {
        return ProgramTextCreator.createInfoText(prog, doc, fieldArr, tFont, bFont, settings, showHelpLinks, zoom, showPluginIcons, true);
    }

    public static String createInfoText(Program prog, ExtendedHTMLDocument doc, Object[] fieldArr, Font tFont, Font bFont, ProgramPanelSettings settings, boolean showHelpLinks, int zoom, boolean showPluginIcons, boolean showPersonLinks) {
        return ProgramTextCreator.createInfoText(prog, doc, fieldArr, tFont, bFont, settings, showHelpLinks, zoom, showPluginIcons, showPersonLinks, false);
    }

    public static String createInfoText(Program prog, ExtendedHTMLDocument doc, Object[] fieldArr, Font tFont, Font bFont, ProgramPanelSettings settings, boolean showHelpLinks, int zoom, boolean showPluginIcons, boolean showPersonLinks, boolean useThemeColors) {
        Color foreground = Color.black;
        Color background = Color.white;
        Color infoColor = Color.gray;
        Color episodeColor = new Color(0, 51, 102);
        if (useThemeColors) {
            foreground = UIManager.getColor("List.foreground");
            background = UIManager.getColor("List.background");
            int r = foreground.getRed() + background.getRed() >> 1;
            int g = foreground.getGreen() + background.getGreen() >> 1;
            int b = foreground.getBlue() + background.getBlue() >> 1;
            infoColor = new Color(r, g, b);
            double testBackground = 0.2126 * (double)background.getRed() + 0.7152 * (double)background.getGreen() + 0.0722 * (double)background.getBlue();
            double testInfoColor = 0.2126 * (double)infoColor.getRed() + 0.7152 * (double)infoColor.getGreen() + 0.0722 * (double)infoColor.getBlue();
            double testInfoEpisode = 0.2126 * (double)episodeColor.getRed() + 0.7152 * (double)episodeColor.getGreen() + 0.0722 * (double)episodeColor.getBlue();
            if (testBackground - testInfoColor > 90.0) {
                infoColor = new Color(infoColor.getRed() + 30, infoColor.getGreen() + 30, infoColor.getBlue() + 30);
            }
            if (testBackground - testInfoEpisode < -30.0) {
                episodeColor = episodeColor.brighter().brighter();
            }
        }
        String debugTables = "0";
        try {
            byte[] image;
            int titleStyle;
            int bodyStyle;
            String titleSize;
            String titleFont;
            String bodyFont;
            StringBuilder buffer = new StringBuilder(1024);
            if (tFont == null && bFont != null) {
                titleFont = bodyFont = bFont.getFamily();
                titleSize = mBodyFontSize = String.valueOf(bFont.getSize());
                titleStyle = bodyStyle = bFont.getStyle();
            } else if (tFont != null && bFont != null) {
                titleFont = tFont.getFamily();
                bodyFont = bFont.getFamily();
                titleSize = String.valueOf(tFont.getSize());
                mBodyFontSize = String.valueOf(bFont.getSize());
                titleStyle = tFont.getStyle();
                bodyStyle = bFont.getStyle();
            } else {
                return null;
            }
            if (fieldArr == null) {
                return null;
            }
            buffer.append("<html>");
            buffer.append("<table width=\"100%\" border=\"" + debugTables + "\" style=\"font-family:");
            buffer.append(bodyFont);
            buffer.append(";").append("background-color:").append(HTMLTextHelper.getCssRgbColorEntry(background)).append(";").append(ProgramTextCreator.getCssStyle(bodyStyle)).append("\"><tr>");
            buffer.append("<td width=\"60\">");
            buffer.append("<p \"align=center\">");
            JLabel channelLogo = new JLabel(prog.getChannel().getIcon());
            channelLogo.setBackground(Color.white);
            channelLogo.setOpaque(true);
            channelLogo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            channelLogo.setToolTipText(prog.getChannel().getName());
            buffer.append(doc.createCompTag(channelLogo));
            buffer.append("</p></td><td><table width=\"100%\" border=\"" + debugTables + "\" cellpadding=\"0\"><tr><td>");
            buffer.append("<div style=\"color:#ff0000; font-size:");
            buffer.append(mBodyFontSize);
            buffer.append(";\"><b>");
            Date currentDate = Date.getCurrentDate();
            Date programDate = prog.getDate();
            if (programDate.equals(currentDate.addDays(-1))) {
                buffer.append(Localizer.getLocalization("i18n_yesterday"));
                buffer.append(" \u00b7 ");
            } else if (programDate.equals(currentDate)) {
                buffer.append(Localizer.getLocalization("i18n_today"));
                buffer.append(" \u00b7 ");
            } else if (programDate.equals(currentDate.addDays(1))) {
                buffer.append(Localizer.getLocalization("i18n_tomorrow"));
                buffer.append(" \u00b7 ");
            }
            buffer.append(prog.getDateString());
            buffer.append(" \u00b7 ");
            buffer.append(prog.getTimeString());
            if (prog.getLength() > 0) {
                buffer.append('-');
                buffer.append(prog.getEndTimeString());
            }
            buffer.append(" \u00b7 ");
            buffer.append(prog.getChannel());
            buffer.append("</b></div>");
            String seriesField = prog.getTextField(ProgramFieldType.SERIES_TYPE);
            if (seriesField != null) {
                buffer.append("<div style=\"color:" + HTMLTextHelper.getCssRgbColorEntry(episodeColor) + "; margin-top:1em; font-size:");
                buffer.append(mBodyFontSize);
                buffer.append(";\"><b>");
                buffer.append(HTMLTextHelper.convertTextToHtml(seriesField, false));
                buffer.append("</b></div>");
            }
            buffer.append("<div style=\"color:" + HTMLTextHelper.getCssRgbColorEntry(episodeColor) + "; font-size:");
            buffer.append(titleSize);
            buffer.append("; margin-top:0.5em; margin-bottom:0.5em; font-family:");
            buffer.append(titleFont).append(";").append(ProgramTextCreator.getCssStyle(titleStyle));
            buffer.append("\">");
            buffer.append(prog.getTitle());
            buffer.append("</div>");
            String episode = CompoundedProgramFieldType.EPISODE_COMPOSITION.getFormattedValueForProgram(prog);
            if (episode != null && episode.trim().length() > 0) {
                buffer.append("<div style=\"color:").append(HTMLTextHelper.getCssRgbColorEntry(infoColor)).append("; font-size:");
                buffer.append(mBodyFontSize);
                buffer.append("\">");
                buffer.append(episode);
                buffer.append("</div>");
            }
            buffer.append("</td><td align=\"right\" valign=\"top\"><table border=\"" + debugTables + "\" style=\"font-size:0\">");
            buffer.append("</table></td></tr></table></td></tr>");
            boolean show = false;
            if (settings.isShowingPictureForPlugins()) {
                String[] pluginIds = settings.getPluginIds();
                Marker[] markers = prog.getMarkerArr();
                if (markers != null && pluginIds != null) {
                    block6: for (Marker marker : markers) {
                        for (String pluginId : pluginIds) {
                            if (marker.getId().compareTo(pluginId) != 0) continue;
                            show = true;
                            continue block6;
                        }
                    }
                }
            }
            if ((settings.isShowingPictureEver() || settings.isShowingPictureInTimeRange() && !ProgramUtilities.isNotInTimeRange(settings.getPictureTimeRangeStart(), settings.getPictureTimeRangeEnd(), prog) || show || settings.isShowingPictureForDuration() && settings.getDuration() <= prog.getLength()) && (image = prog.getBinaryField(ProgramFieldType.PICTURE_TYPE)) != null) {
                String line = "<tr><td></td><td valign=\"top\" style=\"color:" + HTMLTextHelper.getCssRgbColorEntry(foreground) + "; font-size:0\">";
                buffer.append(line);
                try {
                    ImageIcon imageIcon = new ImageIcon(image);
                    if (zoom != 100) {
                        imageIcon = (ImageIcon)UiUtilities.scaleIcon(imageIcon, imageIcon.getIconWidth() * zoom / 100);
                    }
                    StringBuilder value = new StringBuilder();
                    String textField = prog.getTextField(ProgramFieldType.PICTURE_COPYRIGHT_TYPE);
                    if (textField != null) {
                        if (textField.toLowerCase().startsWith("(c)")) {
                            textField = "\u00a9" + textField.substring(3);
                        }
                        value.append(textField);
                    }
                    if (settings.isShowingPictureDescription() && (textField = prog.getTextField(ProgramFieldType.PICTURE_DESCRIPTION_TYPE)) != null) {
                        value.append("<br>").append(textField);
                    }
                    buffer.append(doc.createCompTag(new JLabel(imageIcon)));
                    buffer.append("<div style=\"font-size:");
                    buffer.append(mBodyFontSize);
                    buffer.append("\">");
                    buffer.append((CharSequence)value);
                    buffer.append("</div>");
                    buffer.append("</td></tr>");
                }
                catch (Exception e) {
                    buffer.delete(buffer.length() - line.length(), buffer.length());
                }
            }
            Marker[] pluginArr = prog.getMarkerArr();
            if (showPluginIcons && pluginArr != null && pluginArr.length != 0) {
                ProgramTextCreator.addSeparator(doc, buffer);
                buffer.append("<tr><td valign=\"top\" style=\"color:").append(HTMLTextHelper.getCssRgbColorEntry(infoColor)).append("; font-size:");
                buffer.append(mBodyFontSize);
                buffer.append("\"><b>");
                buffer.append(mLocalizer.msg("markedBy", "Marked by"));
                buffer.append("</b></td><td valign=\"middle\" style=\"font-size:4\">");
                ProgramTextCreator.openPara(buffer, "info");
                buffer.append("&nbsp;");
                for (int markerCount = pluginArr.length - 1; markerCount >= 0; --markerCount) {
                    Icon[] icons = pluginArr[markerCount].getMarkIcons(prog);
                    if (icons == null) continue;
                    for (int i = icons.length - 1; i >= 0; --i) {
                        JLabel iconLabel = new JLabel(icons[i]);
                        PluginAccess plugin = Plugin.getPluginManager().getActivatedPluginForId(pluginArr[markerCount].getId());
                        if (plugin != null) {
                            iconLabel.setToolTipText(plugin.getInfo().getName());
                        } else {
                            InternalPluginProxyIf internalPlugin = InternalPluginProxyList.getInstance().getProxyForId(pluginArr[markerCount].getId());
                            if (internalPlugin != null) {
                                iconLabel.setToolTipText(internalPlugin.getName());
                                if (internalPlugin.equals(FavoritesPluginProxy.getInstance())) {
                                    StringBuilder favTitles = new StringBuilder();
                                    for (Favorite favorite : FavoriteTreeModel.getInstance().getFavoritesContainingProgram(prog)) {
                                        if (favTitles.length() > 0) {
                                            favTitles.append(", ");
                                        }
                                        favTitles.append(favorite.getName());
                                    }
                                    if (favTitles.length() > 0) {
                                        iconLabel.setToolTipText(iconLabel.getToolTipText() + " (" + favTitles.toString() + ")");
                                    }
                                }
                            } else {
                                iconLabel.setToolTipText(pluginArr[markerCount].toString());
                            }
                        }
                        buffer.append(doc.createCompTag(iconLabel));
                        buffer.append("&nbsp;&nbsp;");
                    }
                }
                ProgramTextCreator.closePara(buffer);
                buffer.append("</td></tr>");
            }
            PluginAccess[] plugins = Plugin.getPluginManager().getActivatedPlugins();
            ArrayList<JLabel> iconLabels = new ArrayList<JLabel>();
            for (PluginAccess plugin : plugins) {
                Icon[] icons = plugin.getProgramTableIcons(prog);
                ToolTipIcon[] toolTips = plugin.getProgramTableToolTipIcons(prog);
                String singleText = plugin.getProgramTableIconText();
                if (icons == null) continue;
                for (int i = 0; i < icons.length; ++i) {
                    JLabel iconLabel = new JLabel(icons[i]);
                    if (toolTips != null && toolTips.length > i) {
                        iconLabel.setToolTipText(toolTips[i].toString());
                    } else if (singleText != null) {
                        iconLabel.setToolTipText(singleText);
                    } else {
                        iconLabel.setToolTipText(plugin.getInfo().getName());
                    }
                    iconLabels.add(iconLabel);
                }
            }
            if (showPluginIcons && iconLabels.size() > 0) {
                ProgramTextCreator.addSeparator(doc, buffer);
                buffer.append("<tr><td valign=\"middle\" style=\"color:").append(HTMLTextHelper.getCssRgbColorEntry(infoColor)).append("; font-size:");
                buffer.append(mBodyFontSize);
                buffer.append("\"><b>");
                buffer.append("Plugin-Icons");
                buffer.append("</b></td><td valign=\"middle\" style=\"font-size:4\">");
                ProgramTextCreator.openPara(buffer, "info");
                buffer.append("&nbsp;");
                for (JLabel iconLabel : iconLabels) {
                    buffer.append(doc.createCompTag(iconLabel));
                    buffer.append("&nbsp;&nbsp;");
                }
                ProgramTextCreator.closePara(buffer);
                buffer.append("</td></tr>");
            }
            ProgramTextCreator.addSeparator(doc, buffer);
            for (Object id : fieldArr) {
                int i;
                ProgramFieldType type = null;
                if (id instanceof String) {
                    int length;
                    if (((String)id).matches("\\d+")) {
                        try {
                            type = ProgramFieldType.getTypeForId(Integer.parseInt((String)id, 10));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (type != null || (length = prog.getLength()) <= 0 || ((String)id).trim().length() <= 0) continue;
                    buffer.append("<tr><td valign=\"top\" style=\"color:").append(HTMLTextHelper.getCssRgbColorEntry(infoColor)).append("; font-size:");
                    buffer.append(mBodyFontSize);
                    buffer.append("\"><b>");
                    buffer.append(mLocalizer.msg("duration", "Program duration/<br>-end"));
                    buffer.append("</b></td><td style=\"color:").append(HTMLTextHelper.getCssRgbColorEntry(foreground)).append("; font-size:");
                    buffer.append(mBodyFontSize);
                    buffer.append("\">");
                    ProgramTextCreator.openPara(buffer, "time");
                    String msg = mLocalizer.msg("minutes", "{0} min", length);
                    buffer.append(msg).append(" (");
                    buffer.append(mLocalizer.msg("until", "until {0}", prog.getEndTimeString()));
                    int netLength = prog.getIntField(ProgramFieldType.NET_PLAYING_TIME_TYPE);
                    if (netLength != -1) {
                        msg = mLocalizer.msg("netMinuted", "{0} min net", netLength);
                        buffer.append(" - ").append(msg);
                    }
                    buffer.append(')');
                    ProgramTextCreator.closePara(buffer);
                    buffer.append("</td></tr>");
                    ProgramTextCreator.addSeparator(doc, buffer);
                    continue;
                }
                if (id instanceof ProgramInfo) {
                    ProgramInfo[] infos;
                    String pluginId = ((ProgramInfo)id).getPluginId();
                    PluginProxy plugin = PluginProxyManager.getInstance().getActivatedPluginForId(pluginId);
                    if (plugin == null) continue;
                    for (ProgramInfo info : infos = plugin.getAddtionalProgramInfoForProgram(prog, ((ProgramInfo)id).getUniqueId())) {
                        buffer.append("<tr><td valign=\"top\" style=\"color:").append(HTMLTextHelper.getCssRgbColorEntry(infoColor)).append("; font-size:");
                        buffer.append(mBodyFontSize);
                        buffer.append("\"><b>");
                        buffer.append(info.getName());
                        buffer.append("</b></td><td style=\"color:").append(HTMLTextHelper.getCssRgbColorEntry(foreground)).append("; font-size:");
                        buffer.append(mBodyFontSize);
                        buffer.append("\">");
                        buffer.append((String)info.getValue());
                        buffer.append("</td></tr>");
                        ProgramTextCreator.addSeparator(doc, buffer);
                    }
                    continue;
                }
                if (id instanceof CompoundedProgramFieldType) {
                    CompoundedProgramFieldType value = (CompoundedProgramFieldType)id;
                    String entry = value.getFormattedValueForProgram(prog);
                    if (entry == null) continue;
                    ProgramTextCreator.startInfoSection(buffer, value.getName(), infoColor, foreground);
                    buffer.append(HTMLTextHelper.convertTextToHtml(entry, false));
                    ProgramTextCreator.addSeparator(doc, buffer);
                    continue;
                }
                type = (ProgramFieldType)id;
                if (type == ProgramFieldType.DESCRIPTION_TYPE) {
                    String description = ProgramTextCreator.removeMultipleLineBreaksFromDescription(prog.getDescription());
                    if (description != null && description.length() > 0) {
                        ProgramTextCreator.addEntry(doc, buffer, prog, ProgramFieldType.DESCRIPTION_TYPE, true, showHelpLinks, showPersonLinks, infoColor, foreground);
                        continue;
                    }
                    ProgramTextCreator.addEntry(doc, buffer, prog, ProgramFieldType.SHORT_DESCRIPTION_TYPE, true, showHelpLinks, showPersonLinks, infoColor, foreground);
                    continue;
                }
                if (type == ProgramFieldType.INFO_TYPE) {
                    int info = prog.getInfo();
                    if (info == -1 || info == 0) continue;
                    buffer.append("<tr><td valign=\"top\" style=\"color:").append(HTMLTextHelper.getCssRgbColorEntry(infoColor)).append("; font-size:");
                    buffer.append(mBodyFontSize);
                    buffer.append("\"><b>");
                    buffer.append(type.getLocalizedName());
                    buffer.append("</b></td><td valign=\"middle\" style=\"font-size:5\">");
                    ProgramTextCreator.openPara(buffer, "info");
                    buffer.append("&nbsp;");
                    int[] infoBitArr = ProgramInfoHelper.getInfoBits();
                    Icon[] infoIconArr = ProgramInfoHelper.getInfoIcons();
                    String[] infoMsgArr = ProgramInfoHelper.getInfoIconMessages();
                    for (i = 0; i < infoBitArr.length; ++i) {
                        if (!ProgramInfoHelper.bitSet(info, infoBitArr[i])) continue;
                        JLabel iconLabel = infoIconArr[i] != null ? new JLabel(infoIconArr[i]) : new JLabel(infoMsgArr[i]);
                        iconLabel.setToolTipText(infoMsgArr[i]);
                        buffer.append(doc.createCompTag(iconLabel));
                        buffer.append("&nbsp;&nbsp;");
                    }
                    ProgramTextCreator.closePara(buffer);
                    buffer.append("</td></tr>");
                    ProgramTextCreator.addSeparator(doc, buffer);
                    continue;
                }
                if (type == ProgramFieldType.ADDITIONAL_INFORMATION_TYPE) {
                    ProgramTextCreator.addEntry(doc, buffer, prog, ProgramFieldType.ADDITIONAL_INFORMATION_TYPE, true, showHelpLinks, showPersonLinks, infoColor, foreground);
                    continue;
                }
                if (type == ProgramFieldType.URL_TYPE) {
                    ProgramTextCreator.addEntry(doc, buffer, prog, ProgramFieldType.URL_TYPE, true, showHelpLinks, showPersonLinks, infoColor, foreground);
                    continue;
                }
                if (type == ProgramFieldType.ACTOR_LIST_TYPE) {
                    String actorField;
                    ArrayList<String> knownNames = new ArrayList<String>();
                    String[] recognizedActors = ProgramUtilities.getActorNames(prog);
                    if (recognizedActors != null) {
                        knownNames.addAll(Arrays.asList(recognizedActors));
                    }
                    if ((actorField = prog.getTextField(type)) == null) continue;
                    ArrayList<String>[] lists = ProgramUtilities.splitActors(prog);
                    if (lists == null) {
                        lists = ProgramTextCreator.splitActorsSimple(prog);
                    }
                    if (lists != null && lists[0].size() > 0) {
                        ProgramTextCreator.startInfoSection(buffer, type.getLocalizedName(), infoColor, foreground);
                        buffer.append("<table border=\"0\" cellpadding=\"0\" style=\"font-family:");
                        buffer.append(bodyFont);
                        buffer.append(";\">");
                        for (i = 0; i < lists[0].size(); ++i) {
                            String[] parts = new String[]{lists[0].get(i), ""};
                            if (i < lists[1].size()) {
                                parts[1] = lists[1].get(i);
                            }
                            int actorIndex = 0;
                            if (showPersonLinks) {
                                if (knownNames.contains(parts[0])) {
                                    parts[0] = ProgramTextCreator.addPersonLink(parts[0], foreground);
                                } else if (knownNames.contains(parts[1])) {
                                    parts[1] = ProgramTextCreator.addPersonLink(parts[1], foreground);
                                    actorIndex = 1;
                                }
                            }
                            buffer.append("<tr><td valign=\"top\">&#8226;&nbsp;</td><td valign=\"top\">");
                            buffer.append(parts[actorIndex]);
                            buffer.append("</td><td width=\"10\">&nbsp;</td>");
                            if (parts[1 - actorIndex].length() > 0) {
                                buffer.append("<td valign=\"top\">");
                                buffer.append(parts[1 - actorIndex]);
                                buffer.append("</td>");
                            } else if (i + 1 < lists[0].size() && lists[1].size() == 0) {
                                ++i;
                                buffer.append("<td valign=\"top\">&#8226;&nbsp;</td><td valign=\"top\">");
                                if (showPersonLinks) {
                                    buffer.append(ProgramTextCreator.addSearchLink(lists[0].get(i), foreground));
                                } else {
                                    buffer.append(lists[0].get(i));
                                }
                                buffer.append("</td>");
                            }
                            buffer.append("</td></tr>");
                        }
                        buffer.append("</table>");
                        buffer.append("</td></tr>");
                        ProgramTextCreator.addSeparator(doc, buffer);
                        continue;
                    }
                    ProgramTextCreator.addEntry(doc, buffer, prog, type, showHelpLinks, showPersonLinks, infoColor, foreground);
                    continue;
                }
                ProgramTextCreator.addEntry(doc, buffer, prog, type, showHelpLinks, showPersonLinks, infoColor, foreground);
            }
            if (showHelpLinks) {
                buffer.append("<tr><td colspan=\"2\" valign=\"top\" align=\"center\" style=\"color:").append(HTMLTextHelper.getCssRgbColorEntry(infoColor)).append("; font-size:");
                buffer.append(mBodyFontSize).append("\">");
                buffer.append("<a href=\"");
                buffer.append(mLocalizer.msg("dataInfo", "http://wiki.tvbrowser.org/index.php/Qualit%C3%A4t_der_Daten")).append("\">");
                buffer.append(mLocalizer.msg("dataQuality", "Details of the data quality"));
                buffer.append("</a>");
                buffer.append("</td></tr>");
            }
            buffer.append("</table></html>");
            return buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String getCssStyle(int style) {
        StringBuilder result = new StringBuilder();
        if ((style & 1) == 1) {
            result.append("font-weight:bold;");
        }
        if ((style & 2) == 2) {
            result.append("font-style:italic;");
        }
        return result.toString();
    }

    private static String removeMultipleLineBreaksFromDescription(String desc) {
        if (desc != null) {
            desc = desc.replaceAll("\n{3,}", "\n\n");
        }
        return desc;
    }

    private static String addPersonLink(String name, Color foreground) {
        if (name == null || name.isEmpty()) {
            return mLocalizer.msg("unknown", "(unknown)");
        }
        return ProgramTextCreator.addSearchLink(name, foreground);
    }

    private static ArrayList<String>[] splitActorsSimple(Program prog) {
        String[] actors;
        ArrayList<String> list1 = new ArrayList<String>();
        ArrayList<String> list2 = new ArrayList<String>();
        String actorField = prog.getTextField(ProgramFieldType.ACTOR_LIST_TYPE).trim();
        if (actorField.contains("\n")) {
            if (actorField.contains(",")) {
                return null;
            }
            actors = actorField.split("\n");
        } else if (actorField.contains(",")) {
            actors = actorField.split(",");
        } else if (actorField.contains("\t")) {
            actors = new String[]{actorField};
        } else {
            return null;
        }
        for (String actor : actors) {
            if ((actor = actor.trim()).length() <= 0) continue;
            String part1 = actor;
            String part2 = "";
            if (actor.contains("\t")) {
                part1 = StringUtils.substringBefore(actor, "\t").trim();
                part2 = StringUtils.substringAfter(actor, "\t").trim();
            } else if (actor.contains("(") && actor.contains(")")) {
                part1 = actor.substring(0, actor.indexOf("(")).trim();
                part2 = actor.substring(actor.indexOf("(") + 1, actor.lastIndexOf(")")).trim();
            }
            list1.add(part1);
            list2.add(part2);
        }
        ArrayList[] result = new ArrayList[]{list1, list2};
        return result;
    }

    private static String addSearchLink(String topic, String displayText, Color foreground) {
        String style = " style=\"color:" + HTMLTextHelper.getCssRgbColorEntry(foreground) + "; border-bottom: 1px dashed;\"";
        StringBuilder buffer = new StringBuilder(32);
        buffer.append("<a href=\"");
        buffer.append(TVBROWSER_URL_PROTOCOL);
        buffer.append(StringUtils.remove(StringUtils.remove(topic, '\"'), '\''));
        buffer.append("\" ");
        buffer.append(style);
        buffer.append('>');
        buffer.append(displayText);
        buffer.append("</a>");
        return buffer.toString();
    }

    private static String addSearchLink(String topic, Color foreground) {
        if (topic == null || topic.isEmpty()) {
            return "";
        }
        return ProgramTextCreator.addSearchLink(topic, topic, foreground);
    }

    private static void addEntry(ExtendedHTMLDocument doc, StringBuilder buffer, Program prog, ProgramFieldType fieldType, boolean showHelpLinks, boolean showPersonLinks, Color infoColor, Color foreground) {
        ProgramTextCreator.addEntry(doc, buffer, prog, fieldType, false, showHelpLinks, showPersonLinks, infoColor, foreground);
    }

    private static void addEntry(ExtendedHTMLDocument doc, StringBuilder buffer, Program prog, ProgramFieldType fieldType, boolean createLinks, boolean showHelpLinks, boolean showPersonLinks, Color infoColor, Color foreground) {
        try {
            String text = null;
            String name = fieldType.getLocalizedName();
            int blank = name.indexOf(32, 16);
            if (blank > 0) {
                name = name.substring(0, blank) + "<br>" + name.substring(blank + 1);
            }
            if (fieldType.getFormat() == 3) {
                text = prog.getTextField(fieldType);
                if (fieldType == ProgramFieldType.SHORT_DESCRIPTION_TYPE) {
                    text = ProgramTextCreator.removeMultipleLineBreaksFromDescription(text);
                }
                if (fieldType == ProgramFieldType.DESCRIPTION_TYPE) {
                    String description;
                    text = description = ProgramTextCreator.removeMultipleLineBreaksFromDescription(prog.getDescription());
                    if (prog.getShortInfo() != null) {
                        StringBuilder shortInfo = new StringBuilder(ProgramTextCreator.removeMultipleLineBreaksFromDescription(prog.getShortInfo()).trim());
                        while (shortInfo.toString().endsWith(".")) {
                            shortInfo.deleteCharAt(shortInfo.length() - 1);
                        }
                        if (shortInfo.toString().endsWith("\u2026")) {
                            shortInfo.deleteCharAt(shortInfo.length() - 1);
                        }
                        if (!description.trim().startsWith(shortInfo.toString())) {
                            ProgramTextCreator.addEntry(doc, buffer, prog, ProgramFieldType.SHORT_DESCRIPTION_TYPE, true, showHelpLinks, infoColor, foreground);
                        }
                    }
                    text = text.replace("\\-", "");
                    text = HTMLTextHelper.convertTextToHtml(text, createLinks);
                    String[] lines = text.split("<br>");
                    String[] tags = new String[]{"von und mit", "pr\u0000E4entiert von", "mit", "film von", "moderation", "zu gast"};
                    block3: for (int i = 0; i < 2; ++i) {
                        if (lines.length <= i || lines[i].length() >= 60) continue;
                        String line = lines[i];
                        for (String tag : tags) {
                            if (!line.toLowerCase().startsWith(tag) && !line.toLowerCase().startsWith(tag + ':')) continue;
                            String personsString = line.substring(tag.length(), line.length()).trim();
                            if (personsString.startsWith(":")) {
                                personsString = personsString.substring(1).trim();
                            }
                            if (personsString.endsWith(".")) {
                                personsString = personsString.substring(0, personsString.length() - 1).trim();
                            }
                            String[] persons = personsString.split(" und ");
                            boolean doLink = true;
                            for (String person : persons) {
                                if (!person.isEmpty() && Character.isLetter(person.charAt(0)) && !Character.isLowerCase(person.charAt(0))) continue;
                                doLink = false;
                                break;
                            }
                            if (!doLink) continue;
                            for (String person : persons) {
                                String[] names = person.split(" ");
                                int partCount = names.length;
                                if (partCount < 2 || partCount >= 4) continue;
                                for (String n : names) {
                                    if (StringUtils.isAlpha(n)) continue;
                                    doLink = false;
                                }
                                if (!doLink) continue;
                                text = StringUtils.replaceOnce(text, person, ProgramTextCreator.addSearchLink(person, foreground));
                            }
                            continue block3;
                        }
                    }
                }
            } else if (fieldType.getFormat() == 5) {
                text = prog.getTimeFieldAsString(fieldType);
            } else if (fieldType.getFormat() == 4) {
                if (fieldType == ProgramFieldType.RATING_TYPE) {
                    int value = prog.getIntField(fieldType);
                    if (value > -1) {
                        text = new DecimalFormat("##.#").format((double)prog.getIntField(fieldType) / 10.0) + "/10";
                    }
                } else {
                    int age;
                    String ageRating;
                    text = prog.getIntFieldAsString(fieldType);
                    if (text == null && fieldType == ProgramFieldType.AGE_LIMIT_TYPE && (ageRating = prog.getTextField(ProgramFieldType.AGE_RATING_TYPE)) != null && !ageRating.isEmpty() && (age = ProgramUtilities.getAgeLimit(ageRating)) >= 0) {
                        text = Integer.toString(age);
                    }
                }
            }
            if (fieldType == ProgramFieldType.ORIGIN_TYPE) {
                String temp = prog.getIntFieldAsString(ProgramFieldType.PRODUCTION_YEAR_TYPE);
                if (temp != null && temp.trim().length() > 0) {
                    if (text == null || text.trim().length() < 1) {
                        name = ProgramFieldType.PRODUCTION_YEAR_TYPE.getLocalizedName();
                        text = temp;
                    } else {
                        name = name + "/<br>" + ProgramFieldType.PRODUCTION_YEAR_TYPE.getLocalizedName();
                        text = text + " " + temp;
                    }
                }
                if ((temp = prog.getIntFieldAsString(ProgramFieldType.LAST_PRODUCTION_YEAR_TYPE)) != null && temp.trim().length() > 0) {
                    if (text == null || text.trim().length() < 1) {
                        name = ProgramFieldType.LAST_PRODUCTION_YEAR_TYPE.getLocalizedName();
                        text = temp;
                    } else {
                        text = text + " - " + temp;
                    }
                }
            }
            if (text == null || text.trim().length() < 1) {
                if (ProgramFieldType.CUSTOM_TYPE == fieldType) {
                    text = mLocalizer.msg("noCustom", "No custom information ");
                } else {
                    return;
                }
            }
            ProgramTextCreator.startInfoSection(buffer, name, infoColor, foreground);
            if (ProgramFieldType.DIRECTOR_TYPE == fieldType || ProgramFieldType.SCRIPT_TYPE == fieldType || ProgramFieldType.CAMERA_TYPE == fieldType || ProgramFieldType.CUTTER_TYPE == fieldType || ProgramFieldType.MUSIC_TYPE == fieldType || ProgramFieldType.MODERATION_TYPE == fieldType || ProgramFieldType.ADDITIONAL_PERSONS_TYPE == fieldType || ProgramFieldType.PRODUCER_TYPE == fieldType) {
                if (showPersonLinks && text.length() < 200) {
                    if (text.endsWith(".")) {
                        text = text.substring(0, text.length() - 1);
                    }
                    String[] persons = ProgramTextCreator.splitPersons(text);
                    for (int i = 0; i < persons.length; ++i) {
                        String link;
                        int index;
                        boolean duplicate = false;
                        if (i < persons.length - 1) {
                            for (int j = i + 1; j < persons.length; ++j) {
                                if (!persons[i].equalsIgnoreCase(persons[j])) continue;
                                duplicate = true;
                                break;
                            }
                        }
                        if (duplicate) {
                            if ((text = text.replaceFirst(Pattern.quote(persons[i]), "").trim()).startsWith(",")) {
                                text = text.substring(1).trim();
                            }
                            text = text.replaceAll(",\\s*,", ",");
                            continue;
                        }
                        if (persons[i].trim().split(" ").length > 3) continue;
                        if (persons[i].contains("(")) {
                            index = persons[i].indexOf(40);
                            String topic = persons[i].substring(0, index).trim();
                            String j = ProgramTextCreator.addSearchLink(topic, foreground) + " " + persons[i].substring(index).trim();
                        }
                        if (persons[i].contains(":")) {
                            index = persons[i].indexOf(58) + 1;
                            String label = persons[i].substring(0, index).trim();
                            link = label + " " + ProgramTextCreator.addSearchLink(persons[i].substring(index).trim(), foreground);
                        } else {
                            link = ProgramTextCreator.addSearchLink(persons[i], foreground);
                        }
                        text = text.replace(persons[i], link);
                    }
                }
                buffer.append(text);
            } else if (ProgramFieldType.DESCRIPTION_TYPE == fieldType) {
                buffer.append(text);
            } else {
                buffer.append(HTMLTextHelper.convertTextToHtml(text, createLinks));
            }
            if (ProgramFieldType.CUSTOM_TYPE == fieldType && showHelpLinks) {
                buffer.append(" (<a href=\"").append(mLocalizer.msg("customInfo", "http://enwiki.tvbrowser.org/index.php/CustomInformation")).append("\">?</a>)");
            }
            if (ProgramFieldType.AGE_RATING_TYPE == fieldType && showHelpLinks) {
                ProgramTextCreator.addHelpLink(buffer, mLocalizer.msg("ratingInfo", "http://en.wikipedia.org/wiki/Motion_picture_rating_system"));
            }
            buffer.append("</td></tr>");
            ProgramTextCreator.addSeparator(doc, buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addHelpLink(StringBuilder buffer, String url) {
        buffer.append(" (<a href=\"").append(url).append("\">?</a>)");
    }

    private static String[] splitPersons(String textField) {
        return ProgramUtilities.splitPersons(textField);
    }

    private static void startInfoSection(StringBuilder buffer, String section, Color infoForeground, Color foreground) {
        buffer.append("<tr><td valign=\"top\" style=\"color:").append(HTMLTextHelper.getCssRgbColorEntry(infoForeground)).append("; font-size:");
        buffer.append(mBodyFontSize);
        buffer.append("\"><b>");
        if (section.length() > 21 && section.indexOf("<br") == -1) {
            int space = section.lastIndexOf(32);
            if (space > 1 && space < section.length() - 2) {
                buffer.append(section.substring(0, space)).append("<br>").append(section.substring(space + 1));
            }
        } else {
            buffer.append(section);
        }
        buffer.append("</b></td><td style=\"color:").append(HTMLTextHelper.getCssRgbColorEntry(foreground)).append("; font-size:");
        buffer.append(mBodyFontSize);
        buffer.append("\">");
    }

    private static void addSeparator(ExtendedHTMLDocument doc, StringBuilder buffer) {
        buffer.append("<tr><td colspan=\"2\">");
        buffer.append("<div style=\"font-size:0;\">").append(doc.createCompTag(new HorizontalLine())).append("</div></td></tr>");
    }

    private static void openPara(StringBuilder buffer, String style) {
        buffer.append("<div id=\"").append(style).append("\">");
    }

    private static void closePara(StringBuilder buffer) {
        buffer.append("</div>\n");
    }

    public static Object[] getDefaultOrder() {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(ProgramFieldType.GENRE_TYPE, ProgramFieldType.DESCRIPTION_TYPE, ProgramFieldType.ADDITIONAL_INFORMATION_TYPE, ProgramFieldType.RATING_TYPE, ProgramFieldType.ORIGIN_TYPE, ProgramFieldType.DIRECTOR_TYPE, ProgramFieldType.SCRIPT_TYPE, ProgramFieldType.ACTOR_LIST_TYPE, ProgramFieldType.MODERATION_TYPE, ProgramFieldType.MUSIC_TYPE, ProgramFieldType.PRODUCER_TYPE, ProgramFieldType.CAMERA_TYPE, ProgramFieldType.CUTTER_TYPE, ProgramFieldType.ADDITIONAL_PERSONS_TYPE, ProgramFieldType.URL_TYPE, ProgramFieldType.ORIGINAL_TITLE_TYPE, ProgramFieldType.ORIGINAL_EPISODE_TYPE, ProgramFieldType.PRODUCTION_COMPANY_TYPE, ProgramFieldType.REPETITION_OF_TYPE, ProgramFieldType.REPETITION_ON_TYPE, ProgramFieldType.AGE_LIMIT_TYPE, ProgramFieldType.INFO_TYPE, ProgramFieldType.VPS_TYPE, ProgramFieldType.CUSTOM_TYPE, ProgramTextCreator.getDurationTypeString()));
        Iterator<ProgramFieldType> iterator = ProgramFieldType.getTypeIterator();
        while (iterator.hasNext()) {
            ProgramFieldType type = iterator.next();
            if (type.getFormat() == 2 || list.contains(type) || type.equals(ProgramFieldType.SHORT_DESCRIPTION_TYPE) || type.equals(ProgramFieldType.PICTURE_COPYRIGHT_TYPE) || type.equals(ProgramFieldType.PICTURE_DESCRIPTION_TYPE) || type.equals(ProgramFieldType.TITLE_TYPE) || type.equals(ProgramFieldType.EPISODE_NUMBER_TYPE) || type.equals(ProgramFieldType.EPISODE_TOTAL_NUMBER_TYPE) || type.equals(ProgramFieldType.EPISODE_TYPE)) continue;
            list.add(type);
        }
        return list.toArray();
    }

    public static ProgramInfo[] getDefaultOrderOfActivatedPluginInfo() {
        PluginProxy[] activated;
        ArrayList<ProgramInfo> defaultOrderList = new ArrayList<ProgramInfo>();
        for (PluginProxy proxy : activated = PluginProxyManager.getInstance().getActivatedPlugins()) {
            ProgramInfo[] pluginProgramInfo = proxy.getAddtionalProgramInfoForProgram(PluginManagerImpl.getInstance().getExampleProgram(), null);
            if (pluginProgramInfo == null) continue;
            defaultOrderList.addAll(Arrays.asList(pluginProgramInfo));
        }
        return defaultOrderList.toArray(new ProgramInfo[defaultOrderList.size()]);
    }

    public static Object[] getDefaultOrderWithActivatedPluginInfo() {
        PluginProxy[] activated;
        ArrayList<Object> defaultOrderList = new ArrayList<Object>();
        Object[] defaultOrder = ProgramTextCreator.getDefaultOrder();
        defaultOrderList.addAll(Arrays.asList(defaultOrder));
        for (PluginProxy proxy : activated = PluginProxyManager.getInstance().getActivatedPlugins()) {
            ProgramInfo[] pluginProgramInfo = proxy.getAddtionalProgramInfoForProgram(PluginManagerImpl.getInstance().getExampleProgram(), null);
            if (pluginProgramInfo == null) continue;
            defaultOrderList.addAll(Arrays.asList(pluginProgramInfo));
        }
        return defaultOrderList.toArray();
    }

    public static String getDurationTypeString() {
        return mLocalizer.msg("duration", "Program duration/<br>-end").replaceAll("<br>", "");
    }
}

